"use strict";

/**
 * This is called when a user requests to to promote abot to the next stage.
 * You can set the current stage of the bot to the next one
 *
 * @param bp The botpress SDK
 * @param bot The complete configuration of the bot
 * @param users The list of users of that workspace (email, role)
 * @param pipeline The list of configured stages
 * @param hookResult The result of the hook which contains actions
 */
const stageChangeRequest = async () => {
  const request_user = users.find(u => u.email == bot.pipeline_status.stage_request.requested_by);

  if (!request_user || request_user.role !== 'admin.*') {
    /*
    we want to keep the bot in the current stage and until another user with the right role promotes it
    here would go an api call to your 3rd party notification service
    */
    hookResult.actions = [];
    return;
  }
};

return stageChangeRequest();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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