"use strict";

/**
 * This is an example of how to use Recast NLU instead of Botpress NLU
 * To enable this, remove the 'dot' before the name of this file
 */
const axios = require('axios');

const RECAST_TOKEN = process.env.RECAST_TOKEN || '<<your recast token here>>';
const eventTypes = ['text']; // Process only 'text' events

async function recastExtract() {
  if (eventTypes.includes(event.type)) {
    const {
      data
    } = await axios.post('https://api.recast.ai/train/v2/request', {
      text: event.preview
    }, {
      headers: {
        Authorization: 'Token ' + RECAST_TOKEN
      }
    });

    if (data && data.results) {
      /** TODO Here you will need to manipulate the format of these objects
       * so that they use the same format as Botpress NLU */
      event.nlu = event.nlu || {};
      event.nlu.intents = data.results.intents;
      event.nlu.entities = data.results.entities;
      event.nlu.language = data.results.language;
      event.nlu.sentiment = data.results.sentiment; // Disable Native NLU

      event.setFlag(bp.IO.WellKnownFlags.SKIP_NATIVE_NLU, true);
    }
  }
}

return recastExtract();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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