'use strict';
/**
 * This is called when the bot is on a new stage.
 *
 * @param bp The botpress SDK
 * @param previousBotConfig The complete configuration of the bot before stage change request
 * @param bot The complete configuration of the bot
 * @param users The list of users of that workspace (email, role)
 * @param stages The list of configured stages
 */

const stageChanged = async () => {
  // Any custom logic would go here
  // For example, send an email to the person who requested the stage change
  if (!previousBotConfig.pipeline_status.stage_request) {
    return;
  }

  const {
    requested_by: requesterEmail
  } = previousBotConfig.pipeline_status.stage_request;
  const {
    promoted_by,
    id: newStage
  } = bot.pipeline_status.current_stage;

  if (requesterEmail && promoted_by !== requesterEmail) {
    // Send the email here
    console.log(`Your bot ${bot.id} was promoted to stage ${newStage} by ${promoted_by}`);
  }
};

return stageChanged();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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