"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _choice = _interopRequireDefault(require("./choice"));

var _callApi = _interopRequireDefault(require("./callApi"));

var _slot = _interopRequireDefault(require("./slot"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const onServerStarted = async bp => {};

const onServerReady = async bp => {
  await _choice.default.setup(bp);
};

const onModuleUnmount = async bp => {
  bp.http.deleteRouterForBot('basic-skills');
};

const skillsToRegister = [{
  id: 'choice',
  name: 'Choice',
  flowGenerator: _choice.default.generateFlow
}, {
  id: 'CallAPI',
  name: 'Call API',
  flowGenerator: _callApi.default.generateFlow
}, {
  id: 'Slot',
  name: 'Slot',
  flowGenerator: _slot.default.generateFlow
}];
const entryPoint = {
  onServerStarted,
  onServerReady,
  onModuleUnmount,
  definition: {
    name: 'basic-skills',
    menuIcon: 'fiber_smart_record',
    fullName: 'Basic Skills',
    homepage: 'https://botpress.io',
    noInterface: true,
    plugins: [],
    moduleView: {
      stretched: true
    }
  },
  skills: skillsToRegister
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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