"use strict";

const hardLimit = 10;
/**
 * Increment the "slot not found" counter.
 * When the counter reach its limit, the "notExtracted" flag is set and will make trigger the "On not found" transition.
 * @hidden true
 * @param retryAttempts The maximum number of times a slot extraction gets retried
 */

const slotNotFound = async retryAttempts => {
  if (!session.extractedSlots.notFound) {
    session.extractedSlots.notFound = 1;
  }

  if (session.extractedSlots.notFound < Math.min(Number(retryAttempts), hardLimit)) {
    session.extractedSlots.notFound++;
  } else {
    temp.notExtracted = 'true';
  }
};

return slotNotFound(args.retryAttempts);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNsb3Rfbm90X2ZvdW5kLmpzIl0sIm5hbWVzIjpbImhhcmRMaW1pdCIsInNsb3ROb3RGb3VuZCIsInJldHJ5QXR0ZW1wdHMiLCJzZXNzaW9uIiwiZXh0cmFjdGVkU2xvdHMiLCJub3RGb3VuZCIsIk1hdGgiLCJtaW4iLCJOdW1iZXIiLCJ0ZW1wIiwibm90RXh0cmFjdGVkIiwiYXJncyJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxNQUFNQSxTQUFTLEdBQUcsRUFBbEI7QUFFQTs7Ozs7OztBQU1BLE1BQU1DLFlBQVksR0FBRyxNQUFNQyxhQUFOLElBQXVCO0FBQzFDLE1BQUksQ0FBQ0MsT0FBTyxDQUFDQyxjQUFSLENBQXVCQyxRQUE1QixFQUFzQztBQUNwQ0YsSUFBQUEsT0FBTyxDQUFDQyxjQUFSLENBQXVCQyxRQUF2QixHQUFrQyxDQUFsQztBQUNEOztBQUVELE1BQUlGLE9BQU8sQ0FBQ0MsY0FBUixDQUF1QkMsUUFBdkIsR0FBa0NDLElBQUksQ0FBQ0MsR0FBTCxDQUFTQyxNQUFNLENBQUNOLGFBQUQsQ0FBZixFQUFnQ0YsU0FBaEMsQ0FBdEMsRUFBa0Y7QUFDaEZHLElBQUFBLE9BQU8sQ0FBQ0MsY0FBUixDQUF1QkMsUUFBdkI7QUFDRCxHQUZELE1BRU87QUFDTEksSUFBQUEsSUFBSSxDQUFDQyxZQUFMLEdBQW9CLE1BQXBCO0FBQ0Q7QUFDRixDQVZEOztBQVlBLE9BQU9ULFlBQVksQ0FBQ1UsSUFBSSxDQUFDVCxhQUFOLENBQW5CIiwic291cmNlUm9vdCI6Ii92YXIvbGliL2plbmtpbnMvd29ya3NwYWNlL2J1aWxkLWxpbnV4L21vZHVsZXMvYmFzaWMtc2tpbGxzL3NyYy9iYWNrZW5kIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgaGFyZExpbWl0ID0gMTBcblxuLyoqXG4gKiBJbmNyZW1lbnQgdGhlIFwic2xvdCBub3QgZm91bmRcIiBjb3VudGVyLlxuICogV2hlbiB0aGUgY291bnRlciByZWFjaCBpdHMgbGltaXQsIHRoZSBcIm5vdEV4dHJhY3RlZFwiIGZsYWcgaXMgc2V0IGFuZCB3aWxsIG1ha2UgdHJpZ2dlciB0aGUgXCJPbiBub3QgZm91bmRcIiB0cmFuc2l0aW9uLlxuICogQGhpZGRlbiB0cnVlXG4gKiBAcGFyYW0gcmV0cnlBdHRlbXB0cyBUaGUgbWF4aW11bSBudW1iZXIgb2YgdGltZXMgYSBzbG90IGV4dHJhY3Rpb24gZ2V0cyByZXRyaWVkXG4gKi9cbmNvbnN0IHNsb3ROb3RGb3VuZCA9IGFzeW5jIHJldHJ5QXR0ZW1wdHMgPT4ge1xuICBpZiAoIXNlc3Npb24uZXh0cmFjdGVkU2xvdHMubm90Rm91bmQpIHtcbiAgICBzZXNzaW9uLmV4dHJhY3RlZFNsb3RzLm5vdEZvdW5kID0gMVxuICB9XG5cbiAgaWYgKHNlc3Npb24uZXh0cmFjdGVkU2xvdHMubm90Rm91bmQgPCBNYXRoLm1pbihOdW1iZXIocmV0cnlBdHRlbXB0cyksIGhhcmRMaW1pdCkpIHtcbiAgICBzZXNzaW9uLmV4dHJhY3RlZFNsb3RzLm5vdEZvdW5kKytcbiAgfSBlbHNlIHtcbiAgICB0ZW1wLm5vdEV4dHJhY3RlZCA9ICd0cnVlJ1xuICB9XG59XG5cbnJldHVybiBzbG90Tm90Rm91bmQoYXJncy5yZXRyeUF0dGVtcHRzKVxuIl19