"use strict";

const axios = require('axios');
/**
 * @hidden true
 */


const callApi = async (url, method, body, memory, variable, headers) => {
  // Use context to flatten event object
  const context = {
    event,
    user: event.state.user,
    temp: event.state.temp,
    session: event.state.session
  };
  const renderedHeaders = bp.cms.renderTemplate(headers, context);
  const renderedBody = bp.cms.renderTemplate(body, context);

  try {
    const response = await axios({
      method,
      url,
      headers: renderedHeaders,
      data: renderedBody
    });
    event.state[memory][variable] = {
      body: response.data,
      status: response.status
    };
    event.state.temp.valid = true;
  } catch (error) {
    const errorCode = error.response && error.response.status || error.code || '';
    bp.logger.error(`Error: ${errorCode} while calling resource "${url}"`);
    event.state[memory][variable] = {
      status: errorCode
    };
    event.state.temp.valid = false;
  }
};

return callApi(args.url, args.method, args.body, args.memory, args.variable, args.headers);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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