import { LodashDecorator } from './factory';
declare const decorator: (...args: any[]) => LodashDecorator;
/**
 * The opposite of Before. This method creates a function that invokes once it's called n or more times.
 * This spans across all instances of the class instead of the instance.
 * @param {number} n The number of calls before the function is invoked.
 * @example
 *
 * class MyClass {
 *   @AfterAll(2)
 *   fn() {
 *     return 10;
 *   }
 * }
 *
 * const myClass = new MyClass();
 * const myClass2 = new MyClass();
 *
 * myClass.fn(); // => undefined
 * myClass.fn(); // => 10
 *
 * myClass2.fn(); // => 10
 * myClass2.fn(); // => 10
 */
export declare function AfterAll(n: number): LodashDecorator;
export { AfterAll as afterAll };
export default decorator;
