"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _api = _interopRequireDefault(require("./api"));

var _db = _interopRequireDefault(require("./db"));

var _socket = _interopRequireDefault(require("./socket"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const onServerStarted = async bp => {
  const db = new _db.default(bp);
  await db.initialize();
  await (0, _api.default)(bp, db);
  await (0, _socket.default)(bp, db);
};

const onServerReady = async bp => {};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('web.sendMessages');
  bp.http.deleteRouterForBot('channel-web');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onModuleUnmount,
  definition: {
    name: 'channel-web',
    menuIcon: 'chrome_reader_mode',
    fullName: 'Web Chat',
    homepage: 'https://botpress.io',
    noInterface: true,
    plugins: [{
      entry: 'WebBotpressUIInjection',
      position: 'overlay'
    }]
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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