"use strict";

/**
 *
 * @title Sends serialized data to parent page on channel web
 * @category Channel Web
 * @author Botpress, Inc.
 * @param {string} data - Serialized payload you want to send
 */
const sendPostbackToParent = data => {
  if (event.channel != 'web') {
    return;
  }

  const postbackEvent = bp.IO.Event({
    type: 'data',
    channel: 'web',
    direction: 'outgoing',
    target: event.target,
    botId: event.botId,
    payload: {
      data
    }
  });
  bp.events.sendEvent(postbackEvent);
};

return sendPostbackToParent(args.data);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlbmREYXRhVG9DaGF0LmpzIl0sIm5hbWVzIjpbInNlbmRQb3N0YmFja1RvUGFyZW50IiwiZGF0YSIsImV2ZW50IiwiY2hhbm5lbCIsInBvc3RiYWNrRXZlbnQiLCJicCIsIklPIiwiRXZlbnQiLCJ0eXBlIiwiZGlyZWN0aW9uIiwidGFyZ2V0IiwiYm90SWQiLCJwYXlsb2FkIiwiZXZlbnRzIiwic2VuZEV2ZW50IiwiYXJncyJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7OztBQU9BLE1BQU1BLG9CQUFvQixHQUFHQyxJQUFJLElBQUk7QUFDbkMsTUFBSUMsS0FBSyxDQUFDQyxPQUFOLElBQWlCLEtBQXJCLEVBQTRCO0FBQzFCO0FBQ0Q7O0FBRUQsUUFBTUMsYUFBYSxHQUFHQyxFQUFFLENBQUNDLEVBQUgsQ0FBTUMsS0FBTixDQUFZO0FBQ2hDQyxJQUFBQSxJQUFJLEVBQUUsTUFEMEI7QUFFaENMLElBQUFBLE9BQU8sRUFBRSxLQUZ1QjtBQUdoQ00sSUFBQUEsU0FBUyxFQUFFLFVBSHFCO0FBSWhDQyxJQUFBQSxNQUFNLEVBQUVSLEtBQUssQ0FBQ1EsTUFKa0I7QUFLaENDLElBQUFBLEtBQUssRUFBRVQsS0FBSyxDQUFDUyxLQUxtQjtBQU1oQ0MsSUFBQUEsT0FBTyxFQUFFO0FBQ1BYLE1BQUFBO0FBRE87QUFOdUIsR0FBWixDQUF0QjtBQVdBSSxFQUFBQSxFQUFFLENBQUNRLE1BQUgsQ0FBVUMsU0FBVixDQUFvQlYsYUFBcEI7QUFDRCxDQWpCRDs7QUFtQkEsT0FBT0osb0JBQW9CLENBQUNlLElBQUksQ0FBQ2QsSUFBTixDQUEzQiIsInNvdXJjZVJvb3QiOiIvdmFyL2xpYi9qZW5raW5zL3dvcmtzcGFjZS9idWlsZC1saW51eC9tb2R1bGVzL2NoYW5uZWwtd2ViL3NyYy9iYWNrZW5kIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKlxuICogQHRpdGxlIFNlbmRzIHNlcmlhbGl6ZWQgZGF0YSB0byBwYXJlbnQgcGFnZSBvbiBjaGFubmVsIHdlYlxuICogQGNhdGVnb3J5IENoYW5uZWwgV2ViXG4gKiBAYXV0aG9yIEJvdHByZXNzLCBJbmMuXG4gKiBAcGFyYW0ge3N0cmluZ30gZGF0YSAtIFNlcmlhbGl6ZWQgcGF5bG9hZCB5b3Ugd2FudCB0byBzZW5kXG4gKi9cbmNvbnN0IHNlbmRQb3N0YmFja1RvUGFyZW50ID0gZGF0YSA9PiB7XG4gIGlmIChldmVudC5jaGFubmVsICE9ICd3ZWInKSB7XG4gICAgcmV0dXJuXG4gIH1cblxuICBjb25zdCBwb3N0YmFja0V2ZW50ID0gYnAuSU8uRXZlbnQoe1xuICAgIHR5cGU6ICdkYXRhJyxcbiAgICBjaGFubmVsOiAnd2ViJyxcbiAgICBkaXJlY3Rpb246ICdvdXRnb2luZycsXG4gICAgdGFyZ2V0OiBldmVudC50YXJnZXQsXG4gICAgYm90SWQ6IGV2ZW50LmJvdElkLFxuICAgIHBheWxvYWQ6IHtcbiAgICAgIGRhdGFcbiAgICB9XG4gIH0pXG5cbiAgYnAuZXZlbnRzLnNlbmRFdmVudChwb3N0YmFja0V2ZW50KVxufVxuXG5yZXR1cm4gc2VuZFBvc3RiYWNrVG9QYXJlbnQoYXJncy5kYXRhKVxuIl19