#!/bin/sh
# Copyright (C) 2009 Help/Systems LLC, All Rights Reserved
WORKING_DIR=`dirname $0`
RUNJAVA_DIR=`dirname $WORKING_DIR`
logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.module.webservice.WebServiceWorker"
DEV_MODE="false"

# ------------------------------------------------------------------------
# Function: Log an info message                                         -
# ------------------------------------------------------------------------
logInfo() {
  echo "$1"
}

# ------------------------------------------------------------------------
# Function: Log an error message                                         -
# ------------------------------------------------------------------------
logError() {
  printf "$1\n">&2
}

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText(){
  logInfo ""
  logInfo "Help for: $0"
  logInfo ""
  logInfo "Web Service $0 allows these actions:"
  logInfo ""
  logInfo "create, delete, get, find_id_by_name,"
  logInfo "run, hold, release, clearallprereqstatuses (for jobs and job suites)"
  logInfo "create, delete, get, skip, include (for member jobs)"
  logInfo ""
  logInfo "All Automate Schedule object names are case sensitive."
  logInfo ""
  logInfo "------------------------ The Web Service Parameters ------------------------"  
  logInfo ""
  logInfo "-serverurl=<server url>    The Automate Schedule server url for the"
  logInfo "                           request - Required"
  logInfo "-password=<password>       The Automate Schedule password - Required"
  logInfo "-username=<username>       The Automate Schedule user name - Required"
  logInfo "-name=<job name>           The job name - Required"
  logInfo "-type=<job type>           The job type"
  logInfo "                           (jobs, job_suites, member_jobs) - Required"
  logInfo "-action=<action>           The actions for Job and Job Suite" 
  logInfo "                           (create, delete, get, find_id_by_name,"
  logInfo "                           run, hold, release,"
  logInfo "                           clearallprereqstatuses) - Required"
  logInfo "                           The actions for Member Job"
  logInfo "                           (create, delete, get, skip, include) - Required"
  logInfo "-suite=<job suite name>    The job suite name"
  logInfo "                           (required for skip/include actions on member job)."
  logInfo "-jobparameter=<job parameters> The job parameters"
  logInfo "                           (required for run actions on Job and Job Suite)."
  logInfo "-jobnameoverride=<job name override> The job overrided name."
  logInfo "-configfile=<file>         The Configuration file."
  logInfo "-filename=<file>           The file containing xml object for create action."
  logInfo "-ssl=<ssl>                 Use 'any' to accept all SSL certificates"
  logInfo "                           (used with https only)."
  logInfo "-runpriority=<1-99>        The priority override for running a job."
  logInfo "------------------------ END Web Service Parameters ------------------------"
  logInfo ""
  logInfo " Example for releasing a job. "
  logInfo ""
  logInfo " Example: $0 "
  logInfo " -serverurl=http://localhost:8008 -password=admin"
  logInfo " -username=admin -name=job_name -type=jobs -action=release"
  logInfo ""
  logInfo " Example for creating a job. "
  logInfo ""
  logInfo " Example: $0"
  logInfo " -serverurl=http://localhost:8008"
  logInfo " -password=admin -username=admin -type=jobs -action=create "
  logInfo " -filename=/home/job.xml"
  logInfo ""
  logInfo " Example for running a job with job parameters. "
  logInfo ""
  logInfo " Example: $0"
  logInfo " -serverurl=http://localhost:8008 -password=admin"
  logInfo " -username=admin -name=job_name -type=jobs -action=run"
  logInfo " -jobparameter=\"jobparameter_P1=V1&jobparameter_P2=V2\""
  logInfo ""
  logInfo "---------------- The default configuration file parameters -----------------"  
  logInfo ""
  logInfo "   serverurl=<server url> The Automate Schedule server url for the request"
  logInfo "   password=<password>    The Automate Schedule password"
  logInfo "   username=<username>    The Automate Schedule user name"
  logInfo ""
  logInfo "---------------- END default configuration file parameters -----------------"
  logInfo ""
  logInfo "  Example:"
  logInfo "     serverurl=http://localhost:8008"
  logInfo "     username=admin"
  logInfo "     password=admin"
  logInfo ""
  logInfo "     -h, /h, -? or /?   Show help information"
  logInfo ""
  logInfo ""
}

PATH=$PATH:/usr/ucb

allArgs=$@

if [ $# -eq 0 ]; then
  showHelpText
  exit 1
fi

for i in "${@}"
do
    if [ "$i" = "-h" -o "$i" = "--help" -o "$i" = "-?" -o "$i" = "/h" -o "$i" = "/?" ]; then
        showHelpText
        exit 1
    fi  
done

if [ ${RUNJAVA_DIR} = "." ]; then
 RUNJAVA_DIR=".."
fi

${RUNJAVA_DIR}/runjava.sh $MAIN_CLASS -devmode=${DEV_MODE} "$@"
