#!/bin/sh

# Copyright (C) 2011 Help/Systems LLC, All Rights Reserved
# Fires off a JobMonitorHistoryReport to be processed by the Server.

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
cd ../

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "jobmonitorhistoryreport - Add a jobmonitorhistoryreport to the report queue."
  echo ""
  echo "The -h or --help option will show command help."
  echo ""
  echo "Usage: $0 ReportParameters"
  echo ""
  echo "** At least one of the date parameters is required. **"
  echo ""
  echo ""
  echo " ReportParameters:"
  echo ""
  echo " -dateRange  (Report on a duration between two timestamps)"
  echo ""
  echo "  [start_date/yyyymmdd]  [start_time/hhmm]  [end_date/yyyymmdd] [end_time/hhmm]"
  echo "    Example 1: Report on the duration between Sept 1 18:00 and Sept 2 06:00."
  echo "    Command: $0 -dateRange 20110901 1800 20110902 0600"
  echo ""
  echo "  [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "    Example 2: Report on the duration between Sept 1 18:00 and run time."
  echo "    Command: $0 -dateRange 20110901 1800"
  echo ""
  echo ""
  echo " -endDateDuration (Report on a duration relative to an end timestamp)"
  echo "                        "
  echo "  [days/number]  [hours/number]  [end_date/yyyymmdd]  [end_time/hhmm]"
  echo "    Example 3: Report on the duration 2 days 12 hours prior to Sept 2 06:00."
  echo "    Command: $0 -endDateDuration 2 12 20110902 0600"
  echo ""
  echo "  [days/number]  [hours/number]"
  echo "    Example 4: Report on the duration 5 days 6 hours prior to run time."
  echo "    Command: $0 -endDateDuration 5 6"
  echo ""
  echo "  [days/number]    "
  echo "    Example 5: Report on the duration 7 days prior to run time."
  echo "    Command: $0 -endDateDuration 7"
  echo ""
  echo ""
  echo " -startDateDuration  (Report on a duration relative to an start timestamp)"
  echo ""
  echo "  [days/number]  [hours/number]  [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "    Example 6: Report on the duration 4 days 8 hours after Sept 2 06:00."
  echo "    Command: $0 -startDateDuration 4 8 20110902 0600"
  echo ""
  echo ""
  echo " -jobNames (Specify jobs to include in the report)"
  echo "  "
  echo "  [jobNames/list]"
  echo "    Example 7: Report on jobs named job1 and job2 for the duration 7 days"
  echo "               prior to run time.    "
  echo "    Command: $0 -jobNames job1 job2 -endDateDuration 7"
  echo ""
  echo ""
  echo " -monitorTypes (Specify monitor type list to include in the report)"
  echo "      "
  echo "  [monitorTypes/list] - The following possible Job Monitor Types could be used:"
  echo "                       JobLateStart"
  echo "                       JobUnderRun"
  echo "                       JobOverRun "
  echo "    Example 8: Report on monitorType named JobLateStart for the duration 7 days"
  echo "               prior to run time.   "
  echo "    Command: $0 -monitorTypes JobLateStart "
  echo "             -endDateDuration 7 "
  echo "     "
  echo "     "
  echo " -agents (Specify agents to have all jobs that run on those agents to include"
  echo "          in the report)"
  echo ""
  echo "  [agents/list]"
  echo "    Example 9: Report on agent named agent1 for the duration 7 days prior to"
  echo "               run time.   "
  echo "    Command: $0 -agents agent1 -endDateDuration 7"
  echo ""
  echo ""
  echo " -agentGroups (Specify agentGroups to have all jobs that run on those agent"
  echo "               groups to include in the report)"
  echo ""
  echo "  [agentGropus/list]"
  echo "    Example 10: Report on agentGroups named agentGroup1 and agentGroup2 for"
  echo "                the duration 7 days prior to run time."
  echo "    Command: $0 -agentGroups agentGroup1 agentGroup2 "
  echo "             -endDateDuration 7"
  echo ""
  echo ""
  echo " -tags (Specify tag list to be included in the report)"
  echo ""
  echo "  [tags/list]"
  echo "    Example 11: Report on tags named tag1 and tag2 for the duration 7 days"
  echo "                prior to run time."
  echo "    Command: $0 -tags tag1 tag2 -endDateDuration 7"
  echo ""
  echo ""
  echo " -userName (Specify the user name who will generate the report)"
  echo ""
  echo " [userName] - If no -userName option is given the report will"
  echo "              be generated by administrator user."
  echo "     Example 9: Specify the user name who generates the report for the"
  echo "                 the duration 3 days prior to run time."
  echo ""                 
  echo "     Command: $0 -userName username -endDateDuration 3"
  echo ""
  echo ""
  echo " -f  (Specify an agent configuration file to be used to start the report)"
  echo ""
  echo "  [filename] - If no -f option is given the agent configuration file defaults"
  echo "               to agent.xml."
  echo "    Example 12: Specify agent other than default, report on the duration 7"
  echo "                days prior to run time."
  echo "    Command: $0 -f myconfig.xml -endDateDuration 7"
  echo ""
  echo "  -emailToAddress  (Specify email addresses to send the report)"
  echo "  [emailToAddress/list]"
  echo ""
  echo "    Example 13:  Send a report to admin@mycompany.com, company@mycompany.com email addresses "
  echo "    Command: $0 -emailToAddress admin@mycompany.com company@mycompany.com -endDateDuration 3 "
  echo "     If no -emailToAddress option is given the report will not be sent "
  echo ""
  echo "  -emailToNotificationList  (Specify notification lists to send the report)"
  echo "  [emailToNotificationList/list]"
  echo ""
  echo "    Example 14:  Send a report an email to notification lists "
  echo "    Command: $0 -emailToNotificationList notificationList1 notificationList2 -endDateDuration 3 "
  echo "     If no -emailToNotificationList option is given the report will not be sent "
  echo ""
  echo "  -emailToCurrentUser  (Specify current user email address to send the report)"
  echo "  [emailToCurrentUser]"
  echo ""
  echo "    Example 15:  Send a report to current user email address "
  echo "    Command: $0 -userName automateuser -emailToCurrentUser yes -endDateDuration 3 "
  echo "     If no -emailToCurrentUser option is given the report will not be sent "
  echo ""
  echo "  -reportFilePath  (Specify file path to copy the report)"
  echo "  [reportFilePath]"
  echo "  This parameter is for the file system that the Automate Schedule server is running "
  echo "  on, not the agent itself."
  echo ""
  echo "    Example 16A:  Copy the report when the Automate Shedule server is running on a Windows system "
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -endDateDuration 3 "
  echo ""
  echo "    Example 16B:  Copy the report when the Automate Schedule server is running on a Unix system. "
  echo "    Command: $0 -reportFilePath /home/a_user -endDateDuration 3 "
  echo "     If -reportFilePath is not specified the report will not be copied "
  echo ""
  echo "  -reportFileName  (Specify file name to copy the report)"
  echo "  [reportFileName]"
  echo ""
  echo "    Example 17A:  Copy report to this file when the Automate Schedule server is running on a Windows system."
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -reportFileName report.pdf -endDateDuration 3 "
  echo "    Example 17B:  Copy report to this file when the Automate Schedule server is running on a Unix system."
  echo "    Command: $0 -reportFilePath /home/a_user -reportFileName report.pdf -endDateDuration 3 "
  echo "     If -reportFileName is not specified generated name will be used "
  echo ""
  echo ""
  echo "Copyright (C) 2011 Help/Systems LLC, All Rights Reserved."
}

noConfigFile() {
  echo "Error: A configuration file must follow the -f parameter"
}

COMMAND=REPORT
CONFIG_FILE=agent.xml
# For other reports, change the "0" to the report id, ie "100", "1002", etc
REPORT_NUM=1002
OUTPUT_TYPE=0
MAINCLASS=com.helpsystems.enterprise.peer.AgentControl

allArgs=$@

for i in ${@}
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done

if [ "$1" = "-f" ]; then
	if [ "$2" = "" ]; then
		noConfigFile
		exit 1
	fi
	CONFIG_FILE=$2
fi 

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "Generating report with agent configuration file $CONFIG_FILE ..."
# ./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" ${FROM_DATE} ${TO_DATE}
./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" "$@"
