#!/bin/sh

# Copyright (C) 2011 Help/Systems LLC, All Rights Reserved
# Fires off a ForecastedJobRunsReport to be processed by the Server.

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
cd ../

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "forecastedjobrunsreport - Add a forecastedjobrunsreport to the report queue."
  echo ""
  echo "The -h or --help option will show command help."
  echo ""
  echo "Usage: $0 ReportParameters"
  echo ""
  echo ""
  echo " ReportParameters:"
  echo ""
  echo " -outputType (Required parameter which specifies the output type of the report)"
  echo ""
  echo "  [outputType] - The following outputTypes are possible:"
  echo "                 PDF"
  echo "                 CSV"
  echo "    Example 1: CSV report with the last generated forecast model model1. "
  echo "    Command: $0 -outputType CSV -forecastModel model1"
  echo "             -lastGen"
  echo ""
  echo ""
  echo " -forecastModel (Required parameter which specifies name of the forecast model)"
  echo ""
  echo "  [forecastModel] "
  echo "    Example 2: PDF report with the last generated forecast model model1."
  echo "    Command: $0 -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo ""
  echo ""
  echo " -lastGen (Required parameter which specifies that the last completed forecast"
  echo "           should be included in the report)"
  echo ""
  echo "    Example 3: PDF report with the last generated forecast model model1. "
  echo "    Command: $0 -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo ""
  echo ""
  echo " -userName (Specify the user name who will generate the report)"
  echo ""
  echo " [userName] - If no -userName option is given the report will"
  echo "              be generated by administrator user."
  echo "     Example 4: Specify the user name who generates the report for the"
  echo "                 forecast model model1."
  echo ""                 
  echo "     Command: $0 -userName username -outputType PDF -forecastModel model1"
  echo "                 -lastGen"
  echo ""
  echo ""
  echo " -f (Specify an agent configuration file to be used to start the report)"
  echo ""
  echo "  [filename] - If no -f option is given the agent configuration file defaults"
  echo "               to agent.xml."
  echo "    Example 5: Specify agent other than default, PDF report with the last"
  echo "               generated forecast model model1."
  echo "    Command: $0 -f myagent.xml -outputType PDF "
  echo "             -forecastModel model1 -lastGen"
  echo "" 
  echo "  -emailToAddress  (Specify email addresses to send the report)"
  echo "  [emailToAddress/list]"
  echo ""
  echo "    Example 6:  Send a report to admin@mycompany.com, company@mycompany.com email addresses "
  echo "    Command: $0 -emailToAddress admin@mycompany.com company@mycompany.com -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo "     If no -emailToAddress option is given the report will not be sent "
  echo ""
  echo "  -emailToNotificationList  (Specify notification lists to send the report)"
  echo "  [emailToNotificationList/list]"
  echo ""
  echo "    Example 7:  Send a report an email to notification lists "
  echo "    Command: $0 -emailToNotificationList notificationList1 notificationList2 -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo "     If no -emailToNotificationList option is given the report will not be sent "
  echo ""
  echo "  -emailToCurrentUser  (Specify current user email address to send the report)"
  echo "  [emailToCurrentUser]"
  echo ""
  echo "    Example 8:  Send a report to current user email address "
  echo "    Command: $0 -userName automateuser -emailToCurrentUser yes -outputType PDF -forecastModel model1 "
  echo "             -lastGen"
  echo "     If no -emailToCurrentUser option is given the report will not be sent "
  echo ""
  echo "  -reportFilePath  (Specify file path to copy the report)"
  echo "  [reportFilePath]"
  echo "  This parameter is for the file system that the Automate Schedule server is running "
  echo "  on, not the agent itself."
  echo ""
  echo "    Example 9A:  Copy the report when the Automate Schedule server is running on a Windows system "
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -outputType PDF -forecastModel model1 "
  echo "             -lastGen"
  echo ""
  echo "    Example 9B:  Copy the report when the Automate Schedule server is running on a Unix system. "
  echo "    Command: $0 -reportFilePath /home/a_user -outputType PDF -forecastModel model1 "
  echo "             -lastGen"
  echo "     If -reportFilePath is not specified the report will not be copied "
  echo ""
  echo "  -reportFileName  (Specify file name to copy the report)"
  echo "  [reportFileName]"
  echo ""
  echo "    Example 10A:  Copy report to this file Automate Schedule server is running on a Windows system."
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -reportFileName report.pdf -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo "    Example 10B:  Copy report to this file Automate Schedule server is running on a Unix system."
  echo "    Command: $0 -reportFilePath /home/a_user -reportFileName report.pdf -outputType PDF -forecastModel model1"
  echo "             -lastGen"
  echo "     If -reportFileName is not specified generated name will be used "
  echo ""
  echo ""
  echo "Copyright (C) 2011 Help/Systems LLC, All Rights Reserved."
}

noConfigFile() {
  echo "Error: A configuration file must follow the -f parameter"
}

COMMAND=REPORT
CONFIG_FILE=agent.xml
# For other reports, change the "0" to the report id, ie "100", "1002", etc
REPORT_NUM=1006
MAINCLASS=com.helpsystems.enterprise.peer.AgentControl

allArgs=$@

for i in ${@}
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done

if [ "$1" = "-f" ]; then
	if [ "$2" = "" ]; then
		noConfigFile
		exit 1
	fi
	CONFIG_FILE=$2
fi 

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "Generating report with agent configuration file $CONFIG_FILE ..."
# ./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" ${FROM_DATE} ${TO_DATE}
./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" "$@"
