#!/bin/sh

# Copyright (C) 2010 Help/Systems LLC, All Rights Reserved
# Reports on whether or not an agent is connected to the agent server, and if
# it is licensed.

logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.peer.AgentControl"

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

# initialize empty parm flags
CFG_FILE=agent.xml
COMMAND=getstatus

# ------------------------------------------------------------------------
# Function: Log a debug message                                          -
# ------------------------------------------------------------------------
debugMsg() {
  if test "$logDebug" = "true"
  then 
    echo "DEBUG: $1"
  fi
}

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "GETSTATUS - Shows if an agent is connected to the Enterprise Server,"
  echo "and if it is licensed." 
  echo ""
  echo "Usage: $0 [-f config file]"
  echo "If no config file is provided, then the file agent.xml is used."
  echo ""
  echo "  [-v]                  verbose mode"
  echo ""
  echo "  Exit Status:"
  echo "    0=Agent is active and connected to Enterprise Server"
  echo "   10=Agent is active, but not connected to Enterprise Server"
  echo "   20=Agent is active, but is shutting down"
  echo "   30=Agent is not active"
  echo ""
}

# ------------------------------------------------------------------------
# Main Line Code.                                                        -
# ------------------------------------------------------------------------

if [ $# -gt 0 -a "$1" = "--help" ]; then
  showHelpText
  exit 0
fi

#Check for config file first
if [ "$1" = "-f" ]; then
   if [ -z "$2" ]; then
     echo "Error: A configuration file must follow the -f parameter"
     exit 1
   fi
fi

while getopts hvf: opt
  do
    case $opt in
    h)   showHelpText
         exit 0
         ;;
    v)   verbose=-v
         debugMsg "Setting on verbose mode"
         ;;
    f)   CFG_FILE=$OPTARG
         debugMsg "Config file: $CFG_FILE"
         ;;
    '?') echo "$0: invalid option -$opt" >&2
         showHelpText
         exit 1
         ;;
    esac
  done

debugMsg "----------------------------------------------------------------"
debugMsg "- Verbose flag  . . . . . . : ${verbose}"
debugMsg "- Using config file . . . . : ${CFG_FILE}"
debugMsg "- Sending Command . . . . . : ${COMMAND}"
debugMsg "----------------------------------------------------------------"

PATH=$PATH:/usr/ucb

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

if [ ! -f ${CFG_FILE} ]; then
    echo "The config file ${CFG_FILE} does not exist. Command failed."
    exit 1
fi

if [ ! -r ${CFG_FILE} ]; then
    echo "The config file $CFG_FILE is not readable by the current user."
    exit 1
fi

# Parameter notes:
# - The verbose parameter is not quoted because it is optional.
echo "About to get the status for the Agent with configuration file $CFG_FILE ..."
./runjava.sh $MAIN_CLASS ${verbose} "${CFG_FILE}" ${COMMAND}

# B:14277 - Translate negative java error codes.
java_status=$?
exit $java_status

