/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.rule.RuleFactory;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ExpressionRuleContext
extends KeyAdapter {
    RuleFactory factory = RuleFactory.getInstance();
    LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    JPopupMenu contextMenu = new JPopupMenu();
    JList list = new JList();
    FilterModel filterModel;
    JScrollPane scrollPane = new JScrollPane(this.list);
    final JTextField textField;
    private DefaultListModel fieldModel = new DefaultListModel();
    private DefaultListModel operatorModel = new DefaultListModel();

    public ExpressionRuleContext(FilterModel filterModel, JTextField jTextField) {
        this.filterModel = filterModel;
        this.textField = jTextField;
        this.fieldModel.addElement("LOGGER");
        this.fieldModel.addElement("LEVEL");
        this.fieldModel.addElement("CLASS");
        this.fieldModel.addElement("FILE");
        this.fieldModel.addElement("LINE");
        this.fieldModel.addElement("METHOD");
        this.fieldModel.addElement("MSG");
        this.fieldModel.addElement("NDC");
        this.fieldModel.addElement("EXCEPTION");
        this.fieldModel.addElement("TIMESTAMP");
        this.fieldModel.addElement("THREAD");
        this.fieldModel.addElement("PROP.");
        this.operatorModel.addElement("&&");
        this.operatorModel.addElement("||");
        this.operatorModel.addElement("!");
        this.operatorModel.addElement("!=");
        this.operatorModel.addElement("==");
        this.operatorModel.addElement("~=");
        this.operatorModel.addElement("LIKE");
        this.operatorModel.addElement("EXISTS");
        this.operatorModel.addElement("<");
        this.operatorModel.addElement(">");
        this.operatorModel.addElement("<=");
        this.operatorModel.addElement(">=");
        this.list.setVisibleRowCount(13);
        PopupListener popupListener = new PopupListener();
        jTextField.addMouseListener(popupListener);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = ExpressionRuleContext.this.list.getSelectedValue().toString();
                    String string2 = ExpressionRuleContext.this.getContextKey();
                    if (string2 != null && !string2.endsWith(".")) {
                        string = "'" + string + "'";
                    }
                    ExpressionRuleContext.this.updateField(string);
                    ExpressionRuleContext.this.contextMenu.setVisible(false);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    String string = ExpressionRuleContext.this.list.getSelectedValue().toString();
                    String string2 = ExpressionRuleContext.this.getContextKey();
                    if (string2 != null && !string2.endsWith(".")) {
                        string = "'" + string + "'";
                    }
                    ExpressionRuleContext.this.updateField(string);
                    ExpressionRuleContext.this.contextMenu.setVisible(false);
                }
            }
        });
        this.contextMenu.insert(this.scrollPane, 0);
    }

    private void updateField(String string) {
        if (this.textField.getSelectedText() == null && !string.endsWith(".")) {
            string = string + " ";
        }
        this.textField.replaceSelection(string);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && keyEvent.getModifiers() == 2) {
            this.displayContext();
        }
    }

    public void displayContext() {
        String string = this.getContextKey();
        if (string != null) {
            ListModel listModel = this.filterModel.getContainer().getModel(string);
            if (listModel == null) {
                return;
            }
            this.list.setModel(listModel);
            this.list.setSelectedIndex(0);
            Point point = this.textField.getCaret().getMagicCaretPosition();
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textField, point.x, point.y + (this.textField.getHeight() - 5));
            this.list.requestFocus();
        } else if (this.isOperatorContextValid()) {
            this.list.setModel(this.operatorModel);
            this.list.setSelectedIndex(0);
            Point point = this.textField.getCaret().getMagicCaretPosition();
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textField, point.x, point.y + (this.textField.getHeight() - 5));
            this.list.requestFocus();
        } else if (this.isFieldContextValid()) {
            this.list.setModel(this.fieldModel);
            this.list.setSelectedIndex(0);
            Point point = this.textField.getCaret().getMagicCaretPosition();
            if (point == null) {
                point = new Point(this.textField.getLocation().x, this.textField.getLocation().y - this.textField.getHeight() + 5);
            }
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textField, point.x, point.y + (this.textField.getHeight() - 5));
            this.list.requestFocus();
        }
    }

    private boolean isFieldContextValid() {
        String string = this.textField.getText();
        int n = this.textField.getSelectionStart();
        return n == 0 || string.charAt(n - 1) == ' ';
    }

    private String getContextKey() {
        String string = this.getField();
        if (string == null) {
            string = this.getSubField();
        }
        return string;
    }

    private boolean isOperatorContextValid() {
        String string = this.textField.getText();
        int n = this.textField.getSelectionStart();
        if (n < 1 || string.charAt(n - 1) != ' ') {
            return false;
        }
        int n2 = string.lastIndexOf(" ", n - 1);
        if (n2 == -1) {
            return false;
        }
        int n3 = Math.max(0, string.lastIndexOf(" ", n2 - 1));
        String string2 = string.substring(n3, n2).toUpperCase().trim();
        return this.resolver.isField(string2);
    }

    private String getField() {
        String string = this.textField.getText();
        int n = this.textField.getSelectionStart();
        if (n < 1 || string.charAt(n - 1) != ' ') {
            return null;
        }
        int n2 = string.lastIndexOf(" ", n - 1);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.lastIndexOf(" ", n2 - 1);
        if (n3 < 0) {
            return null;
        }
        int n4 = Math.max(0, string.lastIndexOf(" ", n3 - 1));
        String string2 = string.substring(n3 + 1, n2).trim();
        String string3 = string.substring(n4, n3).trim();
        if (this.factory.isRule(string2) && this.filterModel.getContainer().modelExists(string3)) {
            return string3;
        }
        return null;
    }

    private String getSubField() {
        int n = this.textField.getSelectionStart();
        String string = this.textField.getText();
        if (string.substring(0, n).toUpperCase().endsWith("PROP.")) {
            return "PROP.";
        }
        return null;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        private void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ExpressionRuleContext.this.displayContext();
            }
        }
    }
}

