/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.spi.LoggingEvent;

public class UDPAppender
extends AppenderSkeleton
implements PortBased {
    public static final int DEFAULT_PORT = 9991;
    private static final int PACKET_LENGTH = 16384;
    String hostname;
    String remoteHost;
    String application;
    String encoding;
    String overrideProperties = "true";
    InetAddress address;
    int port = 9991;
    DatagramSocket outSocket;
    int count = 0;
    boolean inError = false;

    public UDPAppender() {
    }

    public UDPAppender(InetAddress address, int port) {
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
        this.connect(address, port);
    }

    public UDPAppender(String host, int port) {
        this.port = port;
        this.address = UDPAppender.getAddressByName(host);
        this.remoteHost = host;
        this.connect(this.address, port);
    }

    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe2) {
                this.hostname = "unknown";
            }
        }
        if (this.application == null) {
            this.application = System.getProperty("application");
        } else if (System.getProperty("application") != null) {
            this.application = this.application + "-" + System.getProperty("application");
        }
        this.connect(this.address, this.port);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception e) {
                LogLog.error("Could not close outSocket.", e);
            }
            this.outSocket = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new DatagramSocket();
            this.outSocket.connect(address, port);
        }
        catch (IOException e) {
            LogLog.error("Could not open UDP Socket for sending.", e);
            this.inError = true;
        }
    }

    public void append(LoggingEvent event) {
        if (this.inError) {
            return;
        }
        if (event == null) {
            return;
        }
        if (this.address == null) {
            this.errorHandler.error("No remote host is set for UDPAppender named \"" + this.name + "\".");
            return;
        }
        if (this.outSocket != null) {
            if (this.overrideProperties != null && this.overrideProperties.equalsIgnoreCase("true")) {
                event.setProperty("hostname", this.hostname);
                if (this.application != null) {
                    event.setProperty("application", this.application);
                }
            }
            try {
                StringBuffer buf = new StringBuffer(this.layout.format(event));
                DatagramPacket dp = new DatagramPacket(buf.toString().getBytes(this.encoding), buf.length(), this.address, this.port);
                this.outSocket.send(dp);
                event.setProperty("hostname", null);
                event.setProperty("application", null);
            }
            catch (IOException e) {
                this.outSocket = null;
                LogLog.warn("Detected problem with UDP connection: " + e);
            }
        }
    }

    public boolean isActive() {
        return !this.inError;
    }

    static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            LogLog.error("Could not find address of [" + host + "].", e);
            return null;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setRemoteHost(String host) {
        this.address = UDPAppender.getAddressByName(host);
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    public String getApplication() {
        return this.application;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setOverrideProperties(String overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public String getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

