/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.Receiver;

public class ReceiversTreeModel
extends DefaultTreeModel
implements PluginListener {
    private static final String ROOTNODE_LABEL = "Receivers";
    final DefaultMutableTreeNode NoReceiversNode = new DefaultMutableTreeNode("No Receivers defined");
    final DefaultMutableTreeNode RootNode = (DefaultMutableTreeNode)this.getRoot();
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;

    ReceiversTreeModel() {
        super(new DefaultMutableTreeNode(ROOTNODE_LABEL));
        this.refresh();
    }

    public final synchronized ReceiversTreeModel refresh() {
        this.RootNode.removeAllChildren();
        List list = LogManager.getLoggerRepository().getPluginRegistry().getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = ReceiversTreeModel.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver);
        this.updateRootDisplay();
        if (list.size() == 0) {
            this.getRootNode().add(this.NoReceiversNode);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Receiver receiver = (Receiver)iterator.next();
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(receiver);
                receiver.addPropertyChangeListener(this.creatPluginPropertyChangeListener(receiver, defaultMutableTreeNode));
                if (receiver instanceof SocketReceiver) {
                    Iterator iterator2 = ((SocketReceiver)receiver).getConnectedSocketDetails().iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(e));
                    }
                }
                this.getRootNode().add(defaultMutableTreeNode);
            }
        }
        this.reload();
        return this;
    }

    private PropertyChangeListener creatPluginPropertyChangeListener(final Receiver receiver, final DefaultMutableTreeNode defaultMutableTreeNode) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogLog.debug(propertyChangeEvent.toString());
                ReceiversTreeModel.this.fireTreeNodesChanged(receiver, defaultMutableTreeNode.getPath(), null, null);
            }
        };
    }

    void updateRootDisplay() {
        this.getRootNode().setUserObject(ROOTNODE_LABEL);
        this.nodeChanged(this.getRootNode());
    }

    DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getRoot();
    }

    public void pluginStarted(PluginEvent pluginEvent) {
        if (pluginEvent.getPlugin() instanceof Receiver) {
            if (this.NoReceiversNode.getParent() == this.getRootNode()) {
                int n = this.getRootNode().getIndex(this.NoReceiversNode);
                this.getRootNode().remove(this.NoReceiversNode);
                this.nodesWereRemoved(this.getRootNode(), new int[]{n}, new Object[]{this.NoReceiversNode});
            }
            Receiver receiver = (Receiver)pluginEvent.getPlugin();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(receiver);
            this.getRootNode().add(defaultMutableTreeNode);
            receiver.addPropertyChangeListener(this.creatPluginPropertyChangeListener(receiver, defaultMutableTreeNode));
            this.nodesWereInserted(this.getRootNode(), new int[]{this.getRootNode().getIndex(defaultMutableTreeNode)});
        }
    }

    TreeNode resolvePluginNode(Plugin plugin) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode2.getUserObject().equals(plugin)) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
            break;
        }
        return defaultMutableTreeNode;
    }

    public void pluginStopped(PluginEvent pluginEvent) {
        if (pluginEvent.getPlugin() instanceof Receiver) {
            int n;
            Receiver receiver = (Receiver)pluginEvent.getPlugin();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.resolvePluginNode(receiver);
            if (defaultMutableTreeNode != null) {
                n = this.getRootNode().getIndex(defaultMutableTreeNode);
                this.getRootNode().remove(defaultMutableTreeNode);
                this.nodesWereRemoved(this.getRootNode(), new int[]{n}, new Object[]{defaultMutableTreeNode});
            }
            if (this.getRootNode().getChildCount() == 0) {
                this.getRootNode().add(this.NoReceiversNode);
                n = this.getRootNode().getIndex(this.NoReceiversNode);
                this.nodesWereInserted(this.getRootNode(), new int[]{n});
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

