/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.chainsaw.Generator;
import org.apache.log4j.chainsaw.helper.TableCellEditorFactory;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketHubReceiver;
import org.apache.log4j.plugins.Plugin;

public class PluginPropertyEditorPanel
extends JPanel {
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTable propertyTable = new JTable();
    private Plugin plugin;
    private TableModel defaultModel = new DefaultTableModel(new String[]{"Property", "Value"}, 1);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$java$lang$Integer;

    public PluginPropertyEditorPanel() {
        this.initComponents();
        this.setupListeners();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(160, 120));
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.propertyTable);
        this.add((Component)this.scrollPane, "Center");
        this.defaultModel = new DefaultTableModel(new String[]{"Property", "Value"}, 1);
        this.propertyTable.setModel(this.defaultModel);
    }

    private void setupListeners() {
        this.addPropertyChangeListener("plugin", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Plugin plugin = (Plugin)propertyChangeEvent.getNewValue();
                if (plugin != null) {
                    try {
                        PluginPropertyTableModel pluginPropertyTableModel = new PluginPropertyTableModel(plugin);
                        PluginPropertyEditorPanel.this.propertyTable.setModel(pluginPropertyTableModel);
                        PluginPropertyEditorPanel.this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new PluginTableCellEditor());
                        PluginPropertyEditorPanel.this.propertyTable.setEnabled(true);
                    }
                    catch (Throwable throwable) {
                        LogLog.error("Failed to introspect the Plugin", throwable);
                    }
                } else {
                    PluginPropertyEditorPanel.this.propertyTable.setModel(PluginPropertyEditorPanel.this.defaultModel);
                    PluginPropertyEditorPanel.this.propertyTable.setEnabled(false);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Property Editor Test bed");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(1);
            }
        });
        PluginPropertyEditorPanel pluginPropertyEditorPanel = new PluginPropertyEditorPanel();
        jFrame.getContentPane().add(pluginPropertyEditorPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        SocketHubReceiver socketHubReceiver = new SocketHubReceiver();
        pluginPropertyEditorPanel.setPlugin(socketHubReceiver);
        try {
            Thread.sleep(3000L);
            pluginPropertyEditorPanel.setPlugin(new Generator("MyPlugin"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public final void setPlugin(Plugin plugin) {
        Plugin plugin2 = this.plugin;
        this.plugin = plugin;
        this.firePropertyChange("plugin", plugin2, this.plugin);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PluginPropertyTableModel
    extends AbstractTableModel {
        private final PropertyDescriptor[] descriptors;
        private final Plugin plugin;

        private PluginPropertyTableModel(Plugin plugin) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(plugin.getClass());
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
            Collections.sort(arrayList, new Comparator(this){
                private final /* synthetic */ PluginPropertyTableModel this$0;
                {
                    this.this$0 = pluginPropertyTableModel;
                }

                public int compare(Object object, Object object2) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
                    PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)object2;
                    return propertyDescriptor.getDisplayName().compareToIgnoreCase(propertyDescriptor2.getDisplayName());
                }
            });
            this.plugin = plugin;
            this.descriptors = arrayList.toArray(new PropertyDescriptor[0]);
        }

        public Object getValueAt(int n, int n2) {
            PropertyDescriptor propertyDescriptor = this.descriptors[n];
            switch (n2) {
                case 1: {
                    try {
                        Object object = propertyDescriptor.getReadMethod().invoke((Object)this.plugin, new Object[0]);
                        if (object != null) {
                            return object;
                        }
                    }
                    catch (Exception exception) {
                        LogLog.error("Error reading value for PropertyDescriptor " + propertyDescriptor);
                    }
                    return "";
                }
                case 0: {
                    return propertyDescriptor.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.descriptors.length;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return this.descriptors[n].getWriteMethod() != null;
            }
            return false;
        }

        public String getColumnName(int n) {
            return n == 0 ? "Property" : "Value";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                object = this.translateValueIfNeeded(n, object);
                LogLog.debug("setValueAt, " + n + ", " + n2 + ", value=" + object + ", valueClass" + object.getClass());
                try {
                    this.descriptors[n].getWriteMethod().invoke((Object)this.plugin, object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception exception) {
                    LogLog.error("Failed to modify the Plugin because of Exception", exception);
                }
            } else {
                super.setValueAt(object, n, n2);
            }
        }

        private Object translateValueIfNeeded(int n, Object object) {
            if (this.descriptors[n].getPropertyType() == Integer.TYPE || this.descriptors[n].getPropertyType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = PluginPropertyEditorPanel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                try {
                    return Integer.valueOf(object.toString());
                }
                catch (Exception exception) {
                    LogLog.error("Failed to convert to Integer type");
                }
            }
            return object;
        }

        public final PropertyDescriptor[] getDescriptors() {
            return this.descriptors;
        }
    }

    private class PluginTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Map editorMap = new HashMap();
        private DefaultCellEditor defaultEditor;
        private DefaultCellEditor currentEditor = this.defaultEditor = new DefaultCellEditor(new JTextField());

        private PluginTableCellEditor() {
            this.editorMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PluginPropertyEditorPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, TableCellEditorFactory.createBooleanTableCellEditor());
            this.editorMap.put(class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = PluginPropertyEditorPanel.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level, TableCellEditorFactory.createLevelTableCellEditor());
            this.editorMap.put(Boolean.TYPE, TableCellEditorFactory.createBooleanTableCellEditor());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            PluginPropertyTableModel pluginPropertyTableModel = (PluginPropertyTableModel)jTable.getModel();
            PropertyDescriptor propertyDescriptor = pluginPropertyTableModel.getDescriptors()[n];
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (this.editorMap.containsKey(clazz)) {
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.editorMap.get(clazz);
                LogLog.debug("Located CellEditor for " + clazz);
                this.currentEditor = defaultCellEditor;
                return this.currentEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            this.currentEditor = this.defaultEditor;
            LogLog.debug("Cell value class " + clazz + " not know, using default editor");
            return this.defaultEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }
    }
}

