/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.helper.OkCancelPanel;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;

public class NewReceiverDialogPanel
extends JPanel {
    private PluginPropertyEditorPanel pluginEditorPanel = new PluginPropertyEditorPanel();
    private final OkCancelPanel okPanel = new OkCancelPanel();
    private final JEditorPane javaDocPane = new JEditorPane();
    private final JScrollPane javaDocScroller = new JScrollPane(this.javaDocPane);
    private final JSplitPane splitter = new JSplitPane();
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketHubReceiver;

    private NewReceiverDialogPanel() {
        this.setupComponents();
        this.setupListeners();
    }

    private void setupListeners() {
        this.pluginEditorPanel.addPropertyChangeListener("plugin", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Plugin plugin = (Plugin)propertyChangeEvent.getNewValue();
                URL uRL = HelpManager.getInstance().getHelpForClass(plugin.getClass());
                try {
                    NewReceiverDialogPanel.this.javaDocPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    MessageCenter.getInstance().getLogger().error("Failed to load the Help resource for " + plugin.getClass(), iOException);
                }
            }
        });
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        this.setupJavadoc();
        this.setupPluginPropertyPanel();
        this.setupSplitter();
        this.add((Component)this.splitter, "Center");
        this.add((Component)this.okPanel, "South");
        this.setMinimumSize(new Dimension(600, 600));
        this.setPreferredSize(this.getMinimumSize());
    }

    private void setupPluginPropertyPanel() {
        this.pluginEditorPanel.setMinimumSize(new Dimension(320, 160));
        this.pluginEditorPanel.setPreferredSize(this.pluginEditorPanel.getMinimumSize());
    }

    private void setupSplitter() {
        this.splitter.setTopComponent(this.javaDocScroller);
        this.splitter.setBottomComponent(this.pluginEditorPanel);
        this.splitter.setResizeWeight(0.8);
        this.splitter.setOrientation(0);
    }

    private void setupJavadoc() {
        this.javaDocPane.setEditable(false);
    }

    public static NewReceiverDialogPanel create(Class clazz) {
        if (!(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = NewReceiverDialogPanel.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a Receiver");
        }
        Receiver receiver = null;
        try {
            receiver = (Receiver)clazz.newInstance();
        }
        catch (Exception exception) {
            LogLog.error("Failed to create a new Receiver instance, this exception is unexpected", exception);
        }
        NewReceiverDialogPanel newReceiverDialogPanel = new NewReceiverDialogPanel();
        newReceiverDialogPanel.pluginEditorPanel.setPlugin(receiver);
        return newReceiverDialogPanel;
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        NewReceiverDialogPanel newReceiverDialogPanel = NewReceiverDialogPanel.create(class$org$apache$log4j$net$SocketHubReceiver == null ? (class$org$apache$log4j$net$SocketHubReceiver = NewReceiverDialogPanel.class$("org.apache.log4j.net.SocketHubReceiver")) : class$org$apache$log4j$net$SocketHubReceiver);
        JDialog jDialog = new JDialog((Frame)null, true);
        jDialog.getContentPane().add(newReceiverDialogPanel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        };
        newReceiverDialogPanel.okPanel.getOkButton().addActionListener(actionListener);
        newReceiverDialogPanel.okPanel.getCancelButton().addActionListener(actionListener);
        jDialog.pack();
        jDialog.show();
    }

    public final OkCancelPanel getOkPanel() {
        return this.okPanel;
    }

    public Plugin getPlugin() {
        return this.pluginEditorPanel.getPlugin();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

