/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.helpers.LogLog;

class HelpLocator {
    private List classLoaders = new ArrayList();

    HelpLocator() {
    }

    void installClassloaderLocator(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    void installLocator(URL uRL) {
        try {
            this.classLoaders.add(new HelpResourceLoader(uRL));
        }
        catch (Exception exception) {
            MessageCenter.getInstance().getLogger().error("Failed to setup the resoure loaders for the Help Subsystem");
        }
    }

    URL findResource(String string) {
        ClassLoader classLoader;
        URL uRL = null;
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext() && (uRL = (classLoader = (ClassLoader)iterator.next()).getResource(string)) == null) {
        }
        return uRL;
    }

    private static class HelpResourceLoader
    extends ClassLoader {
        private URL root;

        private HelpResourceLoader(URL uRL) {
            this.root = uRL;
        }

        protected URL findResource(String string) {
            URL uRL = super.findResource(string);
            if (uRL != null) {
                return uRL;
            }
            try {
                URL uRL2 = new URL(this.root, string);
                URL[] uRLArray = new URL[]{this.root, uRL2};
                LogLog.debug("Looking for Help resource at:" + uRL2.toExternalForm());
                LogLog.debug("urlArray=" + Arrays.asList(uRLArray));
                return new URLClassLoader(uRLArray).findResource(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }
    }
}

