/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.chainsaw.FileLoadAction;
import org.apache.log4j.chainsaw.FileSaveAction;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.xml.UtilLoggingXMLDecoder;
import org.apache.log4j.xml.XMLDecoder;

class FileMenu
extends JMenu {
    private Action exitAction;
    private Action loadLog4JAction;
    private Action loadUtilLoggingAction;
    private Action remoteLog4JAction;
    private Action remoteUtilLoggingAction;
    private Action saveAction;

    public FileMenu(final LogUI logUI) {
        super("File");
        this.setMnemonic(70);
        this.loadLog4JAction = new FileLoadAction(logUI, new XMLDecoder(logUI), "Load Log4J File...", false);
        this.loadLog4JAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.loadLog4JAction.putValue("MnemonicKey", new Integer(76));
        this.loadLog4JAction.putValue("ShortDescription", "Loads an XML event file");
        this.loadLog4JAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_OPEN));
        this.loadUtilLoggingAction = new FileLoadAction(logUI, new UtilLoggingXMLDecoder(logUI), "Load Java Util File...", false);
        this.remoteLog4JAction = new FileLoadAction(logUI, new XMLDecoder(logUI), "Load Remote Log4J File...", true);
        this.remoteUtilLoggingAction = new FileLoadAction(logUI, new UtilLoggingXMLDecoder(logUI), "Load Remote Java Util File...", true);
        this.saveAction = new FileSaveAction(logUI);
        JMenuItem jMenuItem = new JMenuItem(this.loadLog4JAction);
        JMenuItem jMenuItem2 = new JMenuItem(this.loadUtilLoggingAction);
        JMenuItem jMenuItem3 = new JMenuItem(this.remoteLog4JAction);
        JMenuItem jMenuItem4 = new JMenuItem(this.remoteUtilLoggingAction);
        JMenuItem jMenuItem5 = new JMenuItem(this.saveAction);
        this.exitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                logUI.exit();
            }
        };
        this.exitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 8));
        this.exitAction.putValue("ShortDescription", "Exits the Application");
        this.exitAction.putValue("MnemonicKey", new Integer(88));
        this.exitAction.putValue("Name", "Exit");
        JMenuItem jMenuItem6 = new JMenuItem(this.exitAction);
        this.add(jMenuItem);
        this.add(jMenuItem2);
        this.addSeparator();
        this.add(jMenuItem3);
        this.add(jMenuItem4);
        this.addSeparator();
        this.add(jMenuItem5);
        this.addSeparator();
        this.add(jMenuItem6);
    }

    Action getLog4JFileOpenAction() {
        return this.loadLog4JAction;
    }

    Action getUtilLoggingJFileOpenAction() {
        return this.loadUtilLoggingAction;
    }

    Action getFileSaveAction() {
        return this.saveAction;
    }

    Action getExitAction() {
        return this.exitAction;
    }
}

