/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.chainsaw.CommonActions;
import org.apache.log4j.chainsaw.FileMenu;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;
import org.apache.log4j.rule.ExpressionRuleContext;

class ChainsawToolBarAndMenus
implements ChangeListener {
    private final SmallToggleButton showReceiversButton;
    private final JTextField findField;
    private final Action changeModelAction;
    private final Action clearAction;
    private final Action closeAction;
    private final Action findNextAction;
    private final Action findPreviousAction;
    private final Action pauseAction;
    private final Action showPreferencesAction;
    private final Action showColorPanelAction;
    private final Action showReceiversAction;
    private final Action toggleLogTreeAction;
    private final Action toggleScrollToBottomAction;
    private final Action toggleDetailPaneAction;
    private final Action toggleToolbarAction;
    private final Action undockAction;
    private final Action customExpressionPanelAction;
    private final Collection lookAndFeelMenus = new ArrayList();
    private final JCheckBoxMenuItem toggleShowReceiversCheck = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleLogTreeMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleScrollToBottomMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleDetailMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleCyclicMenuItem = new JCheckBoxMenuItem();
    private final FileMenu fileMenu;
    private final JCheckBoxMenuItem toggleStatusBarCheck = new JCheckBoxMenuItem();
    private final JMenu viewMenu = new JMenu("View");
    private final JMenuBar menuBar;
    private final JCheckBoxMenuItem menuItemClose = new JCheckBoxMenuItem();
    private final JToolBar toolbar;
    private LogUI logui;
    private final SmallButton clearButton = new SmallButton();
    private final SmallToggleButton detailPaneButton = new SmallToggleButton();
    private final SmallToggleButton logTreePaneButton = new SmallToggleButton();
    private final SmallToggleButton scrollToBottomButton = new SmallToggleButton();
    private final SmallToggleButton pauseButton = new SmallToggleButton();
    private final SmallToggleButton toggleCyclicButton = new SmallToggleButton();
    private final Action[] logPanelSpecificActions;
    private final JMenu activeTabMenu = new JMenu("Current tab");
    private final JPanel findPanel;
    static /* synthetic */ Class class$javax$swing$JDialog;

    ChainsawToolBarAndMenus(LogUI logUI) {
        this.logui = logUI;
        this.toolbar = new JToolBar(0);
        this.menuBar = new JMenuBar();
        this.fileMenu = new FileMenu(logUI);
        this.closeAction = this.createCloseHelpAction();
        this.changeModelAction = this.createChangeModelAction();
        this.findField = new JTextField();
        this.findNextAction = this.getFindNextAction();
        this.findPreviousAction = this.getFindPreviousAction();
        this.customExpressionPanelAction = this.createCustomExpressionPanelAction();
        this.showPreferencesAction = this.createShowPreferencesAction();
        this.showColorPanelAction = this.createShowColorPanelAction();
        this.toggleToolbarAction = this.createToggleToolbarAction();
        this.toggleLogTreeAction = this.createToggleLogTreeAction();
        this.toggleScrollToBottomAction = this.createScrollToBottomAction();
        this.pauseAction = this.createPauseAction();
        this.clearAction = this.createClearAction();
        this.undockAction = this.createUndockAction();
        this.showReceiversAction = this.createShowReceiversAction();
        this.showReceiversButton = new SmallToggleButton(this.showReceiversAction);
        this.findPanel = new JPanel();
        Dimension dimension = new Dimension(170, 22);
        Dimension dimension2 = new Dimension(175, 30);
        this.findPanel.setPreferredSize(dimension2);
        this.findPanel.setMaximumSize(dimension2);
        this.findPanel.setMinimumSize(dimension2);
        this.findField.setPreferredSize(dimension);
        this.findField.setMaximumSize(dimension);
        this.findField.setMinimumSize(dimension);
        this.findPanel.setAlignmentY(0.5f);
        this.findField.setAlignmentY(0.5f);
        this.toggleDetailPaneAction = this.createToggleDetailPaneAction();
        this.createMenuBar();
        this.createToolbar();
        this.logPanelSpecificActions = new Action[]{this.pauseAction, this.findNextAction, this.findPreviousAction, this.clearAction, this.fileMenu.getFileSaveAction(), this.toggleDetailPaneAction, this.showPreferencesAction, this.showColorPanelAction, this.undockAction, this.toggleLogTreeAction, this.toggleScrollToBottomAction, this.changeModelAction};
        logUI.getApplicationPreferenceModel().addPropertyChangeListener("statusBar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                ChainsawToolBarAndMenus.this.toggleStatusBarCheck.setSelected(bl);
            }
        });
        logUI.getApplicationPreferenceModel().addPropertyChangeListener("receivers", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                ChainsawToolBarAndMenus.this.showReceiversButton.setSelected(bl);
                ChainsawToolBarAndMenus.this.toggleShowReceiversCheck.setSelected(bl);
            }
        });
    }

    private Action createChangeModelAction() {
        AbstractAction abstractAction = new AbstractAction("Use Cyclic", new ImageIcon(ChainsawIcons.REFRESH)){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                logPanel.toggleCyclic();
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        abstractAction.putValue("ShortDescription", "Changes between Cyclic and Unlimited mode.");
        return abstractAction;
    }

    private Action createToggleLogTreeAction() {
        AbstractAction abstractAction = new AbstractAction("Toggle the Logger Tree Pane"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleLogTreeVisible();
                }
            }
        };
        abstractAction.putValue("ShortDescription", "Toggles the Logger Tree Pane");
        abstractAction.putValue("enabled", Boolean.TRUE);
        abstractAction.putValue("MnemonicKey", new Integer(84));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        return abstractAction;
    }

    private Action createScrollToBottomAction() {
        AbstractAction abstractAction = new AbstractAction("Toggle Scroll to Bottom"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleScrollToBottom();
                }
            }
        };
        abstractAction.putValue("ShortDescription", "Toggles Scroll to Bottom");
        abstractAction.putValue("enabled", Boolean.TRUE);
        abstractAction.putValue("MnemonicKey", new Integer(66));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        return abstractAction;
    }

    public void stateChange() {
        this.scanState();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.scanState();
    }

    JMenuBar getMenubar() {
        return this.menuBar;
    }

    JToolBar getToolbar() {
        return this.toolbar;
    }

    private Action createClearAction() {
        AbstractAction abstractAction = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.clearEvents();
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(67));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 2));
        abstractAction.putValue("ShortDescription", "Removes all the events from the current view");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        return abstractAction;
    }

    private Action createCloseHelpAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.closeAction.putValue("Name", "Welcome tab");
                ChainsawToolBarAndMenus.this.logui.removeWelcomePanel();
                if (ChainsawToolBarAndMenus.this.menuItemClose.isSelected()) {
                    ChainsawToolBarAndMenus.this.logui.addWelcomePanel();
                }
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        abstractAction.putValue("ShortDescription", "Toggles the Welcome tab");
        abstractAction.putValue("MnemonicKey", new Integer(67));
        abstractAction.putValue("Name", "Welcome tab");
        return abstractAction;
    }

    private void createMenuBar() {
        JMenuItem jMenuItem = new JMenuItem("Other options available via panel's right mouse button popup menu");
        jMenuItem.setEnabled(false);
        this.viewMenu.setMnemonic('V');
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.toggleToolbarAction);
        jCheckBoxMenuItem.setSelected(this.logui.getApplicationPreferenceModel().isToolbar());
        this.logui.getApplicationPreferenceModel().addPropertyChangeListener("toolbar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jCheckBoxMenuItem.setSelected(bl);
            }
        });
        this.menuItemClose.setAction(this.closeAction);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(this.pauseAction);
        JMenuItem jMenuItem2 = new JMenuItem(this.showPreferencesAction);
        jMenuItem2.setText(this.showPreferencesAction.getValue("ShortDescription").toString());
        JMenuItem jMenuItem3 = new JMenuItem(this.customExpressionPanelAction);
        jMenuItem3.setText(this.customExpressionPanelAction.getValue("ShortDescription").toString());
        JMenuItem jMenuItem4 = new JMenuItem(this.showColorPanelAction);
        jMenuItem4.setText(this.showColorPanelAction.getValue("ShortDescription").toString());
        JMenuItem jMenuItem5 = new JMenuItem(this.undockAction);
        JMenuItem jMenuItem6 = new JMenuItem("Show Application-wide Preferences...");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.showApplicationPreferences();
            }
        });
        this.toggleDetailMenuItem.setAction(this.toggleDetailPaneAction);
        this.toggleDetailMenuItem.setSelected(true);
        this.toggleCyclicMenuItem.setAction(this.changeModelAction);
        this.toggleCyclicMenuItem.setSelected(true);
        this.toggleLogTreeMenuItem.setAction(this.toggleLogTreeAction);
        this.toggleLogTreeMenuItem.setSelected(true);
        this.toggleScrollToBottomMenuItem.setAction(this.toggleScrollToBottomAction);
        AbstractAction abstractAction = new AbstractAction("Show Status bar"){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setStatusBar(ChainsawToolBarAndMenus.this.toggleStatusBarCheck.isSelected());
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(66));
        this.toggleStatusBarCheck.setAction(abstractAction);
        this.toggleStatusBarCheck.setSelected(this.logui.getApplicationPreferenceModel().isStatusBar());
        this.activeTabMenu.add(jCheckBoxMenuItem2);
        this.activeTabMenu.add(this.toggleCyclicMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(this.toggleDetailMenuItem);
        this.activeTabMenu.add(this.toggleLogTreeMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(jMenuItem5);
        this.activeTabMenu.add(jMenuItem4);
        this.activeTabMenu.add(jMenuItem2);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new JMenuItem(this.clearAction));
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(this.toggleScrollToBottomMenuItem);
        this.activeTabMenu.add(jMenuItem);
        this.viewMenu.add(jCheckBoxMenuItem);
        this.viewMenu.add(this.toggleStatusBarCheck);
        this.viewMenu.add(this.toggleShowReceiversCheck);
        this.viewMenu.add(this.menuItemClose);
        this.viewMenu.addSeparator();
        this.viewMenu.add(jMenuItem3);
        this.viewMenu.addSeparator();
        this.viewMenu.add(jMenuItem6);
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic('H');
        JMenuItem jMenuItem7 = new JMenuItem("About Chainsaw v2...");
        jMenuItem7.setMnemonic('A');
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.showAboutBox();
            }
        });
        AbstractAction abstractAction2 = new AbstractAction("Tutorial...", new ImageIcon(ChainsawIcons.HELP)){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.setupTutorial();
            }
        };
        abstractAction2.putValue("ShortDescription", "Starts the tutorial process");
        jMenu.add(abstractAction2);
        List list = ReceiversHelper.getInstance().getKnownReceiverClasses();
        JMenu jMenu2 = new JMenu("Receiver JavaDoc");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            final Class clazz = (Class)iterator.next();
            jMenu2.add(new AbstractAction(clazz.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpManager.getInstance().showHelpForClass(clazz);
                }
            });
        }
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(CommonActions.getInstance().getShowReleaseNotes());
        jMenu.add(jMenuItem7);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.activeTabMenu);
        this.menuBar.add(jMenu);
    }

    private Action createPauseAction() {
        AbstractAction abstractAction = new AbstractAction("Pause"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.setPaused(!logPanel.isPaused());
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(80));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        abstractAction.putValue("ShortDescription", "Causes incoming events for this tab to be discarded");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        return abstractAction;
    }

    private Action createShowPreferencesAction() {
        AbstractAction abstractAction = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showPreferences();
                }
            }
        };
        abstractAction.putValue("ShortDescription", "LogPanel Preferences...");
        return abstractAction;
    }

    private Action createCustomExpressionPanelAction() {
        final JDialog jDialog = new JDialog(this.logui, "Define tab", true);
        jDialog.getContentPane().add(this.getCustomExpressionPanel());
        jDialog.pack();
        AbstractAction abstractAction = new AbstractAction("", ChainsawIcons.ICON_HELP){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(true);
            }
        };
        abstractAction.putValue("ShortDescription", "Create custom expression LogPanel...");
        return abstractAction;
    }

    private Action createShowColorPanelAction() {
        AbstractAction abstractAction = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showColorPreferences();
                }
            }
        };
        abstractAction.putValue("ShortDescription", "LogPanel Color Filter...");
        return abstractAction;
    }

    private Action createShowReceiversAction() {
        AbstractAction abstractAction = new AbstractAction("Show Receivers"){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setReceivers(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isReceivers());
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(69));
        abstractAction.putValue("ShortDescription", "Shows the currently configured Log4j Receivers");
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT));
        this.toggleShowReceiversCheck.setAction(abstractAction);
        return abstractAction;
    }

    private Action createToggleDetailPaneAction() {
        AbstractAction abstractAction = new AbstractAction("Show Detail Pane"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.toggleDetailVisible();
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(68));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 8));
        abstractAction.putValue("ShortDescription", "Hides/Shows the Detail Pane");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.INFO));
        return abstractAction;
    }

    private Action createToggleToolbarAction() {
        AbstractAction abstractAction = new AbstractAction("Show Toolbar"){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setToolbar(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isToolbar());
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(84));
        return abstractAction;
    }

    private void createToolbar() {
        Insets insets = new Insets(1, 1, 1, 1);
        FileMenu fileMenu = (FileMenu)this.menuBar.getMenu(0);
        SmallButton smallButton = new SmallButton(fileMenu.getLog4JFileOpenAction());
        smallButton.setMargin(insets);
        SmallButton smallButton2 = new SmallButton(fileMenu.getFileSaveAction());
        smallButton2.setMargin(insets);
        smallButton.setText("");
        smallButton2.setText("");
        this.toolbar.add(smallButton);
        this.toolbar.add(smallButton2);
        this.toolbar.addSeparator();
        this.pauseButton.setAction(this.pauseAction);
        this.pauseButton.setText("");
        this.pauseButton.getActionMap().put(this.pauseAction.getValue("Name"), this.pauseAction);
        this.toggleCyclicButton.setAction(this.changeModelAction);
        this.toggleCyclicButton.setText(null);
        this.detailPaneButton.setAction(this.toggleDetailPaneAction);
        this.detailPaneButton.setText(null);
        this.detailPaneButton.getActionMap().put(this.toggleDetailPaneAction.getValue("Name"), this.toggleDetailPaneAction);
        this.detailPaneButton.getInputMap(2).put(KeyStroke.getKeyStroke(68, 8), this.toggleDetailPaneAction.getValue("Name"));
        this.logTreePaneButton.setAction(this.toggleLogTreeAction);
        this.logTreePaneButton.getActionMap().put(this.toggleLogTreeAction.getValue("Name"), this.toggleLogTreeAction);
        this.logTreePaneButton.getInputMap(2).put(KeyStroke.getKeyStroke(84, 8), this.toggleLogTreeAction.getValue("Name"));
        this.logTreePaneButton.setText(null);
        this.scrollToBottomButton.setAction(this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getActionMap().put(this.toggleScrollToBottomAction.getValue("Name"), this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getInputMap(2).put(KeyStroke.getKeyStroke(66, 2), this.toggleScrollToBottomAction.getValue("Name"));
        this.scrollToBottomButton.setText(null);
        SmallButton smallButton3 = new SmallButton(this.showPreferencesAction);
        SmallButton smallButton4 = new SmallButton(this.undockAction);
        smallButton4.setText("");
        this.toolbar.add(smallButton4);
        this.toolbar.add(this.pauseButton);
        this.toolbar.add(this.toggleCyclicButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.detailPaneButton);
        this.toolbar.add(this.logTreePaneButton);
        this.toolbar.add(this.scrollToBottomButton);
        this.toolbar.add(smallButton3);
        this.toolbar.addSeparator();
        this.toolbar.add(this.clearButton);
        this.clearButton.setAction(this.clearAction);
        this.clearButton.setText("");
        this.toolbar.addSeparator();
        SmallButton smallButton5 = new SmallButton(this.findNextAction);
        smallButton5.setText("");
        smallButton5.getActionMap().put(this.findNextAction.getValue("Name"), this.findNextAction);
        smallButton5.getInputMap(2).put((KeyStroke)this.findNextAction.getValue("AcceleratorKey"), this.findNextAction.getValue("Name"));
        SmallButton smallButton6 = new SmallButton(this.findPreviousAction);
        smallButton6.setText("");
        smallButton6.getActionMap().put(this.findPreviousAction.getValue("Name"), this.findPreviousAction);
        smallButton6.getInputMap(2).put((KeyStroke)this.findPreviousAction.getValue("AcceleratorKey"), this.findPreviousAction.getValue("Name"));
        this.findPanel.add(this.findField);
        this.toolbar.add(this.findPanel);
        this.toolbar.add(smallButton5);
        this.toolbar.add(smallButton6);
        this.toolbar.addSeparator();
        this.showReceiversButton.setText(null);
        this.toolbar.add(this.showReceiversButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.setMargin(insets);
        this.toolbar.setFloatable(false);
    }

    private Action createUndockAction() {
        AbstractAction abstractAction = new AbstractAction("Undock", ChainsawIcons.ICON_UNDOCK){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.undock();
                }
            }
        };
        abstractAction.putValue("ShortDescription", "Undocks the current Log panel into it's own window");
        return abstractAction;
    }

    private void scanState() {
        this.toggleStatusBarCheck.setSelected(this.logui.isStatusBarVisible());
        this.toggleShowReceiversCheck.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.logTreePaneButton.setSelected(this.logui.isLogTreePanelVisible());
        LogPanel logPanel = this.logui.getCurrentLogPanel();
        if (logPanel != null) {
            this.scrollToBottomButton.setSelected(logPanel.isScrollToBottom());
        } else {
            this.scrollToBottomButton.setSelected(false);
        }
        this.showReceiversButton.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.menuItemClose.setSelected(this.logui.getTabbedPane().containsWelcomePanel());
        LogPanel logPanel2 = this.logui.getCurrentLogPanel();
        boolean bl = true;
        if (logPanel2 == null) {
            bl = false;
            this.logui.getStatusBar().clear();
            this.findField.setEnabled(false);
            this.findPanel.removeAll();
            this.findPanel.add(this.findField);
            this.activeTabMenu.setEnabled(false);
            this.closeAction.setEnabled(true);
            this.detailPaneButton.setSelected(false);
            this.toggleCyclicButton.setSelected(false);
        } else {
            this.activeTabMenu.setEnabled(true);
            this.fileMenu.getFileSaveAction().setEnabled(true);
            this.findPanel.removeAll();
            this.findPanel.add(logPanel2.getFindTextField());
            this.pauseButton.getModel().setSelected(logPanel2.isPaused());
            this.toggleCyclicButton.setSelected(logPanel2.isCyclic());
            this.logui.getStatusBar().setPaused(logPanel2.isPaused());
            this.toggleCyclicMenuItem.setSelected(logPanel2.isCyclic());
            this.detailPaneButton.getModel().setSelected(logPanel2.isDetailVisible());
            this.toggleLogTreeMenuItem.setSelected(logPanel2.isLogTreeVisible());
            this.toggleScrollToBottomMenuItem.setSelected(logPanel2.isScrollToBottom());
        }
        this.findPanel.invalidate();
        this.findPanel.revalidate();
        this.findPanel.repaint();
        for (int i = 0; i < this.logPanelSpecificActions.length; ++i) {
            this.logPanelSpecificActions[i].setEnabled(bl);
        }
        String string = UIManager.getLookAndFeel().getName();
        Iterator iterator = this.lookAndFeelMenus.iterator();
        while (iterator.hasNext()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)iterator.next();
            if (jRadioButtonMenuItem.getText().equals(string)) {
                jRadioButtonMenuItem.setSelected(true);
                continue;
            }
            jRadioButtonMenuItem.setSelected(false);
        }
    }

    private Action getFindNextAction() {
        AbstractAction abstractAction = new AbstractAction("Find next"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.findNext();
                }
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
        abstractAction.putValue("ShortDescription", "Find the next occurrence of the rule from the current row");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DOWN));
        return abstractAction;
    }

    private Action getFindPreviousAction() {
        AbstractAction abstractAction = new AbstractAction("Find previous"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.findPrevious();
                }
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 1));
        abstractAction.putValue("ShortDescription", "Find the previous occurrence of the rule from the current row");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UP));
        return abstractAction;
    }

    private JPanel getCustomExpressionPanel() {
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Enter expression for new tab:  "), "North");
        final JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new ExpressionRuleContext(new FilterModel(), jTextField));
        jPanel.add((Component)jTextField, "Center");
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Close");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(7));
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainsawToolBarAndMenus.this.logui.createCustomExpressionLogPanel(jTextField.getText());
                SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ChainsawToolBarAndMenus.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, jPanel).setVisible(false);
            }
        });
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ChainsawToolBarAndMenus.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, jPanel).setVisible(false);
            }
        });
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

