/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;

public class ApplicationPreferenceModel
implements SettingsListener {
    private boolean showNoReceiverWarning;
    private boolean statusBar;
    private boolean toolbar;
    private boolean receivers;
    private boolean confirmExit;
    private boolean showSplash;
    private String lookAndFeelClassName;
    private int toolTipDisplayMillis;
    private int cyclicBufferSize;
    private String lastUsedVersion;
    private int responsiveness;
    private String identifierExpression = "hostname - application";
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private int tabPlacement;
    private String configurationURL = "";
    private boolean okToRemoveSecurityManager;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    private void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.propertySupport.firePropertyChange(string, bl, bl2);
    }

    private void firePropertyChange(String string, int n, int n2) {
        this.propertySupport.firePropertyChange(string, n, n2);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    public boolean hasListeners(String string) {
        return this.propertySupport.hasListeners(string);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final boolean isShowNoReceiverWarning() {
        return this.showNoReceiverWarning;
    }

    public final String getIdentifierExpression() {
        return this.identifierExpression;
    }

    public final void setCyclicBufferSize(int n) {
        int n2 = this.cyclicBufferSize;
        this.cyclicBufferSize = n;
        this.firePropertyChange("cyclicBufferSize", n2, n);
    }

    public final int getCyclicBufferSize() {
        return this.cyclicBufferSize;
    }

    public final void setToolTipDisplayMillis(int n) {
        int n2 = this.toolTipDisplayMillis;
        this.toolTipDisplayMillis = n;
        this.firePropertyChange("toolTipDisplayMillis", n2, n);
    }

    public final int getToolTipDisplayMillis() {
        return this.toolTipDisplayMillis;
    }

    public final void setIdentifierExpression(String string) {
        String string2 = this.identifierExpression;
        this.identifierExpression = string;
        this.firePropertyChange("identifierExpression", string2, string);
    }

    public final void setShowNoReceiverWarning(boolean bl) {
        boolean bl2 = this.showNoReceiverWarning;
        this.showNoReceiverWarning = bl;
        this.firePropertyChange("showNoReceiverWarning", bl2, bl);
    }

    public void loadSettings(LoadSettingsEvent loadSettingsEvent) {
        this.setShowNoReceiverWarning(loadSettingsEvent.asBoolean("showNoReceiverWarning"));
        this.setIdentifierExpression(loadSettingsEvent.getSetting("identifierExpression"));
        this.setResponsiveness(loadSettingsEvent.asInt("Responsiveness"));
        this.setTabPlacement(loadSettingsEvent.asInt("tabPlacement"));
        this.setStatusBar(loadSettingsEvent.asBoolean("statusBar"));
        this.setToolbar(loadSettingsEvent.asBoolean("toolbar"));
        this.setReceivers(loadSettingsEvent.asBoolean("receivers"));
        this.setLookAndFeelClassName(loadSettingsEvent.getSetting("lookAndFeelClassName"));
        this.setConfirmExit(loadSettingsEvent.asBoolean("confirmExit"));
        this.setShowSplash(loadSettingsEvent.asBoolean("showSplash"));
        this.setToolTipDisplayMillis(loadSettingsEvent.asInt("toolTipDisplayMillis"));
        this.setCyclicBufferSize(loadSettingsEvent.asInt("cyclicBufferSize"));
        this.setConfigurationURL(loadSettingsEvent.getSetting("configurationURL"));
        this.setLastUsedVersion(loadSettingsEvent.getSetting("lastUsedVersion"));
        this.setOkToRemoveSecurityManager(loadSettingsEvent.asBoolean("okToRemoveSecurityManager"));
    }

    public void saveSettings(SaveSettingsEvent saveSettingsEvent) {
        saveSettingsEvent.saveSetting("showNoReceiverWarning", this.isShowNoReceiverWarning());
        saveSettingsEvent.saveSetting("identifierExpression", this.getIdentifierExpression());
        saveSettingsEvent.saveSetting("Responsiveness", this.getResponsiveness());
        saveSettingsEvent.saveSetting("tabPlacement", this.getTabPlacement());
        saveSettingsEvent.saveSetting("statusBar", this.isStatusBar());
        saveSettingsEvent.saveSetting("toolbar", this.isToolbar());
        saveSettingsEvent.saveSetting("receivers", this.isReceivers());
        saveSettingsEvent.saveSetting("lookAndFeelClassName", this.getLookAndFeelClassName());
        saveSettingsEvent.saveSetting("confirmExit", this.isConfirmExit());
        saveSettingsEvent.saveSetting("showSplash", this.isShowSplash());
        saveSettingsEvent.saveSetting("toolTipDisplayMillis", this.getToolTipDisplayMillis());
        saveSettingsEvent.saveSetting("cyclicBufferSize", this.getCyclicBufferSize());
        saveSettingsEvent.saveSetting("configurationURL", this.getConfigurationURL());
        saveSettingsEvent.saveSetting("lastUsedVersion", this.getLastUsedVersion());
        saveSettingsEvent.saveSetting("okToRemoveSecurityManager", this.isOkToRemoveSecurityManager());
    }

    public void apply(ApplicationPreferenceModel applicationPreferenceModel) {
        this.setIdentifierExpression(applicationPreferenceModel.getIdentifierExpression());
        this.setShowNoReceiverWarning(applicationPreferenceModel.isShowNoReceiverWarning());
        this.setResponsiveness(applicationPreferenceModel.getResponsiveness());
        this.setTabPlacement(applicationPreferenceModel.getTabPlacement());
        this.setStatusBar(applicationPreferenceModel.isStatusBar());
        this.setToolbar(applicationPreferenceModel.isToolbar());
        this.setReceivers(applicationPreferenceModel.isReceivers());
        this.setLookAndFeelClassName(applicationPreferenceModel.getLookAndFeelClassName());
        this.setConfirmExit(applicationPreferenceModel.isConfirmExit());
        this.setShowSplash(applicationPreferenceModel.isShowSplash());
        this.setToolTipDisplayMillis(applicationPreferenceModel.getToolTipDisplayMillis());
        this.setCyclicBufferSize(applicationPreferenceModel.getCyclicBufferSize());
        this.setConfigurationURL(applicationPreferenceModel.getConfigurationURL());
        this.setLastUsedVersion(applicationPreferenceModel.getLastUsedVersion());
        this.setOkToRemoveSecurityManager(applicationPreferenceModel.isOkToRemoveSecurityManager());
    }

    public final int getResponsiveness() {
        return this.responsiveness;
    }

    public final void setResponsiveness(int n) {
        int n2 = this.responsiveness;
        this.responsiveness = n >= 1000 ? (n - 750) / 1000 : n;
        this.firePropertyChange("responsiveness", n2, this.responsiveness);
    }

    public void setTabPlacement(int n) {
        int n2 = this.tabPlacement;
        this.tabPlacement = n;
        this.firePropertyChange("tabPlacement", n2, this.tabPlacement);
    }

    public final int getTabPlacement() {
        return this.tabPlacement;
    }

    public final boolean isStatusBar() {
        return this.statusBar;
    }

    public final void setStatusBar(boolean bl) {
        boolean bl2 = this.statusBar;
        this.statusBar = bl;
        this.firePropertyChange("statusBar", bl2, this.statusBar);
    }

    public final boolean isReceivers() {
        return this.receivers;
    }

    public final void setReceivers(boolean bl) {
        boolean bl2 = this.receivers;
        this.receivers = bl;
        this.firePropertyChange("receivers", bl2, this.receivers);
    }

    public final boolean isToolbar() {
        return this.toolbar;
    }

    public final void setToolbar(boolean bl) {
        boolean bl2 = this.toolbar;
        this.toolbar = bl;
        this.firePropertyChange("toolbar", bl2, this.toolbar);
    }

    public final String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public final void setLookAndFeelClassName(String string) {
        String string2 = this.lookAndFeelClassName;
        this.lookAndFeelClassName = string;
        this.firePropertyChange("lookAndFeelClassName", string2, this.lookAndFeelClassName);
    }

    public final boolean isConfirmExit() {
        return this.confirmExit;
    }

    public final void setConfirmExit(boolean bl) {
        boolean bl2 = this.confirmExit;
        this.confirmExit = bl;
        this.firePropertyChange("confirmExit", bl2, this.confirmExit);
    }

    public final boolean isShowSplash() {
        return this.showSplash;
    }

    public final void setShowSplash(boolean bl) {
        boolean bl2 = this.showSplash;
        this.showSplash = bl;
        this.firePropertyChange("showSplash", bl2, this.showSplash);
    }

    public final String getConfigurationURL() {
        return this.configurationURL;
    }

    public final void setConfigurationURL(String string) {
        String string2 = this.configurationURL;
        this.configurationURL = string;
        this.firePropertyChange("configurationURL", string2, this.configurationURL);
    }

    public final String getLastUsedVersion() {
        return this.lastUsedVersion;
    }

    public final void setLastUsedVersion(String string) {
        String string2 = this.lastUsedVersion;
        this.lastUsedVersion = string;
        this.firePropertyChange("lastUsedVersion", string2, this.lastUsedVersion);
    }

    public final boolean isOkToRemoveSecurityManager() {
        return this.okToRemoveSecurityManager;
    }

    public final void setOkToRemoveSecurityManager(boolean bl) {
        boolean bl2 = this.okToRemoveSecurityManager;
        this.okToRemoveSecurityManager = bl;
        this.firePropertyChange("okToRemoveSecurityManager", bl2, this.okToRemoveSecurityManager);
    }
}

