/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.apache.log4j.Layout;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends Layout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    private String conversionPattern;
    private PatternConverter head;
    private HashMap ruleRegistry = null;

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String pattern) {
        this.conversionPattern = pattern;
        this.activateOptions();
    }

    public void addConversionRule(String conversionWord, String converterClass) {
        if (this.ruleRegistry == null) {
            this.ruleRegistry = new HashMap(5);
        }
        this.ruleRegistry.put(conversionWord, converterClass);
    }

    public HashMap getRuleRegistry() {
        return this.ruleRegistry;
    }

    public void setConversionPattern(String conversionPattern) {
        this.conversionPattern = conversionPattern;
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public void activateOptions() {
        PatternParser patternParser = new PatternParser(this.conversionPattern);
        patternParser.setConverterRegistry(this.ruleRegistry);
        this.head = patternParser.parse();
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        PatternConverter c = this.head;
        while (c != null) {
            c.format(output, event);
            c = c.next;
        }
    }
}

