/*
 * Decompiled with CFR 0.152.
 */
package org.apache.joran;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.joran.ErrorItem;
import org.apache.joran.Interpreter;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.xml.sax.Locator;

public class ExecutionContext {
    static final Logger logger = Logger.getLogger(class$org$apache$joran$ExecutionContext == null ? (class$org$apache$joran$ExecutionContext = ExecutionContext.class$("org.apache.joran.ExecutionContext")) : class$org$apache$joran$ExecutionContext);
    Stack objectStack;
    HashMap objectMap;
    Vector errorList;
    Properties substitutionProperties;
    Interpreter joranInterpreter;
    static /* synthetic */ Class class$org$apache$joran$ExecutionContext;

    public ExecutionContext(Interpreter joranInterpreter) {
        this.joranInterpreter = joranInterpreter;
        this.objectStack = new Stack();
        this.objectMap = new HashMap(5);
        this.errorList = new Vector();
        this.substitutionProperties = new Properties();
    }

    public void addError(ErrorItem errorItem) {
        Locator locator = this.joranInterpreter.getLocator();
        if (locator != null) {
            errorItem.setLineNumber(locator.getLineNumber());
            errorItem.setColNumber(locator.getColumnNumber());
        }
        this.errorList.add(errorItem);
    }

    public List getErrorList() {
        return this.errorList;
    }

    public Locator getLocator() {
        return this.joranInterpreter.getLocator();
    }

    public Interpreter getJoranInterpreter() {
        return this.joranInterpreter;
    }

    public Stack getObjectStack() {
        return this.objectStack;
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o) {
        this.objectStack.push(o);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int i) {
        return this.objectStack.get(i);
    }

    public HashMap getObjectMap() {
        return this.objectMap;
    }

    public void addProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (this.substitutionProperties.contains(key)) {
            LogLog.warn("key [" + key + "] already contained in the EC properties. Overwriting.");
        }
        value = value.trim();
        this.substitutionProperties.put(key, value);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            LogLog.debug("Adding property [" + key + "=" + props.getProperty(key) + "]");
            this.addProperty(key, props.getProperty(key));
        }
    }

    public String getSubstitutionProperty(String key) {
        return this.substitutionProperties.getProperty(key);
    }

    public String subst(String value) {
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, this.substitutionProperties);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Could not perform variable substitution for variable [" + value + "]", e);
            return value;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

