/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.JCoTraceWriter;
import com.sap.conn.rfc.engine.Trc;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Trace {
    public static final int NONE = 0;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int INFO = 8;
    public static final int INFO2 = 16;
    public static final int INFO3 = 32;
    public static final int PATH = 64;
    public static final int PATH2 = 128;
    public static final int PATH3 = 256;
    static final int DUMMY1 = 512;
    static final int DUMMY2 = 1024;
    public static final int ENFORCE = 0;
    protected static final String CRLF = System.getProperty("line.separator");
    protected static final String LF = System.getProperty("line.separator");
    protected static DateFormat timeStamp = new SimpleDateFormat("HH':'mm':'ss':'SSS");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static JCoTraceWriter[] writerList = new JCoTraceWriter[0];
    protected static JCoTraceListener[] listenerList = new JCoTraceListener[0];
    private static int envTraceLevel = 0;
    private static int writerCount = 0;
    private static int listenerCount = 0;
    protected static int jcoLogLevel = 0;
    protected static int internalLogLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addTraceWriter(JCoTraceWriter writer) {
        if (writer == null) {
            return;
        }
        if (Trace.indexOf(writer) > -1) {
            return;
        }
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            if (writerCount == writerList.length) {
                JCoTraceWriter[] newList = new JCoTraceWriter[writerList.length + 1];
                System.arraycopy(writerList, 0, newList, 0, writerList.length);
                writerList = newList;
            }
            Trace.writerList[Trace.writerCount++] = writer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTracelistener(JCoTraceListener listener) {
        if (listener == null) {
            return;
        }
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            if (Trace.indexOf(listener) > -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (listenerCount == listenerList.length) {
                JCoTraceListener[] newList = new JCoTraceListener[listenerList.length + 3];
                System.arraycopy(listenerList, 0, newList, 0, listenerList.length);
                listenerList = newList;
            }
            Trace.listenerList[Trace.listenerCount++] = listener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeTraceWriter(JCoTraceWriter writer) {
        if (writer == null) {
            return;
        }
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            int idx = Trace.indexOf(writer);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < writerCount - 1) {
                System.arraycopy(writerList, idx + 1, writerList, idx, writerCount - 1);
            }
            --writerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(JCoTraceListener listener) {
        if (listener == null) {
            return;
        }
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            int idx = Trace.indexOf(listener);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < listenerCount - 1) {
                System.arraycopy(listenerList, idx + 1, listenerList, idx, listenerCount - idx - 1);
            }
            --listenerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(JCoTraceListener listener) {
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            for (int i = 0; i < listenerCount; ++i) {
                if (listener != listenerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(JCoTraceWriter writer) {
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                if (writer != writerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    public static int getTraceWriterCount() {
        return writerCount;
    }

    public static int getTraceListenerCount() {
        return listenerCount;
    }

    protected static int toExternalTraceLevel(int internalLevel) {
        int externalLevel = 0;
        if ((internalLevel & 2) != 0) {
            externalLevel = 1;
        }
        if ((internalLevel & 4) != 0) {
            externalLevel = 2;
        }
        if ((internalLevel & 8) != 0) {
            externalLevel = 3;
        }
        if ((internalLevel & 0x40) != 0) {
            externalLevel = 4;
        }
        if ((internalLevel & 0x80) != 0) {
            externalLevel = 5;
        }
        if ((internalLevel & 0x10) != 0) {
            externalLevel = 6;
        }
        if ((internalLevel & 0x100) != 0) {
            externalLevel = 7;
        }
        if ((internalLevel & 0x20) != 0) {
            externalLevel = 8;
        }
        if ((internalLevel & 0x200) != 0) {
            externalLevel = 9;
        }
        if ((internalLevel & 0x400) != 0) {
            externalLevel = 10;
        }
        return externalLevel;
    }

    protected static int toInternalTraceLevel(int externalLevel) {
        int logLevel = 0;
        if (externalLevel > 10) {
            externalLevel = 10;
        }
        switch (externalLevel) {
            case 10: {
                logLevel = 2046;
                break;
            }
            case 9: {
                logLevel = 1022;
                break;
            }
            case 8: {
                logLevel = 510;
                break;
            }
            case 7: {
                logLevel = 478;
                break;
            }
            case 6: {
                logLevel = 222;
                break;
            }
            case 5: {
                logLevel = 206;
                break;
            }
            case 4: {
                logLevel = 78;
                break;
            }
            case 3: {
                logLevel = 14;
                break;
            }
            case 2: {
                logLevel = 6;
                break;
            }
            case 1: {
                logLevel = 2;
                break;
            }
            default: {
                logLevel = 0;
            }
        }
        return logLevel;
    }

    protected Trace() {
    }

    public abstract void trace(int var1, String var2);

    static StringBuilder bufferForConnectionProperties(Properties properties) {
        StringBuilder buf = new StringBuilder();
        if (properties == null) {
            buf.append("null");
        } else {
            Object val = null;
            buf.append('{');
            for (Object key : properties.keySet()) {
                val = "jco.client.passwd".equals(key) || "jco.destination.repository.passwd".equals(key) ? "*secret*" : properties.get(key);
                buf.append(key.toString()).append('=').append(val.toString()).append(',');
            }
            if (buf.length() > 1) {
                buf.setCharAt(buf.length() - 1, '}');
            } else {
                buf.append('}');
            }
        }
        return buf;
    }

    public static String dumpContent(char[] chars) {
        return Trace.dumpContent(chars, true, chars.length);
    }

    public static String dumpContent(char[] chars, boolean withHex, int lengthToDump) {
        if (chars == null) {
            chars = new char[]{};
        }
        if (lengthToDump < 0 || lengthToDump > chars.length) {
            lengthToDump = chars.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 20) {
            int k;
            buf.append("|");
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                buf.append(offsets[k]);
            }
            buf.append("|");
            if (withHex) {
                for (k = 0; k < 20; ++k) {
                    if (i + k < chars.length) {
                        hexs[k * 4 + 0] = HEX[chars[i + k] >> 12 & 0xF];
                        hexs[k * 4 + 1] = HEX[chars[i + k] >> 8 & 0xF];
                        hexs[k * 4 + 2] = HEX[chars[i + k] >> 4 & 0xF];
                        hexs[k * 4 + 3] = HEX[chars[i + k] & 0xF];
                        continue;
                    }
                    hexs[k * 4 + 3] = 32;
                    hexs[k * 4 + 2] = 32;
                    hexs[k * 4 + 1] = 32;
                    hexs[k * 4] = 32;
                }
                for (k = 0; k < hexs.length; ++k) {
                    if (k != 0 && 0 == k % 20) {
                        buf.append(' ');
                    }
                    buf.append(hexs[k]);
                }
                buf.append('|');
            }
            for (k = 0; k < 20; ++k) {
                char curChar = i + k < chars.length ? chars[i + k] : (char)' ';
                buf.append(!Character.isISOControl(curChar) && Character.isDefined(curChar) && (curChar < '\ud800' || curChar >= '\ue000') ? curChar : (char)'.');
            }
            buf.append('|');
            buf.append(LF);
        }
        return buf.toString();
    }

    public static String dumpContent(byte[] bytes) {
        return Trace.dumpContent(bytes, bytes.length);
    }

    public static String dumpContent(byte[] bytes, int lengthToDump) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (lengthToDump < 0 || lengthToDump > bytes.length) {
            lengthToDump = bytes.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 40) {
            int k;
            buf.append("|");
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                buf.append(offsets[k]);
            }
            buf.append("|");
            for (k = 0; k < 40; ++k) {
                if (i + k < bytes.length) {
                    hexs[k * 2 + 0] = HEX[bytes[i + k] >> 4 & 0xF];
                    hexs[k * 2 + 1] = HEX[bytes[i + k] & 0xF];
                    continue;
                }
                hexs[k * 2 + 1] = 32;
                hexs[k * 2] = 32;
            }
            for (k = 0; k < hexs.length; ++k) {
                if (k != 0 && 0 == k % 20) {
                    buf.append(' ');
                }
                buf.append(hexs[k]);
            }
            buf.append('|');
            buf.append(LF);
        }
        return buf.toString();
    }

    private static StringBuilder dumpMetadata(List<Object> mdsToDump, List<Object> dumpedMds) {
        StringBuilder buf = new StringBuilder();
        byte itype = 0;
        while (!mdsToDump.isEmpty()) {
            AbstractMetaData md;
            AbstractRecord r;
            Object o = mdsToDump.remove(0);
            if (o instanceof AbstractMetaData) {
                r = null;
                md = (AbstractMetaData)o;
            } else if (o instanceof AbstractRecord) {
                r = (AbstractRecord)o;
                md = r.metaData;
            } else {
                buf.append("warning unexpected class ").append(o.getClass().getName()).append(CRLF);
                continue;
            }
            buf.append(md.getName()).append(CRLF);
            for (int index = 0; index < md.getFieldCount(); ++index) {
                JCoRecord rec;
                int c;
                buf.append("   ");
                String str = md.name[index];
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = "-";
                o = md.getRecordTypeName(index);
                if (o != null) {
                    str = (String)o;
                }
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = md.getTypeAsString(index);
                buf.append(str);
                for (c = str.length(); c < 10; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.boffset[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.blength[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoRecordMetaData) {
                    str = String.valueOf(((JCoRecordMetaData)((Object)md)).getByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoRecordMetaData) {
                    str = String.valueOf(((JCoRecordMetaData)((Object)md)).getUnicodeByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getUnicodeByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoListMetaData) {
                    if (((JCoListMetaData)((Object)md)).isImport(index)) {
                        buf.append('I');
                    }
                    if (((JCoListMetaData)((Object)md)).isChanging(index)) {
                        buf.append('C');
                    }
                    if (((JCoListMetaData)((Object)md)).isExport(index)) {
                        buf.append('E');
                    }
                    if (((JCoListMetaData)((Object)md)).isOptional(index)) {
                        buf.append('O');
                    }
                    if (r != null && r instanceof DefaultParameterList) {
                        if (((DefaultParameterList)r).isActive(index)) {
                            buf.append('A');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 1) != 0) {
                            buf.append('u');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 8) != 0) {
                            buf.append('s');
                        }
                    }
                }
                buf.append(CRLF);
                itype = md.type[index];
                if (itype != 17 && itype != 99) continue;
                if (md.getRecordMetaData(index) != null) {
                    if (dumpedMds.contains(md.getRecordMetaData(index))) continue;
                    mdsToDump.add(md.getRecordMetaData(index));
                    continue;
                }
                if (r == null || r.getValue(index) == null || (rec = (JCoRecord)r.getValue(index)).getMetaData() == null || dumpedMds.contains(rec.getMetaData())) continue;
                mdsToDump.add(rec.getMetaData());
            }
        }
        return buf;
    }

    protected static StringBuilder dumpMetadata(Object obj, List<Object> dumpedMds) {
        if (obj == null) {
            return new StringBuilder();
        }
        try {
            ArrayList<Object> mdsToDump = new ArrayList<Object>();
            if (dumpedMds == null) {
                dumpedMds = new ArrayList<Object>();
            }
            mdsToDump.add(obj);
            StringBuilder buf = Trace.dumpMetadata(mdsToDump, dumpedMds);
            return buf;
        }
        catch (Throwable t) {
            StringBuilder buf = new StringBuilder();
            buf.append("[").append(t.toString()).append(" within the trace]");
            return buf;
        }
    }

    protected static String dumpMetadata(Object obj) {
        if (obj instanceof JCoFunction) {
            JCoFunction f = (JCoFunction)obj;
            ArrayList<Object> dumped = new ArrayList<Object>();
            StringBuilder buffer = new StringBuilder();
            if (f.getImportParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getImportParameterList(), dumped));
            }
            if (f.getExportParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getExportParameterList(), dumped));
            }
            if (f.getChangingParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getChangingParameterList(), dumped));
            }
            if (f.getTableParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getTableParameterList(), dumped));
            }
            return buffer.toString();
        }
        return Trace.dumpMetadata(obj, null).toString();
    }

    protected static String dumpRecord(Object obj) {
        if (obj == null) {
            return " null ";
        }
        StringBuilder buf = new StringBuilder();
        AbstractRecord rec = null;
        AbstractRecord r = null;
        if (obj instanceof AbstractRecord) {
            rec = (AbstractRecord)obj;
            boolean dumpHex = Trace.isOn(256);
            boolean fullDumps = Trace.isOn(32);
            if (rec.metaData.numOdata != rec.metaData.numFields) {
                buf.append("content:").append(CRLF).append(Trace.dumpContent(rec.data, dumpHex, fullDumps ? rec.data.length : Math.min(1000, rec.data.length)));
            }
            for (int index = 0; index < rec.metaData.numFields; ++index) {
                byte itype = rec.metaData.type[index];
                if (itype != 29 && itype != 30 && itype != 17 && itype != 99) continue;
                Object o = rec.odata[rec.metaData.oindex[index]];
                buf.append(rec.metaData.name[index]).append(": ");
                if (o == null) {
                    buf.append("null");
                } else if (itype == 29) {
                    char[] ca = ((String)o).toCharArray();
                    buf.append(CRLF).append(Trace.dumpContent(ca, dumpHex, fullDumps ? ca.length : Math.min(1000, ca.length)));
                } else if (itype == 30) {
                    byte[] ba = (byte[])o;
                    buf.append(CRLF).append(Trace.dumpContent(ba, fullDumps ? ba.length : Math.min(1000, ba.length)));
                } else {
                    r = (AbstractRecord)o;
                    boolean isFlat = true;
                    for (int rIdx = 0; rIdx < r.getFieldCount(); ++rIdx) {
                        int rType = r.metaData.getType(rIdx);
                        if (rType != 29 && rType != 30 && rType != 17 && rType != 99) continue;
                        isFlat = false;
                        break;
                    }
                    if (isFlat) {
                        if (itype == 17) {
                            buf.append(CRLF).append(Trace.dumpContent(r.data, dumpHex, fullDumps ? r.data.length : Math.min(1000, r.data.length)));
                        } else {
                            buf.append(r.numRows).append(" row(s)").append(CRLF);
                            int rowsToDump = fullDumps ? r.numRows : Math.min(5, r.numRows);
                            for (int row = 0; row < rowsToDump; ++row) {
                                buf.append("row ").append(row).append(CRLF);
                                buf.append(Trace.dumpContent(r.tableDataRows[row], dumpHex, fullDumps ? r.tableDataRows[row].length : Math.min(1000, r.tableDataRows[row].length)));
                            }
                        }
                    } else {
                        char[] ca = r.toXML().toCharArray();
                        buf.append(CRLF).append(Trace.dumpContent(ca, dumpHex, fullDumps ? ca.length : Math.min(1000, ca.length)));
                    }
                }
                buf.append(CRLF);
            }
        }
        return buf.toString();
    }

    static StringBuilder dumpFunction(StringBuilder buf, boolean withMetadata, boolean withInput, boolean withOutput, JCoFunction function) {
        String functionName = function.getName();
        JCoParameterList input = function.getImportParameterList();
        JCoParameterList changing = function.getChangingParameterList();
        JCoParameterList output = function.getExportParameterList();
        JCoParameterList inputTables = function.getTableParameterList();
        JCoParameterList outputTables = function.getTableParameterList();
        boolean supportsASXML = function.getFunctionTemplate().supportsASXML();
        return Trace.dumpFunction(buf, withMetadata, withInput, withOutput, functionName, input, changing, output, inputTables, outputTables, supportsASXML);
    }

    static StringBuilder dumpFunction(StringBuilder buf, boolean withMetadata, boolean withInput, boolean withOutput, String functionName, JCoParameterList input, JCoParameterList changing, JCoParameterList output, JCoParameterList inputTables, JCoParameterList outputTables, boolean supportsASXML) {
        buf.append(JCoRuntime.CRLF);
        buf.append("Function ").append(functionName).append(" (").append(supportsASXML ? "supports BASXML" : "does not support BASXML").append(')').append(JCoRuntime.CRLF);
        if (withMetadata) {
            ArrayList<Object> dumped = new ArrayList<Object>();
            buf.append((CharSequence)Trace.dumpMetadata(input, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(changing, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(output, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(inputTables, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(outputTables, dumped));
            buf.append(JCoRuntime.CRLF);
        }
        if (withInput) {
            buf.append("Input: ");
            if (input != null) {
                buf.append(CRLF).append(Trace.dumpRecord(input));
            } else {
                buf.append("null");
            }
            buf.append(CRLF);
        }
        if (withOutput) {
            buf.append("Output: ");
            if (output != null) {
                buf.append(JCoRuntime.CRLF).append(Trace.dumpRecord(output));
            } else {
                buf.append("null");
            }
            buf.append(JCoRuntime.CRLF);
        }
        buf.append("Changing: ");
        if (changing != null) {
            buf.append(JCoRuntime.CRLF).append(Trace.dumpRecord(changing));
        } else {
            buf.append("null");
        }
        buf.append(JCoRuntime.CRLF);
        if (withInput) {
            buf.append("Input tables: ");
            if (inputTables != null) {
                buf.append(CRLF).append(Trace.dumpRecord(inputTables));
            } else {
                buf.append("null");
            }
            buf.append(JCoRuntime.CRLF);
        }
        if (withOutput) {
            buf.append("Output tables: ");
            if (outputTables != null) {
                buf.append(JCoRuntime.CRLF).append(Trace.dumpRecord(outputTables));
            } else if (inputTables != null) {
                buf.append(JCoRuntime.CRLF).append(Trace.dumpRecord(inputTables));
            } else {
                buf.append("null");
            }
            buf.append(JCoRuntime.CRLF);
        }
        return buf;
    }

    protected static int setJCoTrace(int level) {
        if (level > 10) {
            level = 10;
        }
        if (level < envTraceLevel) {
            level = envTraceLevel;
        }
        int logLevel = Trace.toInternalTraceLevel(level);
        Trace.setLogLevel(logLevel);
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLogLevel(int level) {
        jcoLogLevel = level;
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; ++i) {
                writersLogLevel |= writerList[i].getTraceLevel();
            }
            internalLogLevel = writersLogLevel | jcoLogLevel;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isOn(int level) {
        return (level & internalLogLevel) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isOn(int level, boolean check) {
        if (check) {
            JCoTraceWriter[] jCoTraceWriterArray = writerList;
            // MONITORENTER : writerList
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; writersLogLevel |= writerList[i].getTraceLevel(), ++i) {
            }
            internalLogLevel = writersLogLevel | jcoLogLevel;
            // MONITOREXIT : jCoTraceWriterArray
        }
        if ((level & internalLogLevel) == 0) return false;
        return true;
    }

    public static void fireTrace(int level, String text, Throwable causedBy) {
        if (Trace.isOn(level)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.write(text);
            if (causedBy != null) {
                pw.write(" stack trace");
                pw.write(CRLF);
                causedBy.printStackTrace(pw);
            }
            pw.flush();
            Trace.fireTrace(level, sw.getBuffer().toString());
        }
    }

    public static void fireTrace(int level, Throwable causedBy) {
        Trace.fireTrace(level, "exception occured:", causedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fireTraceCritical(String msg) {
        try {
            if (Trace.isOn(2, true)) {
                JCoTraceWriter[] jCoTraceWriterArray = writerList;
                // MONITORENTER : writerList
                for (int i = 0; i < writerCount; ++i) {
                    try {
                        writerList[i].trace(2, msg);
                        continue;
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : jCoTraceWriterArray
                int standaloneTraceLevel = Trace.toExternalTraceLevel(2);
                JCoTraceListener[] jCoTraceListenerArray = listenerList;
                // MONITORENTER : listenerList
                for (int i = 0; i < listenerCount; ++i) {
                    try {
                        listenerList[i].trace(standaloneTraceLevel, msg);
                        continue;
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : jCoTraceListenerArray
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trc.generalInfo(null, "[JCoAPI] " + msg);
    }

    public static void fireTraceCritical(String msg, boolean where) {
        try {
            if (where) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                new Throwable().fillInStackTrace().printStackTrace(pw);
                pw.close();
                StringBuilder buffer = new StringBuilder(200);
                buffer.append(msg).append(" ").append(CRLF).append("Stack trace of the call").append(CRLF).append(sw.getBuffer().delete(0, "java.lang.Throwable".length()).toString());
                msg = buffer.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    public static void fireTraceCritical(String msg, Throwable th) {
        try {
            if (th != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                th.printStackTrace(pw);
                pw.close();
                StringBuilder buffer = new StringBuilder(200);
                buffer.append(msg).append(" ").append(sw.getBuffer().toString());
                msg = buffer.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    protected static String levelToString(int level) {
        StringBuilder buf = new StringBuilder();
        if ((level & 2) != 0) {
            buf.append(" ERROR");
        }
        if ((level & 4) != 0) {
            buf.append(" WARNING");
        }
        if ((level & 0x40) != 0) {
            buf.append(" PATH");
        }
        if ((level & 0x80) != 0) {
            buf.append(" PATH2");
        }
        if ((level & 0x100) != 0) {
            buf.append(" PATH3");
        }
        if ((level & 8) != 0) {
            buf.append(" INFO");
        }
        if ((level & 0x10) != 0) {
            buf.append(" INFO2");
        }
        if ((level & 0x20) != 0) {
            buf.append(" INFO3");
        }
        return buf.toString();
    }

    public static void fireTrace(int level, String msg) {
        try {
            Trace.fireTrace(level, msg, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fireTrace(int level, String msg, boolean where) {
        if (where) {
            try {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append(msg).append(" ").append(CRLF);
                Throwable t = new Throwable();
                t.fillInStackTrace();
                StackTraceElement[] stackTrace = t.getStackTrace();
                for (int i = 1; i < stackTrace.length; ++i) {
                    buffer.append("invoked at ").append(stackTrace[i]).append(JCoRuntime.CRLF);
                }
                msg = buffer.toString();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if ((level & internalLogLevel) == 0 && level != 0) return;
        JCoTraceWriter[] e = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                try {
                    writerList[i].trace(level, msg);
                    continue;
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            int standaloneTraceLevel = Trace.toExternalTraceLevel(level);
            JCoTraceListener[] jCoTraceListenerArray = listenerList;
            synchronized (listenerList) {
                for (int i = 0; i < listenerCount; ++i) {
                    try {
                        listenerList[i].trace(standaloneTraceLevel, msg);
                        continue;
                    }
                    catch (Throwable e3) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var4_8] (shouldn't be in output)
                return;
            }
        }
    }

    protected static void writeInfo(JCoTraceListener tl) {
        if (tl == null) {
            return;
        }
        tl.trace(8, "********************  " + new Date() + "   ***************************" + "         ");
        tl.trace(8, "SAP Java Connector (JCo) runtime information         ");
        tl.trace(8, "Java Runtime:");
        String os_version = System.getProperty("os.name") + " " + System.getProperty("os.version") + " for " + System.getProperty("os.arch");
        String java_version = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String java_codepage = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
        tl.trace(8, "\tOperating System     : " + os_version + "         ");
        tl.trace(8, "\tJava VM              : " + java_version + "         ");
        tl.trace(8, "\tJava Codepage        : " + java_codepage + "         ");
        tl.trace(8, "Versions:");
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        tl.trace(8, "\tJCo API               : " + rt.getVersion() + "         ");
        tl.trace(8, "\tJCo middleware name   : " + rt.getMiddlewarePropertyValue("jco.middleware.name") + "         ");
        tl.trace(8, "\tJCo middleware        : " + rt.getMiddlewarePropertyValue("jco.middleware.version") + "         ");
        tl.trace(8, "\tJCo middleware native : " + rt.getMiddlewarePropertyValue("jco.middleware.native_layer_version") + "         ");
        String lib_path = rt.getMiddlewarePropertyValue("jco.middleware.native_layer_path");
        tl.trace(8, "\tJCo library           : " + (lib_path == null ? "system defined" : lib_path) + "         ");
        tl.trace(8, "                                                                                                ");
        Properties rtProps = JCoRuntime.properties;
        StringBuilder sBuilder = new StringBuilder(512);
        sBuilder.append("********************    Configuration     ***************************").append(CRLF);
        for (Object key : rtProps.keySet()) {
            sBuilder.append("\t").append(key).append(" = ").append(rtProps.getProperty((String)key)).append(CRLF);
        }
        sBuilder.append(CRLF);
        tl.trace(8, sBuilder.toString());
        tl.trace(8, "*********************************************************************");
    }

    static {
        try {
            envTraceLevel = Integer.parseInt(System.getProperty("jco.trace_level", "0"));
        }
        catch (Exception e) {
            envTraceLevel = 0;
        }
    }
}

