/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRequestUnit;
import com.sap.conn.jco.JCoResponse;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbapRequestUnit;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.ClientConnectionState;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.PoolingFactory;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Dsr;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.Jarm;
import com.sap.jdsr.writer.DsrIPassport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class ClientConnection
extends AbstractConnection {
    public static final byte STATE_USED = 16;
    protected JCoMiddleware.Client middleware;
    private String authorizationTraceID = null;
    private boolean authorizationTracingEnabled = false;
    private long lastCheck = -1L;
    private static long checkInterval = 1800000L;
    static final DefaultListMetaData auth_trace_set = new DefaultListMetaData("AUTHTRACESET", 2);
    static final DefaultRecordMetaData auth_trace_status_rc = new DefaultRecordMetaData("AUTHTRACESTATUSRC", 1);
    static final DefaultListMetaData auth_trace_status = new DefaultListMetaData("AUTHTRACESTATUS", 1);
    static DefaultListMetaData susrUserChangePasswordRfcImports = new DefaultListMetaData("IMPORTS", 3);
    protected ClientFactory pool;
    Object semaphore = new Object();

    ClientConnection(Properties properties) {
        this.properties = properties;
        this.middleware = ClientConnection.getClientInterface();
    }

    protected ClientConnection(ClientConnectionState storedState) throws JCoException {
        if (storedState == null) {
            throw new NullPointerException("null passed as stored connection state");
        }
        this.middleware = ClientConnection.getClientInterface();
        this.restore(storedState);
    }

    protected ClientConnection(JCoDestination destination) {
        this(destination instanceof RfcDestination ? ((RfcDestination)destination).getAllProperties() : destination.getProperties());
    }

    protected static JCoMiddleware.Client getClientInterface() {
        try {
            return JCoRuntimeFactory.getRuntime().getMiddlewareInstance().getClientInterface();
        }
        catch (Exception ex) {
            Trace.fireTraceCritical("[JCoAPI] JCoClient(): could not get middleware interface");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void acquireBusyState(String currentAction) throws JCoException {
        Object object = this.semaphore;
        synchronized (object) {
            if ((this.state & 4) != 0) {
                long now = System.currentTimeMillis();
                Thread currentThread = Thread.currentThread();
                StringBuilder buf = new StringBuilder("Concurrent call in detected. Connection [");
                buf.append(this.getConnectionHandle()).append("] currently used in another thread:");
                buf.append(this.threadName).append(" [").append(this.threadId).append("] in ").append(this.threadAction);
                buf.append(" since ").append(now - this.start_time).append(" ms.");
                buf.append("Current thread:").append(currentThread.getName());
                buf.append(" [").append(currentThread.getId()).append("], action: ");
                buf.append(currentAction).append(".");
                throw new JCoException(132, "JCO_ERROR_CONCURRENT_CALL", buf.toString());
            }
            this.state = (byte)(this.state | 4);
        }
        this.start_time = System.currentTimeMillis();
        Thread currentThread = Thread.currentThread();
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
        this.threadAction = currentAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseBusyState() {
        Object object = this.semaphore;
        synchronized (object) {
            this.state = (byte)(this.state & 0xFFFFFFFB);
            this.last_active_timestamp = System.currentTimeMillis();
            if ((this.state & 8) != 0) {
                try {
                    this.disconnectInternal();
                }
                catch (JCoException e) {
                    if (Trace.isOn(4, true)) {
                        Trace.fireTrace(4, "[JCoAPI]  Exception during connection canceling", e);
                    }
                }
                finally {
                    this.state = (byte)(this.state & 0xFFFFFFF7);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() throws JCoException {
        Object object = this.semaphore;
        synchronized (object) {
            this.state = (byte)(this.state | 8);
            this.last_active_timestamp = System.currentTimeMillis();
            if ((this.state & 4) == 0) {
                this.disconnectInternal();
            } else {
                this.middleware.cancel(this);
            }
            if (Trace.isOn(64, true)) {
                Trace.fireTrace(64, "[JCoAPI] Cancel client with handle [" + this.getConnectionHandle() + "|" + this.getConversationID() + "]" + ((this.state & 4) == 0 ? " disconnect now" : "asynchronous cancelling"));
            }
        }
    }

    protected void beginCall() {
        int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
        try {
            block17: {
                ClientPassportManager pm = RuntimeEnvironment.getClientPassportManager();
                if (pm != null) {
                    try {
                        DsrIPassport passport = null;
                        passport = pm.callStarted(System.identityHashCode(this), this.attributes.getSystemID(), this.rfm_name);
                        ++this.callCounter;
                        if (passport != null) {
                            if (Trace.isOn(16)) {
                                Trace.fireTrace(16, "[JCoAPI] JCoClient.beginCall() for '" + this.rfm_name + "' - Root context ID: " + passport.getRootContextIdHex());
                            }
                            passport.setConnectionCounter(this.callCounter);
                            if (this.rfcHandle.rfc_uuid_set) {
                                passport.setConnectionIdBytes(this.rfcHandle.rfc_uuid);
                                if (Trace.isOn(16)) {
                                    Trace.fireTrace(32, "[JCoAPI] JCoClient.beginCall() for '" + this.rfm_name + "' - Connection ID set by JCo: " + Codecs.Hex.encode(this.rfcHandle.rfc_uuid));
                                    Trace.fireTrace(16, "[JCoAPI] JCoClient.beginCall() for '" + this.rfm_name + "' - Connection ID in passport: " + passport.getConnectionIdHex());
                                }
                            }
                        }
                        this.setDsrPassport(passport);
                    }
                    catch (Throwable th) {
                        if (Trace.isOn(4)) {
                            Trace.fireTrace(4, new FastStringBuffer().append("[JCoAPI] JCoClient.beginCall(): cannot get jDSR passport for call '").append(this.rfm_name).append("', because of ").append(th.toString()).toString());
                        }
                        if ((mode & 0x10) != 0) break block17;
                        if (th instanceof RuntimeException) {
                            throw (RuntimeException)th;
                        }
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw new RuntimeException(th);
                    }
                }
            }
            if ((mode & 1) != 0) {
                this.jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.JCoClient");
                if (this.jarm_monitor != null) {
                    this.jarm_monitor.startComponent("com.sap.conn.jco.JCoClient");
                }
            }
            if ((mode & 2) != 0) {
                if (this.dsr_monitor == null && this.passport_bytes != null) {
                    this.dsr_monitor = Dsr.createMonitor();
                }
                if (this.dsr_monitor != null && this.passport_bytes != null) {
                    this.dsr_monitor.openDsrRecord(this.getConnectionHandle(), 0, this.passport_bytes, this.start_time);
                }
            }
        }
        catch (RuntimeException ex) {
            PrintWriter pw = null;
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            Trace.fireTraceCritical(new StringBuffer("[JCoAPI] JCoClient.beginCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer()).toString());
            throw ex;
        }
    }

    protected void endCall() {
        int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
        try {
            block14: {
                block13: {
                    ClientPassportManager pm = RuntimeEnvironment.getClientPassportManager();
                    if (pm != null && this.passport_bytes != null) {
                        try {
                            pm.callFinished(System.identityHashCode(this), this.num_sent_bytes, this.num_received_bytes);
                        }
                        catch (Throwable th) {
                            if (Trace.isOn(4)) {
                                Trace.fireTrace(4, new FastStringBuffer().append("[JCoAPI] JCoClient.endCall(): exception within jDSR service: ").append(th.toString()).toString());
                            }
                            if ((mode & 0x10) != 0) break block13;
                            if (th instanceof RuntimeException) {
                                throw (RuntimeException)th;
                            }
                            if (th instanceof Error) {
                                throw (Error)th;
                            }
                            throw new RuntimeException(th);
                        }
                    }
                }
                if ((mode & 1) != 0 && this.jarm_monitor != null) {
                    try {
                        this.jarm_monitor.setUser(this.attributes != null ? this.attributes.getUser() : (String)null);
                        long sum = this.num_sent_bytes + this.num_received_bytes;
                        this.jarm_monitor.endComponent(sum);
                        this.jarm_monitor.endRequest(sum);
                        this.jarm_monitor = null;
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn(4)) break block14;
                        StringWriter sw = new StringWriter();
                        ex.printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        Trace.fireTrace(4, new FastStringBuffer().append("[JcoAPI] JCoClient.endCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer().toString()).toString());
                    }
                }
            }
            if ((mode & 2) != 0 && this.dsr_monitor != null && this.passport_bytes != null) {
                this.dsr_monitor.closeDsrRecord(this.getConnectionHandle(), 0, this.rfm_name, this.time_total, this.time_middleware, -1L, this.num_sent_bytes, this.num_received_bytes);
            }
        }
        catch (RuntimeException ex) {
            if (Trace.isOn(4)) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                sw.flush();
                Trace.fireTrace(4, new FastStringBuffer().append("[JcoAPI] JCoClient.endCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer().toString()).toString());
            }
            throw ex;
        }
    }

    public void setDsrPassport(DsrIPassport passport) throws Exception {
        this.passport_bytes = null;
        if (passport != null && passport.isValid()) {
            this.passport_bytes = passport.getNetPassport();
            if (Trace.isOn(16)) {
                String passportStr = Codecs.Hex.encode(this.passport_bytes);
                Trace.fireTrace(16, new FastStringBuffer().append("[JCoAPI] setDsrPassport for connection with handle ").append(this.getConnectionHandle()).append(" passport=[").append(passportStr).append("]").toString());
            }
        } else if (Trace.isOn(16)) {
            StringBuilder logText = new StringBuilder("[JCoAPI] setDsrPassport: ").append(passport == null ? "Dsr passport equals null." : "Dsr passport is not valid.");
            Trace.fireTrace(16, logText.toString());
        }
    }

    public ClientConnection clone() {
        ClientConnection client = (ClientConnection)super.clone();
        client.rfcHandle = null;
        client.state = 0;
        client.middleware = this.middleware.createCopy();
        client.attributes = this.attributes;
        return client;
    }

    final ClientConnection hide() {
        ClientConnection hidden = null;
        hidden = (ClientConnection)super.hideConnection();
        hidden.middleware = this.middleware.createCopy();
        this.state = (byte)(this.state & 0xFFFFFFFD);
        hidden.attributes = this.attributes;
        return hidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws JCoException {
        this.acquireBusyState("reset");
        try {
            this.internalReset();
        }
        finally {
            this.releaseBusyState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalReset() throws JCoException {
        if (this.isAlive()) {
            JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
            boolean isTaskMonitorOn = runtime.isTaskMonitorOn();
            if (isTaskMonitorOn) {
                StringBuilder monitorText = new StringBuilder();
                monitorText.append("JCo resetting context [").append(this.attributes.sysid).append('|').append(this.attributes.getPartnerHost()).append('|').append(this.getConversationID()).append(']');
                runtime.startTask(monitorText.toString());
            }
            try {
                this.middleware.reset(this);
            }
            finally {
                if (isTaskMonitorOn) {
                    runtime.endTask();
                }
            }
        }
    }

    public final String[][] getPropertyInfo() {
        return this.middleware.getPropertyInfo();
    }

    public byte getState() {
        return super.getState();
    }

    public final ConnectionAttributes getAttributes() throws JCoException {
        this.last_active_timestamp = System.currentTimeMillis();
        if (this.attributes.isInitial()) {
            if (!this.isValid()) {
                throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            throw new JCoException(108, "JCO_ERROR_INTERNAL", "empty attributes on a valid/alive handle");
        }
        return this.attributes;
    }

    public String getHashKey(boolean personalized) {
        String value;
        FastStringBuffer sb = new FastStringBuffer();
        if (personalized) {
            value = RfcDestination.getProperty(this.properties, "jco.client.user");
            sb.append(value != null ? value : "");
            sb.append('|');
        }
        value = RfcDestination.getProperty(this.properties, "jco.client.client", "");
        sb.append('|');
        value = RfcDestination.getProperty(this.properties, "jco.client.lang", "");
        sb.append('|');
        if (RfcDestination.getProperty(this.properties, "jco.client.ashost") != null) {
            sb.append("AS=[");
            value = RfcDestination.getProperty(this.properties, "jco.client.ashost", "");
            sb.append('|');
            value = RfcDestination.getProperty(this.properties, "jco.client.sysnr", "");
            sb.append("]");
        } else if (RfcDestination.getProperty(this.properties, "jco.client.mshost") != null) {
            sb.append("MS=[");
            value = RfcDestination.getProperty(this.properties, "jco.client.r3name", "");
            sb.append('|');
            value = RfcDestination.getProperty(this.properties, "jco.client.mshost", "");
            sb.append('|');
            value = RfcDestination.getProperty(this.properties, "jco.client.group", "");
            sb.append("]");
        }
        if (RfcDestination.getProperty(this.properties, "jco.client.gwhost") != null) {
            sb.append("GW=[");
            value = RfcDestination.getProperty(this.properties, "jco.client.gwhost", "");
            sb.append('|');
            value = RfcDestination.getProperty(this.properties, "jco.client.gwserv", "");
            sb.append('|');
            value = RfcDestination.getProperty(this.properties, "jco.client.tpname", "");
            sb.append("]");
        }
        if ((value = RfcDestination.getProperty(this.properties, "jco.client.use_sapgui")) != null) {
            sb.append('G');
            sb.append(value);
            sb.append('|');
        }
        if ((value = RfcDestination.getProperty(this.properties, "jco.client.abap_debug")) != null) {
            sb.append('D');
            sb.append(value);
            sb.append('|');
        }
        return sb.toString();
    }

    public boolean isAlive() {
        return this.middleware.isAlive(this);
    }

    public void connect() throws JCoException {
        if (this.isValid()) {
            return;
        }
        this.acquireBusyState("connect");
        try {
            this.middleware.connect(this);
        }
        catch (JCoException ex) {
            if (Trace.isOn(4, true)) {
                Properties p = (Properties)this.properties.clone();
                Trace.fireTrace(4, "[JCoAPI] JCoClient.connect {" + Trace.bufferForConnectionProperties(p) + "} failed with " + ex.toString());
            }
            throw ex;
        }
        finally {
            this.releaseBusyState();
        }
        this.state = (byte)(this.state & 0xFFFFFFF0 | 2);
        if (Trace.isOn(128, true)) {
            Trace.fireTrace(128, "[JCoAPI] JCoClient.connect success with handle [" + this.getConnectionHandle() + "]");
        }
    }

    public void disconnect() throws JCoException {
        this.disconnect(false);
    }

    public void setStateful(boolean stateful) {
        this.rfcHandle.setStateful(stateful);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(boolean is_pooled) throws JCoException {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoAPI] JCoClient.disconnect on handle [" + this.getConnectionHandle() + "]");
        }
        this.authorizationTraceID = null;
        this.callCounter = 0;
        if (!is_pooled && this.pool != null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "A client allocated from pool " + this.pool.getName() + " cannot be disconnected directly." + JCoRuntime.CRLF + "Use JCo.releaseClient(JCoClient) instead.");
        }
        this.acquireBusyState("disconnect");
        try {
            this.disconnectInternal();
        }
        finally {
            this.releaseBusyState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectInternal() throws JCoException {
        try {
            if (this.isValid()) {
                this.middleware.disconnect(this);
            }
        }
        finally {
            this.state = (byte)(this.state & 0xFFFFFFFD);
        }
    }

    protected void free() throws JCoException {
        this.middleware.free(this);
        this.middleware = null;
        if (this.pool != null) {
            this.pool.releaseClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String message) throws JCoException {
        this.acquireBusyState("abort");
        this.callCounter = 0;
        try {
            if (this.isValid()) {
                this.middleware.abort(this, message);
            }
        }
        finally {
            this.releaseBusyState();
            this.state = (byte)(this.state & 0xFFFFFFFD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTID() throws JCoException {
        String tid = null;
        this.acquireBusyState("createTID");
        try {
            tid = this.middleware.createTID(this);
        }
        finally {
            this.releaseBusyState();
        }
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmUnitID(JCoUnitIdentifier unitIdentifier) throws JCoException {
        this.acquireBusyState("confirmUnitID");
        try {
            this.middleware.confirmUnitID(this, unitIdentifier);
        }
        finally {
            this.releaseBusyState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmTID(String tid) throws JCoException {
        this.acquireBusyState("confirmTID");
        try {
            this.middleware.confirmTID(this, tid);
        }
        finally {
            this.releaseBusyState();
        }
    }

    public void ping() throws JCoException {
        this.execute("RFC_PING", null, null, null, null, false, AbapClassException.Mode.OFF);
    }

    public void execute(JCoFunction function, JCoRepository repository) throws JCoException {
        this.execute(function, null, null, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JCoFunction function, String tid, String queue, JCoRepository repository) throws JCoException {
        if (function == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "function is null");
        }
        JCoMiddleware.CallContext ctx = this.middleware.getCallContext(this);
        try {
            ctx.repository = repository;
            if (tid != null) {
                ctx.startQRfc(tid, queue);
            }
            this.execute(function.getName(), (DefaultParameterList)function.getImportParameterList(), (DefaultParameterList)function.getTableParameterList(), (DefaultParameterList)function.getChangingParameterList(), (DefaultParameterList)function.getExportParameterList(), ((AbapFunction)function).supportsASXML(), ((AbapFunction)function).getAbapClassExceptionMode());
        }
        finally {
            ctx.reset(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(AbapFunctionUnit unit, JCoRepository repository) throws JCoException {
        if (!this.isAlive()) {
            throw new JCoException(133, "JCO_ERROR_INVALID_HANDLE", "Connection is not valid");
        }
        JCoMiddleware.CallContext ctx = this.middleware.getCallContext(this);
        try {
            ctx.repository = repository;
            ctx.startBgRfcUnit(unit);
            for (JCoFunction function : unit.functionList) {
                this.execute(function.getName(), (DefaultParameterList)function.getImportParameterList(), (DefaultParameterList)function.getTableParameterList(), (DefaultParameterList)function.getChangingParameterList(), (DefaultParameterList)function.getExportParameterList(), ((AbapFunction)function).supportsASXML(), ((AbapFunction)function).getAbapClassExceptionMode());
            }
            ctx.commit();
        }
        finally {
            ctx.reset(this);
        }
    }

    public JCoResponse execute(JCoRequest request, String tid, String queue, JCoRepository repository) throws JCoException {
        if (request == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "request is null");
        }
        try {
            this.execute(((DefaultRequest)request).function, tid, queue, repository);
            return ((DefaultRequest)request).getResponse();
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unexpected type detected " + request.getClass().getName());
        }
    }

    protected void execute(JCoRequestUnit unit, JCoRepository repository) throws JCoException {
        try {
            AbapRequestUnit aru = (AbapRequestUnit)unit;
            this.execute(aru.toAbapFunctionUnit(), repository);
        }
        catch (ClassCastException cce) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only instances created by the JCo runtime are allowed. The passed instance has type " + unit.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(String functionName, DefaultParameterList input, DefaultParameterList inputTables, DefaultParameterList changing, DefaultParameterList output, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws JCoException {
        JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
        if (!this.isValid()) {
            this.connect();
        }
        this.acquireBusyState("execute");
        boolean isTaskMonitorOn = runtime.isTaskMonitorOn();
        try {
            block41: {
                int i6222;
                this.rfm_name = functionName;
                if ((runtime.getInternalMode() & 7) != 0) {
                    this.beginCall();
                }
                if (isTaskMonitorOn) {
                    StringBuilder monitorText = new StringBuilder();
                    monitorText.append("JCo executing ").append(functionName).append(" [").append(this.attributes.sysid).append('|').append(this.attributes.getPartnerHost()).append('|').append(this.getConversationID()).append(']');
                    runtime.startTask(monitorText.toString());
                }
                if (input != null) {
                    input.checkIfInitialized();
                    for (int i2 = 0; i2 < input.getMetaData().getFieldCount(); ++i2) {
                        if (input.isActive(i2) && input.isInitialized(i2)) continue;
                        int n = i2;
                        input.flags[n] = (byte)(input.flags[n] | 8);
                    }
                }
                if (inputTables != null) {
                    for (int i3 = 0; i3 < inputTables.getMetaData().getFieldCount(); ++i3) {
                        if (inputTables.isActive(i3)) continue;
                        int n = i3;
                        inputTables.flags[n] = (byte)(inputTables.flags[n] | 8);
                    }
                }
                if (changing != null) {
                    changing.checkIfInitialized();
                    for (int i4 = 0; i4 < changing.getMetaData().getFieldCount(); ++i4) {
                        if (changing.isActive(i4)) continue;
                        int n = i4;
                        changing.flags[n] = (byte)(changing.flags[n] | 8);
                    }
                }
                if (output != null) {
                    for (int i5 = 0; i5 < output.getMetaData().getFieldCount(); ++i5) {
                        if (output.isActive(i5)) continue;
                        int n = i5;
                        output.flags[n] = (byte)(output.flags[n] | 8);
                    }
                }
                try {
                    try {
                        StringBuilder buf;
                        if (Trace.isOn(128)) {
                            buf = new StringBuilder(120).append("[JCoAPI] JCoClient before execute (").append(functionName).append(") on handle [").append(this.getConnectionHandle()).append("]");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, Trace.isOn(256), true, false, functionName, input, changing, output, inputTables, inputTables, supportsASXML);
                            }
                            Trace.fireTrace(128, buf.toString());
                        }
                        this.middleware.execute(this, functionName, input, inputTables, changing, output, supportsASXML, classExceptionMode);
                        if (Trace.isOn(128)) {
                            buf = new StringBuilder(200).append("[JCoAPI] JCoClient after execute (").append(functionName);
                            buf.append(") on handle [").append(this.getConnectionHandle()).append("] returns after ");
                            buf.append(System.currentTimeMillis() - this.start_time).append(" ms");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, false, false, true, functionName, input, changing, output, inputTables, inputTables, supportsASXML);
                            }
                            Trace.fireTrace(128, buf.toString());
                        }
                    }
                    catch (AbapException ex) {
                        if (!Trace.isOn(8)) throw ex;
                        Trace.fireTrace(8, new FastStringBuffer(120).append("[JCoAPI] JCoClient.execute (").append(functionName).append(") threw an ABAP exception: ").append(ex.toString()).toString());
                        throw ex;
                    }
                    catch (JCoException ex) {
                        if (Trace.isOn(4)) {
                            Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] JCoClient.execute (").append(functionName).append(") threw a NON-ABAP exception: ").append(ex.toString()).toString());
                        }
                        this.state = (byte)(this.state & 0xFFFFFFFD);
                        this.middleware.disconnect(this);
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (Trace.isOn(4)) {
                            Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] JCoClient.execute (").append(functionName).append(") threw a NON-ABAP exception: ").append(ex.toString()).toString());
                        }
                        this.state = (byte)(this.state & 0xFFFFFFFD);
                        this.middleware.disconnect(this);
                        throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                    }
                    Object var12_18 = null;
                    if (input == null) break block41;
                    i6222 = 0;
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    if (input != null) {
                        int i6222 = 0;
                        while (i6222 < input.getMetaData().getFieldCount()) {
                            int n = i6222++;
                            input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (inputTables != null) {
                        int i22 = 0;
                        while (i22 < inputTables.getMetaData().getFieldCount()) {
                            int n = i22++;
                            inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (changing != null) {
                        int i2 = 0;
                        while (i2 < changing.getMetaData().getFieldCount()) {
                            int n = i2++;
                            changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (output == null) throw throwable;
                    int i = 0;
                    while (i < output.getMetaData().getFieldCount()) {
                        int n = i++;
                        output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                    }
                    throw throwable;
                }
                while (i6222 < input.getMetaData().getFieldCount()) {
                    int n = i6222++;
                    input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                }
            }
            if (inputTables != null) {
                int i22 = 0;
                while (i22 < inputTables.getMetaData().getFieldCount()) {
                    int n = i22++;
                    inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (changing != null) {
                int i2 = 0;
                while (i2 < changing.getMetaData().getFieldCount()) {
                    int n = i2++;
                    changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                }
            }
            if (output != null) {
                int i = 0;
                while (i < output.getMetaData().getFieldCount()) {
                    int n = i++;
                    output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                }
            }
            Object var15_23 = null;
            this.releaseBusyState();
            if (isTaskMonitorOn) {
                runtime.endTask();
            }
            if ((runtime.getInternalMode() & 7) == 0) return;
            this.endCall();
            return;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            this.releaseBusyState();
            if (isTaskMonitorOn) {
                runtime.endTask();
            }
            if ((runtime.getInternalMode() & 7) == 0) throw throwable;
            this.endCall();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restore(ClientConnectionState aState) throws JCoException {
        this.acquireBusyState("restore");
        try {
            super.restore(aState);
            this.authorizationTraceID = aState.getAuthorizationTraceID();
            this.middleware.restoreConnection(this, aState.getMwConnectionState());
            Object var3_2 = null;
            this.releaseBusyState();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseBusyState();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnectionState store(ClientConnectionState aState) throws JCoException {
        this.acquireBusyState("store");
        try {
            super.store(aState);
            aState.setAuthorizationTraceID(this.authorizationTraceID);
            aState.setMwConnectionState(this.middleware.getConnectionState(this));
            ClientConnectionState clientConnectionState = aState;
            Object var4_3 = null;
            this.releaseBusyState();
            return clientConnectionState;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseBusyState();
            throw throwable;
        }
    }

    public void startAuthorizationTracing(String traceID, String serviceType) throws JCoException {
        block10: {
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, new FastStringBuffer(120).append("[JCoAPI] startAuthorizationTracing (").append(traceID).append(", ").append(serviceType).append(") for client with handle ").append(this.getConnectionHandle()).append(" auth trace is ").append(this.isAuthorizationTracingEnabled() ? "enabled " : "disabled ").append("  [enter]").toString());
            }
            if (!this.isAuthorizationTracingEnabled()) {
                return;
            }
            if (!this.isValid()) {
                throw new JCoException(102, "JCO_ERROR_COMMUNICATION", "JCoClient not connected, which is required for enabling authorization tracing");
            }
            try {
                if (this.attributes.isInitial()) {
                    this.getAttributes();
                }
                if (this.attributes.getPartnerReleaseNumber() >= 620) {
                    DefaultParameterList imports = new DefaultParameterList(auth_trace_set);
                    imports.setValue(0, serviceType);
                    imports.setValue(0, traceID);
                    this.execute("AUTH_TRACE_SET_SERVICE", imports, null, null, null, false, AbapClassException.Mode.OFF);
                    this.authorizationTraceID = traceID;
                }
            }
            catch (AbapException jae) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] startAuthorizationTracing (").append(traceID).append(", ").append(serviceType).append(") for client with handle ").append(this.getConnectionHandle()).append("  failed in backend: ").append(jae.getMessage()).toString());
                }
            }
            catch (Exception ex) {
                if (!Trace.isOn(4)) break block10;
                Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] startAuthorizationTracing (").append(traceID).append(", ").append(serviceType).append(") for client with handle ").append(this.getConnectionHandle()).append("  failed: ").append(ex.getMessage()).toString());
            }
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new FastStringBuffer(120).append("[JCoAPI] startAuthorizationTracing for client with handle ").append(this.getConnectionHandle()).append("  [leave]").toString());
        }
    }

    public boolean isAuthorizationTracingEnabled() throws JCoException {
        boolean ret = false;
        ClientConnection masterClient = null;
        if (this.pool instanceof PoolingFactory) {
            masterClient = ((PoolingFactory)this.pool).master;
        }
        if (JCoRuntime.authorizationTracingEnabled) {
            block18: {
                if (Trace.isOn(128)) {
                    Trace.fireTrace(128, new FastStringBuffer(200).append("[JCoAPI] isAuthorizationTracingEnabled for client with handle ").append(this.getConnectionHandle()).append("  [enter]").toString());
                }
                boolean check = false;
                long now = System.currentTimeMillis();
                if (masterClient != null) {
                    boolean bl = check = now - masterClient.lastCheck > checkInterval;
                    if (!check) {
                        ret = masterClient.authorizationTracingEnabled;
                    }
                } else {
                    boolean bl = check = now - this.lastCheck > checkInterval;
                    if (!check) {
                        ret = this.authorizationTracingEnabled;
                    }
                }
                if (check) {
                    if (!this.isValid()) {
                        throw new JCoException(102, "JCO_ERROR_COMMUNICATION", "Client not connected, which is required for setting authorization tracing");
                    }
                    try {
                        if (this.attributes.isInitial()) {
                            this.getAttributes();
                        }
                        if (this.attributes.getPartnerReleaseNumber() >= 620) {
                            DefaultParameterList exports = new DefaultParameterList(auth_trace_status);
                            this.execute("AUTH_TRACE_GET_STATUS", null, null, null, exports, false, AbapClassException.Mode.OFF);
                            DefaultStructure rc = exports.getStructure(0);
                            ret = "X".equals(rc.getString(0));
                            if (masterClient != null) {
                                masterClient.lastCheck = now;
                                masterClient.authorizationTracingEnabled = ret;
                            }
                            this.lastCheck = now;
                            this.authorizationTracingEnabled = ret;
                        } else {
                            if (masterClient != null) {
                                masterClient.lastCheck = Long.MAX_VALUE;
                                masterClient.authorizationTracingEnabled = false;
                            }
                            this.lastCheck = Long.MAX_VALUE;
                            this.authorizationTracingEnabled = false;
                        }
                    }
                    catch (Exception ex) {
                        if (masterClient != null) {
                            masterClient.lastCheck = now;
                            masterClient.authorizationTracingEnabled = false;
                        }
                        this.lastCheck = now;
                        this.authorizationTracingEnabled = false;
                        if (!Trace.isOn(4)) break block18;
                        Trace.fireTrace(4, new FastStringBuffer(200).append("[JCoAPI] isAuthorizationTracingEnabled for client with handle ").append(this.getConnectionHandle()).append("  failed: ").append(ex.getMessage()).toString());
                    }
                }
            }
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, new FastStringBuffer(200).append("[JCoAPI] isAuthorizationTracingEnabled for client with handle ").append(this.getConnectionHandle()).append("  [leave]").toString());
            }
        }
        return ret;
    }

    public String getAuthorizationTraceID() {
        return this.authorizationTraceID;
    }

    public void endAuthorizationTracing() {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new FastStringBuffer(120).append("[JCoAPI] endAuthorizationTracing() for client with handle ").append(this.getConnectionHandle()).append(" authorizationTraceID =").append(this.authorizationTraceID == null ? " null " : this.authorizationTraceID).append("  [enter]").toString());
        }
        if (this.authorizationTraceID != null) {
            block8: {
                this.authorizationTraceID = null;
                if (this.isValid()) {
                    try {
                        if (this.attributes.isInitial()) {
                            this.getAttributes();
                        }
                        if (this.attributes.getPartnerReleaseNumber() >= 620) {
                            this.execute("AUTH_TRACE_RESET", null, null, null, null, false, AbapClassException.Mode.OFF);
                        }
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn(4)) break block8;
                        Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] endAuthorizationTracing() for client with handle ").append(this.getConnectionHandle()).append("  failed with ").append(ex.toString()).toString());
                    }
                }
            }
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, new FastStringBuffer(120).append("[JCoAPI] endAuthorizationTracing() for client with handle ").append(this.getConnectionHandle()).append("  [leave]").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBackendPassword(String userName, String oldPassword, String newPassword) throws JCoException {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new StringBuilder(120).append("[JCoAPI] changeBackendPassword(").append(userName).append(") for client with handle ").append(this.getConnectionHandle()).append("  [enter]").toString());
        }
        if (this.isValid()) {
            if (this.attributes.isInitial()) {
                this.getAttributes();
            }
            if (this.attributes.getPartnerReleaseNumber() >= 462) {
                DefaultParameterList passwordChangeImports = new DefaultParameterList(susrUserChangePasswordRfcImports);
                passwordChangeImports.setValue(0, userName);
                passwordChangeImports.setValue(1, newPassword);
                passwordChangeImports.setValue(2, oldPassword);
                try {
                    this.rfcHandle.setScrambleParamters(true);
                    this.execute("SUSR_USER_CHANGE_PASSWORD_RFC", passwordChangeImports, null, null, null, false, AbapClassException.Mode.OFF);
                    Object var6_5 = null;
                    this.rfcHandle.setScrambleParamters(false);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.rfcHandle.setScrambleParamters(false);
                    throw throwable;
                }
            } else {
                throw new JCoException(136, "Password change not possible --> Backend is too old");
            }
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new StringBuilder(120).append("[JCoAPI] changeBackendPassword(").append(userName).append(") for client with handle ").append(this.getConnectionHandle()).append("  [leave]").toString());
        }
    }

    MonitoredConnectionData getMonitoredData() {
        MonitoredConnectionData md = super.getMonitoredData();
        md.application = JCoRuntime.findProperty("jco.client.application", this.properties);
        if (md.application == null) {
            md.application = "";
        }
        md.connType = "CLIENT (conn)";
        md.group = this.pool != null ? this.pool.destinationId : "";
        return md;
    }

    protected String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    static {
        auth_trace_set.add("SERVICE_TYPE", 0, 16, 32, 2);
        auth_trace_set.add("SERVICE", 29, 0, 0, 2);
        auth_trace_set.lock();
        auth_trace_status_rc.add("BOOLE", 0, 1, 0, 2, 0);
        auth_trace_status_rc.setRecordLength(1, 2);
        auth_trace_status_rc.lock();
        auth_trace_status.add("RC", 17, auth_trace_status_rc, 4);
        auth_trace_status.lock();
        susrUserChangePasswordRfcImports.add("BNAME", 0, 12, 24, 3);
        susrUserChangePasswordRfcImports.add("NEW_PASSWORD", 0, 40, 80, 3);
        susrUserChangePasswordRfcImports.add("PASSWORD", 0, 40, 80, 2);
        susrUserChangePasswordRfcImports.lock();
    }
}

