/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.BasicFileAM;
import com.helpsystems.common.server.file.BasicFileHandle;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.server.file.RemoteFileAM;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WindowsFileAM
extends BasicFileAM
implements RemoteFileAM {
    private static final Logger logger = Logger.getLogger(WindowsFileAM.class);

    @Override
    public RemoteFile get(UserIdentity userIdentity, String string) throws ActionFailedException {
        String string2 = this.resolvePathToUse(string);
        return this.cleanRemoteFileShortcut(super.get(userIdentity, string2), true);
    }

    @Override
    public RemoteFile get(UserIdentity userIdentity, String string, boolean bl) throws ActionFailedException {
        String string2 = this.resolvePathToUse(string);
        return this.cleanRemoteFileShortcut(super.get(userIdentity, string2, bl), bl);
    }

    private String resolvePathToUse(String string) {
        String string2 = string;
        File file = new File(string);
        if (!file.exists() && (file = new File(string + ".lnk")).exists()) {
            string2 = string + ".lnk";
        }
        return string2;
    }

    @Override
    public synchronized RemoteFile[] getFiles(UserIdentity userIdentity, RemoteFile remoteFile) throws ActionFailedException {
        RemoteFile[] remoteFileArray;
        if (remoteFile.isShortcut()) {
            remoteFileArray = this.findShortcutTarget(remoteFile.getAbsolutePath() + ".lnk");
            remoteFile.setAbsolutePath((String)remoteFileArray);
        }
        remoteFileArray = super.getFiles(userIdentity, remoteFile);
        for (int i = 0; i < remoteFileArray.length; ++i) {
            this.cleanRemoteFileShortcut(remoteFileArray[i], true);
        }
        return remoteFileArray;
    }

    @Override
    public FileHandle getHandle(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"Path", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Mode", (String)string2);
        String string3 = string;
        File file = new File(string);
        if (file.exists()) {
            string3 = this.findShortcutTarget(string);
        } else {
            file = new File(string + ".lnk");
            if (file.exists()) {
                string3 = this.findShortcutTarget(file.getAbsolutePath());
            }
        }
        try {
            return new BasicFileHandle(string3, string2);
        }
        catch (IOException iOException) {
            throw new ActionFailedException("Unable to open file " + string, (Throwable)iOException);
        }
    }

    private String findShortcutTarget(String string) {
        if (string == null) {
            return string;
        }
        if (!string.toLowerCase().endsWith(".lnk")) {
            return string;
        }
        String string2 = WindowsFileAM.readShortcutTarget(string);
        return string2;
    }

    private RemoteFile cleanRemoteFileShortcut(RemoteFile remoteFile, boolean bl) {
        String string;
        if (remoteFile == null || !remoteFile.isFile() || remoteFile.isShortcut()) {
            return remoteFile;
        }
        String string2 = remoteFile.getAbsolutePath();
        if (Equal.isEqual((Object)string2, (Object)(string = this.findShortcutTarget(string2)))) {
            return remoteFile;
        }
        remoteFile.setAbsolutePath(string2.substring(0, string2.length() - 4));
        RemoteFile remoteFile2 = new RemoteFile(new File(string), bl);
        remoteFile.setType(remoteFile2.getType() | 0x800);
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readShortcutTarget(String string) {
        String string2;
        boolean bl;
        int n;
        byte[] byArray;
        FileInputStream fileInputStream;
        block13: {
            boolean bl2;
            int n2;
            block12: {
                fileInputStream = null;
                fileInputStream = new FileInputStream(string);
                byArray = new byte[10000];
                for (n = 0; n < byArray.length && (n2 = fileInputStream.read(byArray, n, byArray.length - n)) >= 1; n += n2) {
                }
                if (byArray[0] == 76 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) break block12;
                String string3 = string;
                WindowsFileAM.close((Closeable)fileInputStream);
                return string3;
            }
            n2 = WindowsFileAM.unsignedByte(byArray[20]);
            bl = (n2 & 1) > 0;
            boolean bl3 = bl2 = (n2 & 2) > 0;
            if (bl2) break block13;
            String string4 = string;
            WindowsFileAM.close((Closeable)fileInputStream);
            return string4;
        }
        try {
            int n3;
            int n4;
            n = 76;
            if (bl) {
                n4 = (WindowsFileAM.unsignedByte(byArray[n + 1]) << 8) + WindowsFileAM.unsignedByte(byArray[n]);
                n += n4;
            }
            n4 = WindowsFileAM.readDWord(byArray, n);
            int n5 = WindowsFileAM.readDWord(byArray, n + 16);
            int n6 = WindowsFileAM.readDWord(byArray, n + 24);
            String string5 = null;
            if (n5 > 0) {
                n3 = n + n5 + 2;
                int n7 = n + n4;
                string5 = new String(byArray, n3, n7 - n3);
            } else if (n6 > 0) {
                n3 = n + n6 - 1;
                int n8 = n + n4;
                for (int i = n3; i < n8; ++i) {
                    if (byArray[i] != 0) continue;
                    byArray[i] = 92;
                    break;
                }
                string5 = new String(byArray, n3, n8 - n3 + 1);
            }
            string2 = string5;
        }
        catch (Exception exception) {
            String string6;
            try {
                logger.debug((Object)("Unable to read shortcut " + string), (Throwable)exception);
                string6 = string;
            }
            catch (Throwable throwable) {
                WindowsFileAM.close(fileInputStream);
                throw throwable;
            }
            WindowsFileAM.close((Closeable)fileInputStream);
            return string6;
        }
        WindowsFileAM.close((Closeable)fileInputStream);
        return string2;
    }

    private static int unsignedByte(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static int readDWord(byte[] byArray, int n) {
        int n2 = (WindowsFileAM.unsignedByte(byArray[n + 1]) << 24) + (WindowsFileAM.unsignedByte(byArray[n]) << 16) + (WindowsFileAM.unsignedByte(byArray[n + 3]) << 8) + WindowsFileAM.unsignedByte(byArray[n + 2]);
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Gimme a file name");
        } else {
            System.out.println(WindowsFileAM.readShortcutTarget(stringArray[0]));
        }
    }
}

