/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.util.StreamCopier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.BasicFileHandle;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.server.file.FileHandleOutputStream;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.server.file.RemoteFileAM;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class BasicFileAM
extends AbstractManager
implements RemoteFileAM {
    @Override
    public RemoteFile getDefaultDirectory() {
        return new RemoteFile(new File(System.getProperty("user.dir")));
    }

    @Override
    public RemoteFile get(UserIdentity userIdentity, String string) throws ActionFailedException {
        return this.get(userIdentity, string, true);
    }

    @Override
    public RemoteFile get(UserIdentity userIdentity, String string, boolean bl) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        File file = new File(string);
        return new RemoteFile(file, bl);
    }

    @Override
    public synchronized RemoteFile[] getFiles(UserIdentity userIdentity, RemoteFile remoteFile) throws ActionFailedException {
        return this.getFiles(userIdentity, remoteFile, true);
    }

    @Override
    public synchronized RemoteFile[] getFiles(UserIdentity userIdentity, RemoteFile remoteFile, boolean bl) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Dir", (Object)((Object)remoteFile));
        String string = remoteFile.getAbsolutePath();
        File file = new File(string);
        if (!file.exists()) {
            throw new ActionFailedException("The path " + string + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new ActionFailedException("The path " + string + " is not a directory.");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new ActionFailedException("Unable to list files for " + string);
        }
        RemoteFile[] remoteFileArray = new RemoteFile[fileArray.length];
        for (int i = 0; i < remoteFileArray.length; ++i) {
            remoteFileArray[i] = new RemoteFile(fileArray[i], bl);
        }
        fileArray = null;
        return remoteFileArray;
    }

    @Override
    public RemoteFile[] getRoots() {
        return this.getRoots(true);
    }

    @Override
    public RemoteFile[] getRoots(boolean bl) {
        File[] fileArray = File.listRoots();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(new RemoteFile(fileArray[i], bl));
        }
        RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
        arrayList.toArray(remoteFileArray);
        arrayList.clear();
        return remoteFileArray;
    }

    @Override
    public void delete(UserIdentity userIdentity, String string) throws ActionFailedException {
        boolean bl;
        ValidationHelper.checkForNullAndBlank((String)"Path", (String)string);
        File file = new File(string);
        if (file.exists() && !(bl = file.delete())) {
            throw new ActionFailedException("Unable to delete file " + string);
        }
    }

    @Override
    public boolean exists(UserIdentity userIdentity, String string) throws ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"Path", (String)string);
        File file = new File(string);
        return file.exists();
    }

    @Override
    public FileHandle getHandle(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"Path", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Mode", (String)string2);
        try {
            return new BasicFileHandle(string, string2);
        }
        catch (IOException iOException) {
            throw new ActionFailedException("Unable to open file " + string, (Throwable)iOException);
        }
    }

    @Override
    public void rename(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"Existing filename", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"New filename", (String)string2);
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = file.renameTo(file2);
        if (!bl) {
            throw new ActionFailedException("Unable to rename file " + string);
        }
    }

    @Override
    public void copy(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"Existing filename", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"New filename", (String)string2);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            StreamCopier.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream, (int)50000, (boolean)true);
        }
        catch (IOException iOException) {
            try {
                throw new ActionFailedException("Unable to copy file " + string, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                BasicFileAM.close(fileOutputStream);
                BasicFileAM.close((Closeable)fileInputStream);
                fileInputStream = null;
                fileOutputStream = null;
                throw throwable;
            }
        }
        BasicFileAM.close((Closeable)fileOutputStream);
        BasicFileAM.close((Closeable)fileInputStream);
        fileInputStream = null;
        fileOutputStream = null;
    }

    @Override
    public FileHandleOutputStream execute(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        throw new ActionFailedException("Not implemented");
    }

    @Override
    public String getDefaultEncoding() {
        return Charset.defaultCharset().name();
    }

    @Override
    public int getFileSystemType() {
        return 0;
    }

    @Override
    public String md5sum(UserIdentity userIdentity, String string) throws ActionFailedException {
        try {
            return MD5.hashFile((String)string);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to calculate MD5sum for " + string, (Throwable)exception);
        }
    }

    @Override
    public void mkdir(UserIdentity userIdentity, String string) throws ActionFailedException {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw new ActionFailedException("Unable to create directory " + file.getAbsolutePath() + ", a file exists with the same name.");
        }
        boolean bl = false;
        try {
            bl = file.mkdirs();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to create directory " + file.getAbsolutePath(), (Throwable)exception);
        }
        if (!bl) {
            throw new ActionFailedException("Unable to create the directory " + file.getAbsolutePath());
        }
    }
}

