/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.HSAction;
import com.helpsystems.common.client.components.HSJFrame;
import com.helpsystems.common.client.components.throwabledialog.ThrowableDialog;
import com.helpsystems.common.client.lnf.HSFontTheme;
import com.helpsystems.common.client.lnf.LookAndFeelAdjustments;
import com.helpsystems.common.client.util.GuiLogging;
import com.helpsystems.common.client.util.HSHelpBroker;
import com.helpsystems.common.client.util.HSSwingWorker;
import com.helpsystems.common.client.util.ImageHandling;
import com.helpsystems.common.client.util.SwingWorkerTarget;
import com.helpsystems.common.client.util.WindowSizing;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.HelpInfo;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.dm.RemoteEventAM;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.enterprise.RBEHelpManager;
import com.helpsystems.enterprise.module.windows.Advapi32;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.MulticastHandler;
import com.helpsystems.enterprise.peer.MulticastMessage;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentProcessListener;
import com.helpsystems.enterprise.service.AgentProcessListenerAdapter;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.service.AgentServiceEntryComparator;
import com.helpsystems.enterprise.tray.AgentServiceEntrySource;
import com.helpsystems.enterprise.tray.AgentServiceEntryWrapper;
import com.helpsystems.enterprise.tray.AgentTrayIcon;
import com.helpsystems.enterprise.tray.ServiceFrame;
import com.incors.plaf.alloy.AlloyFontTheme;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import com.incors.plaf.alloy.AlloyTheme;
import com.incors.plaf.alloy.DefaultAlloyTheme;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SystemTrayControl {
    private static final int MAX_AGENTS_IN_MENU = 20;
    private static final Logger logger = Logger.getLogger(SystemTrayControl.class);
    public static final int COMMAND_OK = 0;
    public static final int COMMAND_FAILED = 1;
    public static final int NO_FILENAME_SPECIFIED = 101;
    public static final int UNABLE_TO_LOAD_CONFIG = 102;
    public static final int COMMAND_NOT_SUCCESSFUL = 103;
    public static final int NEED_MORE_ARGS = 104;
    public static final int UNABLE_TO_CONNECT = 105;
    public static final int INVALID_SERVER_ARG = 106;
    public static final int PORT_IN_USE = 107;
    public static final String _COMMAND_OK = "Agent ended normally";
    public static final String _COMMAND_FAILED = "Agent process was ended abnormally";
    public static final String _NO_FILENAME_SPECIFIED = "No Agent configuration file specified";
    public static final String _UNABLE_TO_LOAD_CONFIG = "Unable to find/load Agent configuration file";
    public static final String _COMMAND_NOT_SUCCESSFUL = "The command was not successful";
    public static final String _NEED_MORE_ARGS = "Too few arguments specfied";
    public static final String _UNABLE_TO_CONNECT = "Unable to connect to the Agent";
    public static final String _PORT_IN_USE = "The port is in use";
    public static final String _UPDATE_IN_PROGRESS = "The agent is installing updates and restarting.";
    private static final String GUI_QUERY = "V2_GUI_QUERY";
    private static final String GUI_RESPONSE = "V2_GUI_RESPONSE";
    private static final String MESSAGE_SEPARATOR = "|";
    private static SystemTrayControl theInstance;
    private static final String TITLE = "Automate Schedule Agent Manager";
    private static ImageIcon icon_active;
    private static ImageIcon icon_inactive;
    private static ImageIcon icon_failed;
    private static ImageIcon icon_unknown;
    private static ImageIcon icon_update;
    public static final int LNF_SYSTEM = 0;
    public static final int LNF_ALLOY = 1;
    public static final int LNF_METAL = 2;
    private static final int LNF_TO_USE = 1;
    private static int LNF_CURRENT;
    private static LookAndFeel lnf;
    public static final String INFO_ID = "Info";
    public static final String DEBUG_ID = "Debug";
    public static final String TRACE_ID = "Trace";
    private static final String icoStr = "com/helpsystems/enterprise/tray/images/tray_icon_16.png";
    private AgentTrayIcon trayIcon;
    private PopupPlaceholder trayMenu;
    private ServiceFrame gui;
    private HSAction showGui;
    private HSAction endNowAction;
    private HSAction showHelp;
    private HSAction showMore;
    private boolean firstTimePopup;
    private int localPort;
    private ImageIcon icon;
    private AgentServiceAM agentServiceAM;
    private boolean firstTimeConnect;
    private SimplePeer myPeer;
    private PeerID remoteServicePeerID = null;
    private TreeMap<AgentServiceEntry, AgentProcessInfo> entryProcessMap;
    private MulticastHandler multicastHandler;
    private String myRandomNumber;
    private String windowsAuthID;

    public static SystemTrayControl getTheInstance() {
        return theInstance;
    }

    public AgentTrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    private SystemTrayControl(int n, boolean bl) {
        this.detectExistingInstance(bl);
        this.localPort = n;
        this.entryProcessMap = new TreeMap(new AgentServiceEntryComparator());
        SystemTray systemTray = SystemTray.getSystemTray();
        if (systemTray == null) {
            throw new RuntimeException("Unable to access the System Tray.");
        }
        this.icon = ImageHandling.getIconFromClasspath((String)icoStr);
        if (this.icon == null) {
            throw new RuntimeException("Unable to load the necessary icon.");
        }
        this.agentServiceAM = (AgentServiceAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentServiceAM");
        if (this.agentServiceAM == null) {
            try {
                Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} [%c] %t> %m\n"), "System.out"));
                Logger.getRootLogger().setLevel(Level.INFO);
                Log4jInit.setInitialized((boolean)true);
                this.myPeer = SimplePeer.createAnInstance();
                ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)this.myPeer));
                this.myPeer.addListener((SimpleEventListener)new LocalPeerListener());
            }
            catch (Exception exception) {
                logger.fatal((Object)"Unable to start a peer", (Throwable)exception);
                return;
            }
        }
        Image image = ImageHandling.getIconFromClasspath((String)icoStr).getImage();
        this.trayIcon = new AgentTrayIcon(image);
        this.trayIcon.setToolTip(TITLE);
        this.buildActions();
        this.trayMenu = new PopupPlaceholder("Stuff");
        this.trayIcon.setJPopupMenu(this.trayMenu);
        try {
            systemTray.add(this.trayIcon);
        }
        catch (AWTException aWTException) {
            logger.fatal((Object)"Unable to add the tray icon to the system tray.", (Throwable)aWTException);
        }
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemTrayControl.this.doTrayAction(actionEvent);
            }
        });
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        Thread thread = new Thread(new CleanupProcess());
        Runtime.getRuntime().addShutdownHook(thread);
        this.rebuildMenu();
        this.buildGui();
        this.firstTimePopup = true;
        if (this.myPeer != null) {
            this.firstTimeConnect = true;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            scheduledThreadPoolExecutor.scheduleWithFixedDelay(new ServiceConnectionRunner(), 0L, 1L, TimeUnit.SECONDS);
        }
        if (bl) {
            this.showGUI();
        }
    }

    void addListenerToService(AgentProcessListener agentProcessListener) {
        if (this.agentServiceAM == null) {
            return;
        }
        if (this.agentServiceAM instanceof AgentServiceAMImpl) {
            this.agentServiceAM.addListener(agentProcessListener);
        } else {
            try {
                RemoteEventAM remoteEventAM = (RemoteEventAM)ManagerRegistry.getManager((String)"PEER.RemoteEventAM");
                remoteEventAM.addListenerToPeer(this.remoteServicePeerID, (SimpleEventListener)new AgentProcessListenerAdapter(agentProcessListener));
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to attach event listener to " + this.remoteServicePeerID), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAgentServiceAM(AgentServiceAM agentServiceAM) {
        this.agentServiceAM = agentServiceAM;
        if (this.agentServiceAM == null) {
            TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
            synchronized (treeMap) {
                this.entryProcessMap.clear();
            }
        } else {
            AgentProcessListener agentProcessListener = new AgentProcessListener(){

                @Override
                public void logGrew(AgentProcessInfo agentProcessInfo, String[] stringArray) {
                    SystemTrayControl.this.gui.logGrew(agentProcessInfo, stringArray);
                }

                @Override
                public void processStarted(AgentProcessInfo agentProcessInfo) {
                    SystemTrayControl.this.cacheProcessInfo(agentProcessInfo);
                    SystemTrayControl.this.gui.processStarted(agentProcessInfo);
                    SystemTrayControl.this.rebuildMenu();
                }

                @Override
                public void processEnded(AgentProcessInfo agentProcessInfo) {
                    SystemTrayControl.this.cacheProcessInfo(agentProcessInfo);
                    SystemTrayControl.this.gui.processEnded(agentProcessInfo);
                    SystemTrayControl.this.rebuildMenu();
                }
            };
            this.addListenerToService(agentProcessListener);
        }
        this.gui.setAgentServiceAM(this.agentServiceAM);
        this.rebuildMenu(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchData() {
        TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
        synchronized (treeMap) {
            this.entryProcessMap.clear();
            if (this.agentServiceAM == null) {
                return;
            }
            AgentServiceEntry[] agentServiceEntryArray = this.agentServiceAM.getEntries();
            Serializable[] serializableArray = agentServiceEntryArray;
            int n = serializableArray.length;
            for (int i = 0; i < n; ++i) {
                AgentServiceEntry agentServiceEntry = serializableArray[i];
                this.entryProcessMap.put(agentServiceEntry, null);
            }
            for (Serializable serializable : serializableArray = this.agentServiceAM.getAllProcessInfo()) {
                this.entryProcessMap.put(((AgentProcessInfo)serializable).getEntry(), (AgentProcessInfo)serializable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheProcessInfo(AgentProcessInfo agentProcessInfo) {
        TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
        synchronized (treeMap) {
            this.entryProcessMap.put(agentProcessInfo.getEntry(), agentProcessInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentServiceEntry[] getEntries() {
        TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
        synchronized (treeMap) {
            AgentServiceEntry[] agentServiceEntryArray = new AgentServiceEntry[this.entryProcessMap.size()];
            this.entryProcessMap.keySet().toArray(agentServiceEntryArray);
            return agentServiceEntryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProcessInfo getProcess(AgentServiceEntry agentServiceEntry) {
        TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
        synchronized (treeMap) {
            return this.entryProcessMap.get(agentServiceEntry);
        }
    }

    private void buildGui() {
        this.gui = new ServiceFrame(this);
        ImageIcon imageIcon = null;
        try {
            imageIcon = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/tray_icon_32.png");
            this.gui.setIconImage(imageIcon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HSAction getSettingsAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemTrayControl.this.showGUI(-1);
            }
        };
        hSAction.setName("Agent Manager...");
        hSAction.setMnemonicKey(69);
        return hSAction;
    }

    private HSAction getShowMoreAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemTrayControl.this.showGUI(0);
            }
        };
        hSAction.setName("More...");
        hSAction.setMnemonicKey(77);
        return hSAction;
    }

    private HSAction getHelpAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Window window = null;
                try {
                    HelpInfo helpInfo = RBEHelpManager.getHelpInfo(0);
                    HSHelpBroker hSHelpBroker = HSHelpBroker.getInstance((HelpInfo)helpInfo, (Image)SystemTrayControl.this.icon.getImage());
                    RBEHelpManager.showHelpIndex(window, 0);
                }
                catch (Throwable throwable) {
                    String string = "Error";
                    String string2 = throwable.getMessage();
                    ThrowableDialog.showInformation(window, (String)string, (String)string2, (Throwable)throwable);
                }
            }
        };
        hSAction.setName("Help...");
        hSAction.setMnemonicKey(72);
        return hSAction;
    }

    private HSAction getExitAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                int n = SystemTrayControl.this.countRunningAgents();
                string = SystemTrayControl.this.agentServiceAM instanceof AgentServiceAMImpl ? (n == 0 ? "Are you sure you want to exit?" : (n == 1 ? "Are you sure you want to exit?\nThere is an agent running, which will be ended." : "Are you sure you want to exit?\nThere are " + n + " agents running, which will be ended.")) : (SystemTrayControl.this.remoteServicePeerID != null ? "Are you sure you want to exit?\nExiting this GUI wil not end the Service." : "Are you sure you want to exit?");
                int n2 = JOptionPane.showConfirmDialog(null, string, "Confirm", 0);
                if (n2 == 0) {
                    if (SystemTrayControl.this.agentServiceAM instanceof AgentServiceAMImpl) {
                        SystemTrayControl.this.agentServiceAM.shutdownAndExit(true);
                    }
                    System.exit(0);
                }
            }
        };
        hSAction.setName("Exit");
        hSAction.setMnemonicKey(120);
        return hSAction;
    }

    private void buildActions() {
        this.showGui = this.getSettingsAction();
        this.showMore = this.getShowMoreAction();
        this.showHelp = this.getHelpAction();
        this.endNowAction = this.getExitAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRunningAgents() {
        int n = 0;
        TreeMap<AgentServiceEntry, AgentProcessInfo> treeMap = this.entryProcessMap;
        synchronized (treeMap) {
            for (AgentProcessInfo agentProcessInfo : this.entryProcessMap.values()) {
                if (agentProcessInfo == null || !agentProcessInfo.isAlive()) continue;
                ++n;
            }
        }
        return n;
    }

    public void rebuildMenu() {
        this.rebuildMenu(false);
    }

    public void rebuildMenu(boolean bl) {
        HSSwingWorker hSSwingWorker = new HSSwingWorker(){

            public Object construct() {
                SystemTrayControl.this.fetchData();
                return null;
            }

            public void finished() {
                SystemTrayControl.this.rebuildMenu(false);
                SystemTrayControl.this.gui.refreshData();
            }
        };
        if (bl) {
            hSSwingWorker.start();
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SystemTrayControl.this.rebuildMenu(false);
                }
            });
            return;
        }
        if (this.trayMenu.isVisible()) {
            this.trayMenu.setVisible(false);
        }
        this.trayMenu.removeAll();
        AgentServiceEntry[] agentServiceEntryArray = null;
        if (this.agentServiceAM != null) {
            agentServiceEntryArray = this.getEntries();
        }
        if (agentServiceEntryArray == null) {
            JMenuItem jMenuItem = new JMenuItem("Service disconnected");
            this.trayMenu.add(jMenuItem);
        } else if (agentServiceEntryArray.length == 0) {
            JMenuItem jMenuItem = new JMenuItem("No agents are defined");
            this.trayMenu.add(jMenuItem);
        } else {
            int n = 0;
            for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray) {
                if (n++ > 20) {
                    this.trayMenu.add((Action)this.showMore);
                    break;
                }
                String string = agentServiceEntry.getLabel();
                ImageIcon imageIcon = null;
                AgentProcessInfo agentProcessInfo = null;
                if (this.agentServiceAM != null) {
                    agentProcessInfo = this.getProcess(agentServiceEntry);
                    imageIcon = SystemTrayControl.getAgentProcessInfoIcon(agentProcessInfo);
                } else {
                    imageIcon = SystemTrayControl.getUnknownIcon();
                }
                JMenu jMenu = new JMenu(string);
                jMenu.setIcon(imageIcon);
                JSeparator jSeparator = new JSeparator();
                this.updateComponentLNF(jSeparator);
                if (this.agentServiceAM == null) continue;
                if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
                    jMenu.add(this.getMI(new ShutdownAction("Stop Agent", agentServiceEntry, 79)));
                    jMenu.add(this.getMI(new ShutdownRestartAction("Stop and Restart Agent", agentServiceEntry, 82)));
                    jMenu.add(jSeparator);
                    jMenu.add(this.getMI(new DiagnosticPageAction("Diagnostic Page", agentServiceEntry, 68)));
                } else {
                    jMenu.add(this.getMI(new StartAgentAction("Start Agent", agentServiceEntry, 83)));
                }
                jMenu.add(this.getMI(new ShowAgentLogAction("Agent Console Output", agentServiceEntry, 67)));
                jMenu.add(jSeparator);
                JMenu jMenu2 = this.getLoggingLevelMenu(this.gui, new AgentServiceEntryWrapper(agentServiceEntry));
                jMenu.add(jMenu2);
                this.trayMenu.add(jMenu);
            }
        }
        agentServiceEntryArray = null;
        JSeparator jSeparator = new JSeparator();
        this.updateComponentLNF(jSeparator);
        this.trayMenu.add(jSeparator);
        this.trayMenu.add(this.getMI(this.showGui));
        this.trayMenu.add(this.getMI(this.showHelp));
        this.trayMenu.add(this.getMI(this.endNowAction));
        this.updateComponentLNF(this.trayMenu);
    }

    public JMenu getLoggingLevelMenu(HSJFrame hSJFrame, AgentServiceEntrySource agentServiceEntrySource) {
        return this.getLoggingMenu(hSJFrame, agentServiceEntrySource);
    }

    private JMenuItem getMI(HSAction hSAction) {
        JMenuItem jMenuItem = new JMenuItem((Action)hSAction);
        jMenuItem.setMnemonic(hSAction.getMnemonicKey());
        return jMenuItem;
    }

    private void updateComponentLNF(JComponent jComponent) {
        SystemTrayControl.updateSystemDefaultLNF();
        jComponent.updateUI();
        SwingUtilities.updateComponentTreeUI(jComponent);
        SystemTrayControl.updateCustomLNF();
    }

    public static ImageIcon getActiveIcon() {
        if (icon_active == null) {
            icon_active = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/agent_active_16.png");
            icon_active.setDescription("The status of the Agent is Active");
        }
        return icon_active;
    }

    public static ImageIcon getUnknownIcon() {
        if (icon_unknown == null) {
            icon_unknown = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/agent_unknown_16.png");
            icon_unknown.setDescription("The status of the Agent is unknown.");
        }
        return icon_unknown;
    }

    public static ImageIcon getInactiveIcon() {
        if (icon_inactive == null) {
            icon_inactive = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/agent_inactive_16.png");
            icon_inactive.setDescription("The status of the Agent is inactive.");
        }
        return icon_inactive;
    }

    public static ImageIcon getUpdateIcon() {
        if (icon_update == null) {
            icon_update = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/agent_update_16.png");
            icon_update.setDescription("The Agent is updating itself.");
        }
        return icon_update;
    }

    public static ImageIcon getAgentProcessInfoIcon(AgentProcessInfo agentProcessInfo) {
        ImageIcon imageIcon = SystemTrayControl.getInactiveIcon();
        if (agentProcessInfo == null) {
            return imageIcon;
        }
        if (agentProcessInfo.isAlive()) {
            imageIcon = SystemTrayControl.getActiveIcon();
        } else if (agentProcessInfo.getProcessExitValue() > 0) {
            imageIcon = SystemTrayControl.getFailedIcon();
        }
        return imageIcon;
    }

    public static String getFailureMessage(AgentProcessInfo agentProcessInfo) {
        if (agentProcessInfo == null) {
            return "";
        }
        switch (agentProcessInfo.getProcessExitValue()) {
            case 0: {
                return "";
            }
            case 1: {
                return _COMMAND_FAILED;
            }
            case 101: {
                return _NO_FILENAME_SPECIFIED;
            }
            case 102: {
                return _UNABLE_TO_LOAD_CONFIG;
            }
            case 103: {
                return _COMMAND_NOT_SUCCESSFUL;
            }
            case 104: {
                return _NEED_MORE_ARGS;
            }
            case 105: {
                return _UNABLE_TO_CONNECT;
            }
            case 107: {
                return _PORT_IN_USE;
            }
            case 97: {
                return _UPDATE_IN_PROGRESS;
            }
        }
        return "Unknown error code: " + agentProcessInfo.getProcessExitValue();
    }

    public static ImageIcon getFailedIcon() {
        if (icon_failed == null) {
            icon_failed = ImageHandling.getIconFromClasspath((String)"com/helpsystems/enterprise/tray/images/agent_failed_16.png");
            icon_failed.setDescription("The status of the Agent is failed.");
        }
        return icon_failed;
    }

    private void doTrayAction(ActionEvent actionEvent) {
        if (this.gui == null) {
            return;
        }
        WindowSizing.centerWindow((Window)((Object)this.gui), (boolean)false);
        this.showGUI();
        this.trayMenu.setVisible(false);
    }

    public static SystemTrayControl initialize(final int n, final boolean bl) {
        if (theInstance == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        theInstance = new SystemTrayControl(n, bl);
                    }
                });
            }
            catch (Exception exception) {
                logger.debug((Object)"Problem starting/waiting for GUI", (Throwable)exception);
            }
            return theInstance;
        }
        throw new IllegalStateException("The system tray control has already been initialized.");
    }

    public static long getAuthenticationID() {
        long l = -1L;
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        boolean bl = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 8, hANDLEByReference);
        if (bl) {
            IntByReference intByReference = new IntByReference();
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 10, null, 0, intByReference);
            Advapi32.TOKEN_STATISTICS tOKEN_STATISTICS = new Advapi32.TOKEN_STATISTICS();
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 10, tOKEN_STATISTICS.getPointer(), intByReference.getValue(), intByReference);
            tOKEN_STATISTICS.read();
            l = tOKEN_STATISTICS.AuthenticationId;
        } else {
            logger.debug((Object)("Unable to get session auth id, error " + Kernel32.INSTANCE.GetLastError()));
        }
        return l;
    }

    private void detectExistingInstance(boolean bl) {
        try {
            this.windowsAuthID = Long.toString(SystemTrayControl.getAuthenticationID());
            this.multicastHandler = new MulticastHandler("230.9.11.1", 7472, this.windowsAuthID);
            MulticastWorker multicastWorker = new MulticastWorker();
            Thread thread = new Thread(multicastWorker);
            thread.setName("MulticastListener listening on port 7472 as 230.9.11.1");
            thread.setDaemon(true);
            thread.start();
            multicastWorker.waitForReady();
            this.myRandomNumber = Long.toString(System.currentTimeMillis());
            this.multicastHandler.send(this.multicastHandler.getIdentifier(), "V2_GUI_QUERY|" + this.myRandomNumber + MESSAGE_SEPARATOR + bl);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to query for an existing instance.", (Throwable)exception);
        }
    }

    public static void updateCustomLNF() {
        Object object;
        if (LNF_CURRENT == 1 && lnf != null) {
            return;
        }
        try {
            switch (1) {
                case 1: {
                    object = new HSFontTheme();
                    DefaultAlloyTheme defaultAlloyTheme = new DefaultAlloyTheme((AlloyFontTheme)object);
                    lnf = new AlloyLookAndFeel((AlloyTheme)defaultAlloyTheme);
                    UIManager.setLookAndFeel(lnf);
                    break;
                }
                case 2: {
                    DefaultMetalTheme defaultMetalTheme = new DefaultMetalTheme();
                    lnf = new MetalLookAndFeel();
                    MetalLookAndFeel.setCurrentTheme(defaultMetalTheme);
                    UIManager.setLookAndFeel(lnf);
                    break;
                }
                default: {
                    String string = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(string);
                    break;
                }
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Error setting look and feel.", (Throwable)exception);
        }
        object = UIManager.getDefaults();
        ((UIDefaults)object).put("TextField.lockedBackground", ((UIDefaults)object).get("Label.background"));
        ((UIDefaults)object).put("Viewport.background", ((UIDefaults)object).get("Label.background"));
        ((UIDefaults)object).put("PasswordField.inactiveBackground", ((UIDefaults)object).get("TextField.inactiveBackground"));
    }

    public static void updateSystemDefaultLNF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void showGUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showGUI(-1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SystemTrayControl.this.showGUI(-1);
                }
            });
        }
    }

    public void showGUI(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n2;
                if (SystemTrayControl.this.gui == null) {
                    SystemTrayControl.this.buildGui();
                }
                if (((n2 = SystemTrayControl.this.gui.getExtendedState()) & 1) > 0) {
                    SystemTrayControl.this.gui.setExtendedState(n2 ^= 1);
                }
                WindowSizing.centerWindow((Window)((Object)SystemTrayControl.this.gui), (boolean)false);
                SystemTrayControl.this.gui.setVisible(true);
                SystemTrayControl.this.gui.toFront();
                SystemTrayControl.this.gui.showTab(n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean stopAction(Component component, AgentServiceEntry agentServiceEntry) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Do you want to stop the Agent " + agentServiceEntry.getLabel() + "?");
        JCheckBox jCheckBox = new JCheckBox("End Agent immediately");
        jCheckBox.setSelected(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 0, 0));
        int n = JOptionPane.showConfirmDialog(component, jPanel, "Confirmation", 2);
        if (n == 0) {
            this.agentServiceAM.stopAgent(agentServiceEntry, jCheckBox.isSelected());
            this.gui.setStatusBarText("Stopping " + agentServiceEntry.getLabel(), true);
            return true;
        }
        return false;
    }

    public boolean restartAction(Component component, AgentServiceEntry agentServiceEntry) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Do you want to restart the Agent " + agentServiceEntry.getLabel() + "?");
        JCheckBox jCheckBox = new JCheckBox("End Agent immediately");
        jCheckBox.setSelected(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 0, 0));
        int n = JOptionPane.showConfirmDialog(component, jPanel, "Confirmation", 2);
        if (n == 0) {
            this.agentServiceAM.shutdownAgent(agentServiceEntry, true, jCheckBox.isSelected());
            this.gui.setStatusBarText("Restarting " + agentServiceEntry.getLabel(), true);
            return true;
        }
        return false;
    }

    public void displayLog(final AgentServiceEntry agentServiceEntry, final HSJFrame hSJFrame) {
        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
            Throwable t = null;

            public void construct() {
                try {
                    AgentServiceEntry agentServiceEntry2 = agentServiceEntry;
                    if (agentServiceEntry2 == null && hSJFrame instanceof ServiceFrame) {
                        agentServiceEntry2 = ((ServiceFrame)hSJFrame).getSelectedEntry();
                    }
                    GuiLogging.showLog((JFrame)hSJFrame, (String)agentServiceEntry2.getLogFileName());
                }
                catch (Throwable throwable) {
                    this.t = throwable;
                }
            }

            public void finished() {
                if (this.t != null) {
                    ThrowableDialog.showThrowable((Component)hSJFrame, (String)this.t.getLocalizedMessage(), (Throwable)this.t);
                    return;
                }
            }
        };
        hSJFrame.suspendAndRun(swingWorkerTarget);
    }

    public JMenu getLoggingMenu(final HSJFrame hSJFrame, final AgentServiceEntrySource agentServiceEntrySource) {
        JMenu jMenu = new JMenu();
        jMenu.setMnemonic('L');
        jMenu.setText("Agent Logging");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addActionToRadioButtonMenu(jMenu, new LoggingInfoAction("Informational", agentServiceEntrySource, 73, hSJFrame), buttonGroup, Level.INFO, agentServiceEntrySource);
        this.addActionToRadioButtonMenu(jMenu, new LoggingDebugAction(DEBUG_ID, agentServiceEntrySource, 68, hSJFrame), buttonGroup, Level.DEBUG, agentServiceEntrySource);
        this.addActionToRadioButtonMenu(jMenu, new LoggingTraceAction(TRACE_ID, agentServiceEntrySource, 84, hSJFrame), buttonGroup, Level.TRACE, agentServiceEntrySource);
        JMenuItem jMenuItem = new JMenuItem("Display Agent Log");
        JSeparator jSeparator = new JSeparator();
        this.updateComponentLNF(jSeparator);
        jMenu.add(jSeparator);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemTrayControl.this.displayLog(agentServiceEntrySource.getEntry(), hSJFrame);
            }
        });
        return jMenu;
    }

    public void updateLoggingMenuItem(LoggingMenuItem loggingMenuItem) {
        ValidationHelper.checkForNull((String)"Menu Item", (Object)loggingMenuItem);
        AgentServiceEntry agentServiceEntry = loggingMenuItem.getSource().getEntry();
        if (agentServiceEntry == null) {
            loggingMenuItem.getAction().setEnabled(false);
            loggingMenuItem.setSelected(false);
            return;
        }
        Level level = null;
        AgentProcessInfo agentProcessInfo = this.getProcess(agentServiceEntry);
        boolean bl = false;
        if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
            try {
                level = agentServiceEntry.getLoggingLevel();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.debug((Object)"Unable to fetch logging level", (Throwable)fileNotFoundException);
            }
            if (loggingMenuItem.getLevel().equals((Object)level)) {
                loggingMenuItem.setSelected(true);
            }
            bl = true;
        }
        loggingMenuItem.getAction().setEnabled(bl);
    }

    protected Level getLoggingLevel(AgentServiceEntry agentServiceEntry) throws FileNotFoundException {
        AgentServiceEntry agentServiceEntry2 = this.gui.getSelectedEntry();
        if (agentServiceEntry2 != null) {
            return agentServiceEntry2.getLoggingLevel();
        }
        return Level.INFO;
    }

    private void applyLoggingLevel(HSJFrame hSJFrame, String string, AgentServiceEntry agentServiceEntry) {
        AgentServiceEntry agentServiceEntry2 = agentServiceEntry;
        if (agentServiceEntry2 == null && (agentServiceEntry2 = ((ServiceFrame)hSJFrame).getSelectedEntry()) == null) {
            return;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Agent ");
        stringBuffer.append(agentServiceEntry2.getLabel());
        stringBuffer.append(" logging level set to ");
        if (string.equals(INFO_ID)) {
            stringBuffer.append("informational.");
            bl = this.notifyRunningPeers(agentServiceEntry2, Level.INFO);
        } else if (string.equals(DEBUG_ID)) {
            stringBuffer.append("debug.");
            bl = this.notifyRunningPeers(agentServiceEntry2, Level.DEBUG);
        } else if (string.equals(TRACE_ID)) {
            stringBuffer.append("trace.");
            bl = this.notifyRunningPeers(agentServiceEntry2, Level.TRACE);
        } else {
            stringBuffer.append("informational.");
            bl = this.notifyRunningPeers(agentServiceEntry2, Level.INFO);
        }
        if (bl) {
            this.gui.setStatusBarText(stringBuffer.toString(), true);
        } else {
            this.gui.setStatusBarText("Unable to change agent's logging level.", true);
        }
    }

    private boolean notifyRunningPeers(AgentServiceEntry agentServiceEntry, Level level) {
        if (agentServiceEntry == null) {
            return false;
        }
        AgentProcessInfo agentProcessInfo = this.getProcess(agentServiceEntry);
        if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
            this.agentServiceAM.setLoggingLevel(agentServiceEntry, level.toInt());
            return true;
        }
        return false;
    }

    private JRadioButtonMenuItem addActionToRadioButtonMenu(JMenu jMenu, EntryAction entryAction, ButtonGroup buttonGroup, Level level, AgentServiceEntrySource agentServiceEntrySource) {
        LoggingMenuItem loggingMenuItem = new LoggingMenuItem(agentServiceEntrySource, (Action)((Object)entryAction), level);
        loggingMenuItem.setName(entryAction.getName());
        buttonGroup.add(loggingMenuItem);
        jMenu.add(loggingMenuItem);
        return loggingMenuItem;
    }

    static {
        icon_active = null;
        icon_inactive = null;
        icon_failed = null;
        icon_unknown = null;
        icon_update = null;
        LNF_CURRENT = -1;
        lnf = null;
        LookAndFeelAdjustments.makeLookAndFeelAdjustments();
    }

    class LoggingMenuItem
    extends JRadioButtonMenuItem {
        AgentServiceEntrySource source;
        Level myLevel;

        LoggingMenuItem(AgentServiceEntrySource agentServiceEntrySource, Action action, Level level) {
            super(action);
            this.source = agentServiceEntrySource;
            this.myLevel = level;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            SystemTrayControl.this.updateLoggingMenuItem(this);
            super.paintComponent(graphics);
        }

        public AgentServiceEntrySource getSource() {
            return this.source;
        }

        public Level getLevel() {
            return this.myLevel;
        }
    }

    class MulticastWorker
    implements Runnable {
        boolean readyToReceive = false;

        MulticastWorker() {
        }

        String safelyGet(String[] stringArray, int n) {
            if (n < stringArray.length) {
                return stringArray[n];
            }
            return null;
        }

        private void handleSpecificMessage(MulticastMessage multicastMessage) throws IOException {
            String string = multicastMessage.getMessage();
            if (string.startsWith(SystemTrayControl.GUI_QUERY)) {
                String string2;
                String[] stringArray = string.split(Pattern.quote(SystemTrayControl.MESSAGE_SEPARATOR));
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                    if (SystemTrayControl.this.myRandomNumber.equals(string2)) {
                        return;
                    }
                }
                if (stringArray.length > 2 && "true".equals(stringArray[2])) {
                    SystemTrayControl.this.showGUI();
                }
                string2 = "V2_GUI_RESPONSE|" + SystemTrayControl.this.myRandomNumber;
                SystemTrayControl.this.multicastHandler.send(SystemTrayControl.this.windowsAuthID, string2);
            } else if (string.startsWith(SystemTrayControl.GUI_RESPONSE)) {
                String[] stringArray = string.split(Pattern.quote(SystemTrayControl.MESSAGE_SEPARATOR));
                if (stringArray.length > 1) {
                    String string3 = stringArray[1];
                    if (!SystemTrayControl.this.myRandomNumber.equals(string3)) {
                        System.exit(0);
                    }
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("Unhandled specific message was: " + string));
            }
        }

        void waitForReady() {
            while (!this.readyToReceive) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (SystemTrayControl.access$1900(SystemTrayControl.this) == null) {
                SystemTrayControl.access$1500().debug((Object)"MulticastSocket is not available, MulticastWorker is exiting.");
                return;
            }
            var1_1 = 0;
            this.readyToReceive = true;
            while (true) {
                try {
                    while (true) {
                        var2_2 = SystemTrayControl.access$1900(SystemTrayControl.this).receive();
                        var1_1 = 0;
                        var3_5 = var2_2.getDestination();
                        if (var3_5 == null || var3_5.length() == 0) {
                            if (!SystemTrayControl.access$1500().isTraceEnabled()) continue;
                            SystemTrayControl.access$1500().trace((Object)("Unhandled broadcast message: " + var2_2.toString()));
                            continue;
                        }
                        if (SystemTrayControl.access$1900(SystemTrayControl.this).getIdentifier().equals(var3_5)) {
                            this.handleSpecificMessage(var2_2);
                            continue;
                        }
                        if (!SystemTrayControl.access$1500().isTraceEnabled()) continue;
                        SystemTrayControl.access$1500().trace((Object)("Unhandled message: " + var2_2.toString()));
                    }
                }
                catch (RuntimeException var2_3) {
                    SystemTrayControl.access$1500().debug((Object)"Error parsing request via the Multicast socket.", (Throwable)var2_3);
                    continue;
                }
                catch (IOException var2_4) {
                    SystemTrayControl.access$1500().debug((Object)"Multicast socket I/O problem.", (Throwable)var2_4);
                    if (++var1_1 > 2) ** break;
                    continue;
                    SystemTrayControl.access$1500().debug((Object)"Due to several Multicast I/O problems,  the MulticastListener is exiting.");
                    return;
                }
                break;
            }
        }
    }

    class LoggingTraceAction
    extends EntryAction {
        LoggingTraceAction(String string, AgentServiceEntrySource agentServiceEntrySource, int n, HSJFrame hSJFrame) {
            super(string, agentServiceEntrySource, n);
            this.parent = hSJFrame;
            this.setName(SystemTrayControl.TRACE_ID);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.applyLoggingLevel(this.parent, SystemTrayControl.TRACE_ID, this.entry);
        }
    }

    class LoggingDebugAction
    extends EntryAction {
        LoggingDebugAction(String string, AgentServiceEntrySource agentServiceEntrySource, int n, HSJFrame hSJFrame) {
            super(string, agentServiceEntrySource, n);
            this.parent = hSJFrame;
            this.setName(SystemTrayControl.DEBUG_ID);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.applyLoggingLevel(this.parent, SystemTrayControl.DEBUG_ID, this.entry);
        }
    }

    class LoggingInfoAction
    extends EntryAction {
        LoggingInfoAction(String string, AgentServiceEntrySource agentServiceEntrySource, int n, HSJFrame hSJFrame) {
            super(string, agentServiceEntrySource, n);
            this.parent = hSJFrame;
            this.setName(SystemTrayControl.INFO_ID);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.applyLoggingLevel(this.parent, SystemTrayControl.INFO_ID, this.entry);
        }
    }

    class LocalPeerListener
    extends PeerEventListener {
        LocalPeerListener() {
        }

        public void peerConnected(PeerID peerID, PeerID peerID2) {
        }

        public void peerDisconnected(PeerID peerID, PeerID peerID2) {
            SystemTrayControl.this.setAgentServiceAM(null);
            SystemTrayControl.this.remoteServicePeerID = null;
        }
    }

    class ServiceConnectionRunner
    implements Runnable {
        ServiceConnectionRunner() {
        }

        @Override
        public void run() {
            block7: {
                if (SystemTrayControl.this.remoteServicePeerID == null) {
                    try {
                        PeerDescriptor peerDescriptor = PeerDescriptor.createLocalPeerDescriptor((int)SystemTrayControl.this.localPort, (int)7);
                        if (peerDescriptor.isValid()) {
                            PeerID peerID = SystemTrayControl.this.myPeer.connectToPeer(peerDescriptor, (Serializable)((Object)"hi"));
                            SystemTrayControl.this.remoteServicePeerID = peerID;
                            SystemTrayControl.this.firstTimeConnect = true;
                        }
                    }
                    catch (Throwable throwable) {
                        SystemTrayControl.this.remoteServicePeerID = null;
                        if (!SystemTrayControl.this.firstTimeConnect) break block7;
                        logger.debug((Object)"Unable to connect to the server", throwable);
                        SystemTrayControl.this.firstTimeConnect = false;
                    }
                }
            }
            if (SystemTrayControl.this.remoteServicePeerID != null && SystemTrayControl.this.agentServiceAM == null) {
                try {
                    SystemTrayControl.this.agentServiceAM = (AgentServiceAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)SystemTrayControl.this.remoteServicePeerID, (String)"ENTERPRISE.AgentServiceAM");
                    SystemTrayControl.this.setAgentServiceAM(SystemTrayControl.this.agentServiceAM);
                }
                catch (Throwable throwable) {
                    logger.debug((Object)"Unable to get data from the server.", throwable);
                }
            }
        }
    }

    class DiagnosticPageAction
    extends EntryAction {
        DiagnosticPageAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            super(string, agentServiceEntry, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n = -1;
            try {
                object = (AgentPeerConfig)XMLUtil.loadObjectFromFile((String)this.getEntry().getFilePath());
                n = object.getListenPort();
            }
            catch (Exception exception) {
                ThrowableDialog.showThrowable(null, (String)("Unable to load the Agent config file " + this.getEntry().getFilename()), (String)"Error", (Throwable)exception);
                return;
            }
            object = "https://localhost:" + n + "/cp/HS_diagnostics.html";
            try {
                String[] stringArray = new String[]{"cmd.exe", "/c", "start", "url"};
                URI uRI = new URI("https://localhost:" + n + "/cp/HS_diagnostics.html");
                Desktop desktop = null;
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                }
                if (desktop == null) {
                    throw new IllegalStateException("The default browser is not supported.");
                }
                desktop.browse(uRI);
            }
            catch (Exception exception) {
                ThrowableDialog.showThrowable(null, (String)("Unable to start a web browser.\nStart a web browser and point it at the address " + (String)object), (String)"Unable to display diagnostic info", (Throwable)exception);
            }
        }
    }

    class ShowAgentLogAction
    extends EntryAction {
        ShowAgentLogAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            super(string, agentServiceEntry, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowSizing.centerWindow((Window)((Object)SystemTrayControl.this.gui), (boolean)false);
            SystemTrayControl.this.gui.showAgentLog(this.getEntry());
        }
    }

    class StartAgentAction
    extends EntryAction {
        StartAgentAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            super(string, agentServiceEntry, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.gui.setStatusBarText("Starting " + this.getEntry().getLabel(), true);
            SystemTrayControl.this.agentServiceAM.startAgent(this.getEntry());
        }
    }

    class ShutdownRestartAction
    extends EntryAction {
        ShutdownRestartAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            super(string, agentServiceEntry, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.restartAction(SystemTrayControl.this.trayMenu, this.getEntry());
        }
    }

    class ShutdownAction
    extends EntryAction {
        ShutdownAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            super(string, agentServiceEntry, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemTrayControl.this.stopAction(SystemTrayControl.this.trayMenu, this.getEntry());
        }
    }

    abstract class EntryAction
    extends HSAction {
        AgentServiceEntry entry;
        AgentServiceEntrySource source;
        HSJFrame parent;

        EntryAction(String string, AgentServiceEntrySource agentServiceEntrySource, int n) {
            this.setName(string);
            this.setMnemonicKey(n);
            this.source = agentServiceEntrySource;
        }

        EntryAction(String string, AgentServiceEntry agentServiceEntry, int n) {
            this.setName(string);
            this.setMnemonicKey(n);
            this.entry = agentServiceEntry;
        }

        public void setAgentEntry(AgentServiceEntry agentServiceEntry) {
            this.entry = agentServiceEntry;
        }

        public AgentServiceEntry getEntry() {
            if (this.source != null) {
                return this.source.getEntry();
            }
            return this.entry;
        }
    }

    class CleanupProcess
    implements Runnable {
        CleanupProcess() {
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
            } else if (SystemTrayControl.this.agentServiceAM instanceof AgentServiceAMImpl) {
                SystemTrayControl.this.agentServiceAM.shutdownAndExit(true);
            }
        }
    }

    public class PopupPlaceholder
    extends JPopupMenu {
        PopupPlaceholder(String string) {
            super(string);
        }

        @Override
        public void show(Component component, int n, int n2) {
            Window window = SwingUtilities.getWindowAncestor(component);
            if (SystemTrayControl.this.firstTimePopup) {
                Window window2;
                SystemTrayControl.this.firstTimePopup = false;
                if (window instanceof Dialog) {
                    ((Dialog)window).setTitle(SystemTrayControl.TITLE);
                }
                if ((window2 = window.getOwner()) instanceof Frame) {
                    Frame frame = (Frame)window2;
                    frame.setIconImage(ImageHandling.getIconFromClasspath((String)"com/helpsystems/common/client/images/frame_icon_16.gif").getImage());
                    frame.setTitle(SystemTrayControl.TITLE);
                }
            }
            window.setAlwaysOnTop(true);
            super.show(component, n, n2);
        }

        @Override
        public void setVisible(boolean bl) {
            if (!bl) {
                this.doHide();
            } else {
                super.setVisible(bl);
            }
        }

        private void doHide() {
            StackTraceElement stackTraceElement;
            Exception exception = new Exception("Hiding the popup?");
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            if (stackTraceElementArray.length > 2 && "windowLostFocus".equals((stackTraceElement = stackTraceElementArray[2]).getMethodName())) {
                return;
            }
            super.setVisible(false);
        }
    }
}

