/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.enterprise.service.AgentServiceConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import junit.framework.TestCase;

public class AgentServiceConfigTest
extends TestCase {
    AgentServiceConfig asc;
    AgentServiceEntry ase;

    protected void setUp() throws Exception {
        super.setUp();
        this.asc = new AgentServiceConfig();
        this.ase = new AgentServiceEntry();
        this.ase.setLabel("my_entry");
    }

    protected void tearDown() throws Exception {
        this.ase = null;
        this.asc = null;
        super.tearDown();
    }

    public void testOkToAddEntry() {
        AgentServiceConfigTest.assertTrue((boolean)this.asc.okToAddEntry(this.ase));
        this.asc.addEntry(this.ase);
        try {
            this.asc.okToAddEntry(this.ase);
            AgentServiceConfigTest.fail((String)"okToAddEntry() failed to throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.asc.removeEntry(this.ase);
        AgentServiceConfigTest.assertTrue((boolean)this.asc.okToAddEntry(this.ase));
    }

    public void testCannotAddEntryThatIsAlreadyThere() {
        this.asc.addEntry(this.ase);
        try {
            this.asc.addEntry(this.ase);
            AgentServiceConfigTest.fail((String)"addEntry() should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAndFindEntry() {
        AgentServiceConfigTest.assertNull((Object)this.asc.findEntry("my_entry"));
        this.asc.addEntry(this.ase);
        AgentServiceConfigTest.assertEquals((Object)this.ase, (Object)this.asc.findEntry("my_entry"));
    }

    public void testGetEntries() {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setLabel("entry_1");
        AgentServiceEntry agentServiceEntry2 = new AgentServiceEntry();
        agentServiceEntry2.setLabel("entry_2");
        AgentServiceEntry agentServiceEntry3 = new AgentServiceEntry();
        agentServiceEntry3.setLabel("entry_3");
        AgentServiceEntry agentServiceEntry4 = new AgentServiceEntry();
        agentServiceEntry4.setLabel("entry_4");
        this.asc.addEntry(agentServiceEntry);
        this.asc.addEntry(agentServiceEntry2);
        this.asc.addEntry(agentServiceEntry3);
        Object[] objectArray = this.asc.getEntries();
        AgentServiceConfigTest.assertEquals((int)3, (int)objectArray.length);
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry));
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry2));
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry3));
        AgentServiceConfigTest.assertFalse((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry4));
    }

    public void testGetEntry() {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setLabel("entry_1");
        AgentServiceEntry agentServiceEntry2 = new AgentServiceEntry();
        agentServiceEntry2.setLabel("entry_2");
        this.asc.addEntry(agentServiceEntry);
        this.asc.addEntry(agentServiceEntry2);
        AgentServiceEntry agentServiceEntry3 = this.asc.getEntry(0);
        AgentServiceConfigTest.assertEquals((Object)agentServiceEntry, (Object)agentServiceEntry3);
        AgentServiceEntry agentServiceEntry4 = this.asc.getEntry(1);
        AgentServiceConfigTest.assertEquals((Object)agentServiceEntry2, (Object)agentServiceEntry4);
    }

    public void testRemoveEntry() {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setLabel("entry_1");
        AgentServiceEntry agentServiceEntry2 = new AgentServiceEntry();
        agentServiceEntry2.setLabel("entry_2");
        this.asc.addEntry(agentServiceEntry);
        this.asc.addEntry(agentServiceEntry2);
        Object[] objectArray = this.asc.getEntries();
        AgentServiceConfigTest.assertEquals((int)2, (int)objectArray.length);
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry));
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry2));
        this.asc.removeEntry(agentServiceEntry);
        objectArray = this.asc.getEntries();
        AgentServiceConfigTest.assertEquals((int)1, (int)objectArray.length);
        AgentServiceConfigTest.assertFalse((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry));
        AgentServiceConfigTest.assertTrue((boolean)AgentServiceConfigTest.contains(objectArray, agentServiceEntry2));
    }

    public void testGetLocalListenPort() {
        AgentServiceConfigTest.assertEquals((int)57471, (int)this.asc.getLocalListenPort());
    }

    public void testSetLocalListenPort() {
        this.asc.setLocalListenPort(22222);
        AgentServiceConfigTest.assertEquals((int)22222, (int)this.asc.getLocalListenPort());
        this.asc.setLocalListenPort(33333);
        AgentServiceConfigTest.assertEquals((int)33333, (int)this.asc.getLocalListenPort());
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.asc.doNotInvoke();
        AgentServiceConfigTest.assertEquals((int)0, (int)stringArray.length);
    }

    public void testSaveAgentServiceConfig() {
        String string = null;
        try {
            AgentServiceConfig.saveAgentServiceConfig(this.asc, string, false);
            AgentServiceConfigTest.fail((String)"saveAgentServiceConfig(null) did not throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        string = "";
        try {
            AgentServiceConfig.saveAgentServiceConfig(this.asc, string, false);
            AgentServiceConfigTest.fail((String)"saveAgentServiceConfig(\"\") did not throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        string = "C:\\temp";
        try {
            AgentServiceConfig.saveAgentServiceConfig(this.asc, string, false);
            AgentServiceConfigTest.fail((String)"saveAgentServiceConfig([directory]) did not throw RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        string = "C:\\temp\\agentServiceConfig.xml";
        AgentServiceConfig.saveAgentServiceConfig(this.asc, string, true);
        try {
            AgentServiceConfig.saveAgentServiceConfig(this.asc, string, false);
            AgentServiceConfigTest.fail((String)"saveAgentServiceConfig([existing file]) did not throw RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static boolean contains(Object[] objectArray, Object object) {
        for (Object object2 : objectArray) {
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }
}

