/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerStatus;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServer;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteServersDMJdbc
extends AbstractDatabaseManager
implements RemoteServersDM {
    private static final Logger logger = Logger.getLogger(RemoteServersDMJdbc.class);
    private static final String REMOTE_SERVERS_TABLE = "remote_servers";
    private static final String REMOTE_SCHEDULE_SERVERS_TABLE = "remote_schedule_servers";
    private static final String REMOTE_SKYBOT_SERVERS_TABLE = "remote_automate_servers";
    private static final String DEPENDENCIES_TABLE = "dependencies";
    private static final String REMOTE_EVENTS_TABLE = "remote_events";
    private String remoteServersTable;
    private String remoteScheduleServersTable;
    private String remoteSkybotServersTable;
    private String dependenciesTable;
    private String remoteEventsTable;

    public RemoteServersDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.remoteServersTable = string2 + "." + REMOTE_SERVERS_TABLE;
        this.remoteScheduleServersTable = string2 + "." + REMOTE_SCHEDULE_SERVERS_TABLE;
        this.remoteSkybotServersTable = string2 + "." + REMOTE_SKYBOT_SERVERS_TABLE;
        this.dependenciesTable = string2 + "." + DEPENDENCIES_TABLE;
        this.remoteEventsTable = string2 + "." + REMOTE_EVENTS_TABLE;
        this.setName(string3);
    }

    public void clearInstalledDateTime(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteScheduleServersTable + " SET installed_utc= NULL WHERE remote_server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to clear the installed date/time for remote server {0} in the database, but no records were updated.", (Object[])new Object[]{this.getServerName(l)}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to clear the installed date/time for remote server {0}.", (Object[])new Object[]{this.getServerName(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public long[] getByHardwareHashAndInstanceIdentifier(String string, String string2) throws ResourceUnavailableException {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string3 = "SELECT remote_server_id FROM " + this.remoteSkybotServersTable + " WHERE hardware_hash=? AND instance_identifier=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            object = preparedStatement.executeQuery();
            while (object.next()) {
                arrayList.add(object.getLong("remote_server_id"));
            }
        }
        catch (SQLException sQLException) {
            String string4 = "SQL error while retrieving a Remote Server by hardware hash and instance identifier.";
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        object = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            object[n++] = l;
        }
        return object;
    }

    public Long getInstalledDateTime(long l) throws ResourceUnavailableException {
        RemoteServerType remoteServerType;
        try {
            remoteServerType = this.getServerType(l);
        }
        catch (NoDataException noDataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote server with id = {0} not found.", (Object[])new Object[]{l}));
        }
        switch (remoteServerType) {
            case SCHEDULE: {
                String string = "SELECT installed_utc FROM " + this.remoteScheduleServersTable + " WHERE remote_server_id=?";
                PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
                try {
                    preparedStatement.setLong(1, l);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        long l2 = resultSet.getLong("installed_utc");
                        if (resultSet.wasNull()) {
                            Long l3 = null;
                            return l3;
                        }
                        Long l4 = new Long(l2);
                        return l4;
                    }
                    try {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote server with id = {0} not found.", (Object[])new Object[]{l}));
                    }
                    catch (SQLException sQLException) {
                        String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the installed date/time for remote server {0}.", (Object[])new Object[]{this.getServerName(l)});
                        throw new ResourceUnavailableException(string2, (Throwable)sQLException);
                    }
                }
                finally {
                    this.closeConnection(preparedStatement);
                }
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: ", (Object[])new Object[0]));
    }

    public RemoteServer getServer(long l) throws ResourceUnavailableException {
        RemoteServerType remoteServerType;
        try {
            remoteServerType = this.getServerType(l);
        }
        catch (NoDataException noDataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote server with id = {0} not found.", (Object[])new Object[]{l}));
        }
        switch (remoteServerType) {
            case SCHEDULE: {
                return this.getScheduleServer(l);
            }
            case SKYBOT: {
                return this.getSkybotServer(l);
            }
        }
        return this.getGenericServer(l);
    }

    public long getServerID(long l, RemoteServerType remoteServerType) throws NoDataException, ResourceUnavailableException {
        String string;
        String string2;
        switch (remoteServerType) {
            case SKYBOT: {
                string2 = "SELECT remote_server_id FROM " + this.remoteSkybotServersTable + " WHERE registered_utc=?";
                string = "registered_utc";
                break;
            }
            case SCHEDULE: {
                string2 = "SELECT remote_server_id FROM " + this.remoteScheduleServersTable + " WHERE installed_utc=?";
                string = "installed_utc";
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("remote_server_id");
                return l2;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Remote server with {0} = {1} not found.", (Object[])new Object[]{string, l}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the server ID of the remote server with {0} = {1}.", (Object[])new Object[]{string, l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerName(long l) {
        PreparedStatement preparedStatement;
        String string = "SELECT name FROM " + this.remoteServersTable + " WHERE id=?";
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return MessageUtil.formatMsg((String)"Remote Server (id={0})", (Object[])new Object[]{l});
        }
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("name"));
                return string2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return MessageUtil.formatMsg((String)"Remote Server (id={0})", (Object[])new Object[]{l});
    }

    public RemoteServerType getServerType(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT server_type FROM " + this.remoteServersTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                RemoteServerType remoteServerType = RemoteServerType.persistanceCodeToEnum((int)resultSet.getInt("server_type"));
                return remoteServerType;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Remote server with id = {0} not found.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the server type for the remote server with id={0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RemoteServer> getRemoteServersThatConnectToUs_AndAreInFailedStatus() throws ResourceUnavailableException {
        ArrayList<RemoteServer> arrayList = new ArrayList<RemoteServer>();
        RemoteServerGenerator remoteServerGenerator = new RemoteServerGenerator();
        String string = "SELECT rs.id, name, description, server_type from " + this.remoteServersTable + " rs JOIN " + this.remoteSkybotServersTable + " rss ON rs.id = rss.remote_server_id " + "WHERE server_type=? AND created_by_remote_server=? AND status=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, RemoteServerType.SKYBOT.persistanceCode());
            preparedStatement.setBoolean(2, true);
            preparedStatement.setInt(3, RemoteServerStatus.FAILED.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    arrayList.add((RemoteServer)remoteServerGenerator.generateObject(resultSet));
                }
                catch (BadDataException badDataException) {
                    String string2 = this.constructBadDataDetails(badDataException.getErrorList());
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Corrupt data for remote server.{0}", (Object[])new Object[]{string2}), badDataException);
                    return arrayList;
                }
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving the list of remote Automate servers that initiate the connection to us and are in Failed status.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public long[] getRemoteServersThatRequireNotificationMonitoring() throws ResourceUnavailableException {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT DISTINCT rs.id AS id FROM (" + this.dependenciesTable + " d JOIN " + this.remoteEventsTable + " re ON re.id = d.prereq_object_id) JOIN " + this.remoteServersTable + " rs ON rs.id = re.remote_server_id " + "WHERE d.prereq_type=? AND rs.server_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, PrereqEventType.REMOTE_EVENT.persistanceCode());
            preparedStatement.setInt(2, RemoteServerType.SCHEDULE.persistanceCode());
            object = preparedStatement.executeQuery();
            while (object.next()) {
                arrayList.add(object.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving the list of remote servers that require notification monitoring.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        object = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            object[n++] = l;
        }
        return object;
    }

    public long[] getRemoteServersThatWeInitiateConnectionTo() throws ResourceUnavailableException {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT rs.id from " + this.remoteServersTable + " rs JOIN " + this.remoteSkybotServersTable + " rss ON rs.id = rss.remote_server_id " + "WHERE server_type=? AND created_by_remote_server=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, RemoteServerType.SKYBOT.persistanceCode());
            preparedStatement.setBoolean(2, false);
            object = preparedStatement.executeQuery();
            while (object.next()) {
                arrayList.add(object.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving the list of remote Automate servers that we initiate connection to.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        object = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            object[n++] = l;
        }
        return object;
    }

    public void recordApproval(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteSkybotServersTable + " SET status=? WHERE remote_server_id=? AND (status=? OR status=?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, RemoteServerStatus.ACTIVE.persistanceCode());
            preparedStatement.setLong(2, l);
            preparedStatement.setInt(3, RemoteServerStatus.APPROVAL_REQUIRED.persistanceCode());
            preparedStatement.setInt(4, RemoteServerStatus.PENDING_REMOTE_APPROVAL.persistanceCode());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to record the approval status for remote server {0}.", (Object[])new Object[]{this.getServerName(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void recordInstalledDateTime(long l, long l2) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteScheduleServersTable + " SET installed_utc=? WHERE remote_server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to record the installed date/time (utc={0}) for remote server {1} in the database, but no records were updated.", (Object[])new Object[]{l2, this.getServerName(l)}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to record the installed date/time (utc={0}) for remote server {1}.", (Object[])new Object[]{l2, this.getServerName(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void recordRegistrationInfo(long l, long l2, long l3) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteSkybotServersTable + " SET registered_utc=?, assigned_remote_id=?, status=? WHERE remote_server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l3);
            preparedStatement.setInt(3, RemoteServerStatus.PENDING_REMOTE_APPROVAL.persistanceCode());
            preparedStatement.setLong(4, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to record the registration information for remote server {0} in the database, but no records were updated.", (Object[])new Object[]{this.getServerName(l)}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to record the registration information for remote server {0} in the database.", (Object[])new Object[]{this.getServerName(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void setConnectedStateToActive(long l) throws ResourceUnavailableException {
        this.updateConnectedState(l, RemoteServerStatus.ACTIVE);
    }

    public void setConnectedStateToFailed(long l) throws ResourceUnavailableException {
        this.updateConnectedState(l, RemoteServerStatus.FAILED);
    }

    public void toggleAllActiveToFailed() throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteSkybotServersTable + " SET status=? WHERE status=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, RemoteServerStatus.FAILED.persistanceCode());
            preparedStatement.setInt(2, RemoteServerStatus.ACTIVE.persistanceCode());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while trying to set the status of all Automate type Remote Servers in ACTIVE status to FAILED.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void updateHardwareInfo(long l, String string, String string2) throws ResourceUnavailableException {
        String string3 = "UPDATE " + this.remoteSkybotServersTable + " SET hardware_hash=?, instance_identifier=? WHERE remote_server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to update the hardware information for remote server {0} in the database, but no records were updated.", (Object[])new Object[]{this.getServerName(l)}));
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while trying to update the hardware information for remote server {0}.", (Object[])new Object[]{this.getServerName(l)});
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    private RemoteServer getGenericServer(long var1_1) throws ResourceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private RemoteScheduleServer getScheduleServer(long var1_1) throws ResourceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private RemoteSkybotServer getSkybotServer(long var1_1) throws ResourceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateConnectedState(long l, RemoteServerStatus remoteServerStatus) throws ResourceUnavailableException {
        int n;
        int n2;
        switch (remoteServerStatus) {
            case ACTIVE: {
                n2 = RemoteServerStatus.ACTIVE.persistanceCode();
                n = RemoteServerStatus.FAILED.persistanceCode();
                break;
            }
            case FAILED: {
                n2 = RemoteServerStatus.FAILED.persistanceCode();
                n = RemoteServerStatus.ACTIVE.persistanceCode();
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Status {0} is not supported by this method.", (Object[])new Object[]{remoteServerStatus}));
            }
        }
        String string = "UPDATE " + this.remoteSkybotServersTable + " SET status=? WHERE remote_server_id=? AND status=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n2);
            preparedStatement.setLong(2, l);
            preparedStatement.setInt(3, n);
            int n3 = preparedStatement.executeUpdate();
            if (n3 > 0) {
                logger.debug((Object)MessageUtil.formatMsg((String)"Remote server {0} status was changed to {1}.", (Object[])new Object[]{this.getServerName(l), remoteServerStatus}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to update the connected state for remote server {0}.", (Object[])new Object[]{this.getServerName(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class RemoteSkybotServerGenerator
    extends AbstractBusObjGenerator {
        public RemoteSkybotServerGenerator() {
            super(9, "RemoteSkybotServer");
        }

        protected Object constructObject() {
            return new RemoteSkybotServer();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            RemoteSkybotServer remoteSkybotServer = (RemoteSkybotServer)object;
            switch (n) {
                case 1: {
                    RemoteServer remoteServer;
                    try {
                        remoteServer = (RemoteServer)new RemoteServerGenerator().generateObject(resultSet);
                    }
                    catch (BadDataException badDataException) {
                        String string = RemoteServersDMJdbc.this.constructBadDataDetails(badDataException.getErrorList());
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Corrupt data for remote server {0}.{1}", (Object[])new Object[]{RemoteServersDMJdbc.this.getServerName(resultSet.getLong("id")), string}), badDataException);
                    }
                    remoteSkybotServer.setId(remoteServer.getId());
                    remoteSkybotServer.setName(remoteServer.getName());
                    remoteSkybotServer.setDescription(remoteServer.getDescription());
                    remoteSkybotServer.setType(remoteServer.getType());
                    break;
                }
                case 2: {
                    remoteSkybotServer.setAssignedRemoteID((long)resultSet.getInt("assigned_remote_id"));
                    break;
                }
                case 3: {
                    remoteSkybotServer.setCreatedByRemoteServer(resultSet.getBoolean("created_by_remote_server"));
                    break;
                }
                case 4: {
                    remoteSkybotServer.setHardwareHash(Convert.trimR((String)resultSet.getString("hardware_hash")));
                    break;
                }
                case 5: {
                    remoteSkybotServer.setInstanceIdentifier(Convert.trimR((String)resultSet.getString("instance_identifier")));
                    break;
                }
                case 6: {
                    remoteSkybotServer.setRegistered_utc(resultSet.getLong("registered_utc"));
                    break;
                }
                case 7: {
                    remoteSkybotServer.setStatus(RemoteServerStatus.persistanceCodeToEnum((int)resultSet.getInt("status")));
                    break;
                }
                case 8: {
                    remoteSkybotServer.setIpAddress(Convert.trimR((String)resultSet.getString("ip_address")));
                    break;
                }
                case 9: {
                    remoteSkybotServer.setListenPort(resultSet.getInt("port_number"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class RemoteScheduleServerGenerator
    extends AbstractBusObjGenerator {
        public RemoteScheduleServerGenerator() {
            super(8, "RemoteScheduleServer");
        }

        protected Object constructObject() {
            return new RemoteScheduleServer();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)object;
            switch (n) {
                case 1: {
                    RemoteServer remoteServer;
                    try {
                        remoteServer = (RemoteServer)new RemoteServerGenerator().generateObject(resultSet);
                    }
                    catch (BadDataException badDataException) {
                        String string = RemoteServersDMJdbc.this.constructBadDataDetails(badDataException.getErrorList());
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Corrupt data for remote server {0}.{1}", (Object[])new Object[]{RemoteServersDMJdbc.this.getServerName(resultSet.getLong("id")), string}), badDataException);
                    }
                    remoteScheduleServer.setId(remoteServer.getId());
                    remoteScheduleServer.setName(remoteServer.getName());
                    remoteScheduleServer.setDescription(remoteServer.getDescription());
                    remoteScheduleServer.setType(remoteServer.getType());
                    break;
                }
                case 2: {
                    remoteScheduleServer.setSystemName(Convert.trimR((String)resultSet.getString("system_name")));
                    break;
                }
                case 3: {
                    remoteScheduleServer.setUser(Convert.trimR((String)resultSet.getString("user_name")));
                    break;
                }
                case 4: {
                    String string = Convert.trimR((String)resultSet.getString("encrypted_password"));
                    String string2 = Convert.trimR((String)resultSet.getString("password_salt"));
                    string = UnacodeMash.unMash((String)string);
                    string = string.replaceAll(string2, "");
                    remoteScheduleServer.setPwd(string);
                    break;
                }
                case 5: {
                    String string = Convert.trimR((String)resultSet.getString("library"));
                    if (string.isEmpty()) {
                        string = "ROBOTLIB";
                    }
                    remoteScheduleServer.setLibrary(string);
                    break;
                }
                case 6: {
                    remoteScheduleServer.setAspGroup(Convert.trimR((String)resultSet.getString("asp_group")));
                    break;
                }
                case 7: {
                    remoteScheduleServer.setRelationalDatabaseName(Convert.trimR((String)resultSet.getString("relational_db_name")));
                    break;
                }
                case 8: {
                    remoteScheduleServer.setInstalledDateTime(resultSet.getLong("installed_utc"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class RemoteServerGenerator
    extends AbstractBusObjGenerator {
        public RemoteServerGenerator() {
            super(4, "RemoteServer");
        }

        protected Object constructObject() {
            return new RemoteServer();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            RemoteServer remoteServer = (RemoteServer)object;
            switch (n) {
                case 1: {
                    remoteServer.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    remoteServer.setName(Convert.trimR((String)resultSet.getString("name")));
                    break;
                }
                case 3: {
                    remoteServer.setDescription(Convert.trimR((String)resultSet.getString("description")));
                    break;
                }
                case 4: {
                    remoteServer.setType(RemoteServerType.persistanceCodeToEnum((int)resultSet.getInt("server_type")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

