/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.busobj.SendStatusEventType;
import com.helpsystems.enterprise.core.busobj.UnknownEnumException;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyProxy;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerAM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class RemoteServerNotifier
implements Runnable {
    private static final Logger logger = Logger.getLogger(RemoteServerNotifier.class);
    private Object waitLock = new Object();
    private boolean sleeping;
    private boolean newArrival;
    private boolean aReconnectDelayTimerExpired;
    private Object startLock = new Object();
    private Thread notifierThread;
    private Map<Long, ServerInfo> serverInfoMap = new HashMap<Long, ServerInfo>();
    private ThreadPoolExecutor reconnectDelayExecutor;
    private long lastJobStatusChangeIDThatNoOneCaredAbout;
    private boolean shutdown;
    private boolean robotScheduleInterfaceLicensed;
    private RemoteDependencyDM remoteDependencyDM = (RemoteDependencyDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteDependencyDM");
    private RemoteServerAM remoteServerAM = (RemoteServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServerAM");
    private RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");

    public RemoteServerNotifier() {
        this.startProcessingAnyBackloggedEvents();
    }

    public void notifyOfAgentEvent(AgentEventHistoryInfo agentEventHistoryInfo) {
        try {
            RemoteDependencyProxy[] remoteDependencyProxyArray;
            ValidationHelper.checkForNull((String)"Agent Event History Info", (Object)agentEventHistoryInfo);
            for (RemoteDependencyProxy remoteDependencyProxy : remoteDependencyProxyArray = this.remoteDependencyDM.getDependentRemoteServers(agentEventHistoryInfo.getEventOID(), PrereqEventType.AGENT_EVENT)) {
                String string = this.getServerName(remoteDependencyProxy.getRemoteServerID());
                this.remoteDependencyDM.generateNotificationEvent(agentEventHistoryInfo, remoteDependencyProxy, string);
                this.notifyOfNewArrival();
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to notify any remote servers of the agent event with history ID {0}.", (Object[])new Object[]{agentEventHistoryInfo.getOID()}), (Throwable)exception);
        }
    }

    public void notifyOfJobMonitorEvent(JobMonitorEvent jobMonitorEvent) {
        try {
            RemoteDependencyProxy[] remoteDependencyProxyArray;
            ValidationHelper.checkForNull((String)"Job Monitor Event", (Object)jobMonitorEvent);
            PrereqEventType prereqEventType = jobMonitorEvent.determinePrereqEventType();
            for (RemoteDependencyProxy remoteDependencyProxy : remoteDependencyProxyArray = this.remoteDependencyDM.getDependentRemoteServers(jobMonitorEvent.getJobID(), prereqEventType)) {
                String string = this.getServerName(remoteDependencyProxy.getRemoteServerID());
                this.remoteDependencyDM.generateNotificationEvent(jobMonitorEvent, remoteDependencyProxy, string);
                this.notifyOfNewArrival();
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to notify any remote servers of the job monitor event with history ID {0}.", (Object[])new Object[]{jobMonitorEvent.getID()}), (Throwable)exception);
        }
    }

    public void notifyOfJobStatusChange(JobHistory jobHistory) {
        try {
            ValidationHelper.checkForNull((String)"Job History", (Object)jobHistory);
            if (jobHistory.getId() == this.lastJobStatusChangeIDThatNoOneCaredAbout) {
                return;
            }
            PrereqEventType prereqEventType = PrereqEventType.JOB_STATUS_CHANGE;
            long l = jobHistory.getJobID();
            if (jobHistory.isJobSuiteMember()) {
                prereqEventType = PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE;
                l = jobHistory.getJobSuiteMemberID();
            } else if (jobHistory.isJobSuite()) {
                prereqEventType = PrereqEventType.JOB_SUITE_STATUS_CHANGE;
            }
            RemoteDependencyProxy[] remoteDependencyProxyArray = this.remoteDependencyDM.getDependentRemoteServers(l, prereqEventType);
            if (remoteDependencyProxyArray.length > 0) {
                for (RemoteDependencyProxy remoteDependencyProxy : remoteDependencyProxyArray) {
                    long l2 = remoteDependencyProxy.getRemoteServerID();
                    RemoteServer remoteServer = this.remoteServersDM.getServer(l2);
                    RemoteServerType remoteServerType = remoteServer.getType();
                    boolean bl = false;
                    if (this.isStatusNotifiable(jobHistory.getStatusCode(), remoteServerType)) {
                        switch (remoteServerType) {
                            case SKYBOT: {
                                bl = true;
                                break;
                            }
                            case SCHEDULE: {
                                if (!this.isValidLicense(l2)) break;
                                bl = true;
                                break;
                            }
                            default: {
                                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
                            }
                        }
                    }
                    if (!bl) continue;
                    this.remoteDependencyDM.generateNotificationEvent(jobHistory, remoteDependencyProxy, remoteServer.getName(), remoteServerType);
                    this.notifyOfNewArrival();
                }
            } else {
                this.lastJobStatusChangeIDThatNoOneCaredAbout = jobHistory.getId();
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to notify any remote servers of the status change to {0} for {1} (run ID = {2}).", (Object[])new Object[]{jobHistory.getStatusCode(), this.toString(jobHistory), jobHistory.getId()}), (Throwable)exception);
        }
    }

    public void notifyOfStatusChange(SendStatusEvent sendStatusEvent) {
        try {
            ValidationHelper.checkForNull((String)"Send Status Event", (Object)sendStatusEvent);
            PrereqStatusType prereqStatusType = sendStatusEvent.getPrereqStatusType();
            if (sendStatusEvent.getSendStatusEventType() == SendStatusEventType.SEND_OBJECT_EVENT) {
                RemoteDependencyProxy[] remoteDependencyProxyArray;
                for (RemoteDependencyProxy remoteDependencyProxy : remoteDependencyProxyArray = this.remoteDependencyDM.getDependentRemoteServers(sendStatusEvent.getPrereqObjectID(), sendStatusEvent.getPrereqEventType())) {
                    long l = remoteDependencyProxy.getRemoteServerID();
                    RemoteServer remoteServer = this.remoteServersDM.getServer(l);
                    RemoteServerType remoteServerType = remoteServer.getType();
                    boolean bl = false;
                    if (this.isStatusNotifiable(prereqStatusType, remoteServerType)) {
                        switch (remoteServerType) {
                            case SKYBOT: {
                                bl = true;
                                break;
                            }
                            case SCHEDULE: {
                                PrereqEventType prereqEventType = sendStatusEvent.getPrereqEventType();
                                if (prereqEventType != PrereqEventType.JOB_STATUS_CHANGE && prereqEventType != PrereqEventType.JOB_SUITE_STATUS_CHANGE && prereqEventType != PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE || !this.isValidLicense(l)) break;
                                bl = true;
                                break;
                            }
                            default: {
                                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
                            }
                        }
                    }
                    if (!bl) continue;
                    this.remoteDependencyDM.generateNotificationEvent(sendStatusEvent, remoteDependencyProxy, remoteServer.getName(), remoteServerType);
                    this.notifyOfNewArrival();
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to notify any remote servers of the following status event. {0}.", (Object[])new Object[]{this.toString(sendStatusEvent)}), (Throwable)exception);
        }
    }

    @Override
    public void run() {
        logger.info((Object)"The Remote Server Notifier has been started.");
        this.mainLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        try {
            do {
                if (!this.shutdown) {
                    this.process();
                }
                Object object = this.waitLock;
                synchronized (object) {
                    while (!(this.newArrival || this.aReconnectDelayTimerExpired || this.shutdown)) {
                        this.sleeping = true;
                        try {
                            this.waitLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.sleeping = false;
                    }
                    this.newArrival = false;
                    this.aReconnectDelayTimerExpired = false;
                }
            } while (!this.shutdown);
            this.cleanup();
        }
        catch (Throwable throwable) {
            try {
                logger.fatal((Object)"The Remote Server Notifier thread is shutting down, due to an error. ", throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cancelTheNotification(RemoteDependencyNotification remoteDependencyNotification) throws ResourceUnavailableException {
        this.remoteDependencyDM.markNotificationAsCanceled(remoteDependencyNotification.getNotificationHistoryID());
        this.remoteDependencyDM.deleteNotificationEvent(remoteDependencyNotification.getId());
    }

    private void cleanup() {
    }

    private void failTheConnection(long l) {
        try {
            this.startTheReconnectDelayTask(l);
        }
        catch (Exception exception) {
            try {
                logger.info((Object)MessageUtil.formatMsg((String)"An error occurred while trying to start a timer task whose purpose is to slow down the notifications to remote server with ID {0}.", (Object[])new Object[]{l}), (Throwable)exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private ServerInfo getServerInfo(long l) {
        ServerInfo serverInfo = this.serverInfoMap.get(l);
        if (serverInfo == null) {
            serverInfo = new ServerInfo();
            this.serverInfoMap.put(l, serverInfo);
        }
        return serverInfo;
    }

    private String getServerName(long l) {
        return this.remoteServersDM.getServerName(l);
    }

    private void handleBackLevelServer(RemoteDependencyNotification remoteDependencyNotification, UnknownEnumException unknownEnumException) {
        String string;
        String string2;
        long l = remoteDependencyNotification.getServerID();
        try {
            this.cancelTheNotification(remoteDependencyNotification);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.failTheConnection(l);
            logger.warn((Object)MessageUtil.formatMsg((String)"There was a problem while trying to cancel the notification of event {0} to remote server {1}.", (Object[])new Object[]{remoteDependencyNotification, this.getServerName(l)}), (Throwable)resourceUnavailableException);
        }
        String string3 = unknownEnumException.getEnumTypeName();
        if (string3.equals("PrereqEventType")) {
            string2 = "event type";
            string = remoteDependencyNotification.getEventType().toString();
        } else if (string3.equals("PrereqStatusType")) {
            string2 = "status";
            string = remoteDependencyNotification.getEventStatus().toString();
        } else if (string3.equals("PrereqEventSource")) {
            string2 = "event source";
            string = remoteDependencyNotification.getEventSourceInfo().toString();
        } else {
            string2 = string3;
            string = MessageUtil.formatMsg((String)"code {0}", (Object[])new Object[]{unknownEnumException.getUnknownCode()});
        }
        logger.info((Object)MessageUtil.formatMsg((String)"Server {0} has reported that it did not process event {1} because it did not recognize {2} {3}. Most likely this is because this server is at a higher version level.", (Object[])new Object[]{this.getServerName(l), remoteDependencyNotification, string2, string}));
    }

    private boolean isRobotScheduleInterfaceLicensed() {
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM;
        try {
            enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to validate the Robot SCHEDULE interface license. Error retrieving the Action Manager.", (Throwable)exception);
            return false;
        }
        try {
            EnterpriseLicenseInfo enterpriseLicenseInfo = enterpriseLicenseInfoAM.getLicenseInfo();
            if (enterpriseLicenseInfo.isValidTrialLicense()) {
                return true;
            }
            EnterpriseProductLicense enterpriseProductLicense = enterpriseLicenseInfo.getPrimaryLicense();
            return enterpriseProductLicense != null && enterpriseProductLicense.isRobotScheduleInterfaceEnabled();
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to validate the Robot SCHEDULE interface license, due to an error.", (Throwable)exception);
            return false;
        }
    }

    private boolean isStatusNotifiable(JobStatusCode jobStatusCode, RemoteServerType remoteServerType) {
        switch (remoteServerType) {
            case SKYBOT: {
                switch (jobStatusCode) {
                    case SUBMITTED: 
                    case RUNNING: 
                    case COMPLETED: 
                    case FAILED: 
                    case CANCELED: 
                    case SKIPPED: 
                    case CONDITION_RETRY_WAIT: {
                        return true;
                    }
                }
                return false;
            }
            case SCHEDULE: {
                switch (jobStatusCode) {
                    case SUBMITTED: 
                    case RUNNING: 
                    case COMPLETED: 
                    case FAILED: 
                    case SKIPPED: {
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
    }

    private boolean isStatusNotifiable(PrereqStatusType prereqStatusType, RemoteServerType remoteServerType) {
        switch (remoteServerType) {
            case SKYBOT: {
                switch (prereqStatusType) {
                    case SUBMITTED: 
                    case RUNNING: 
                    case COMPLETED: 
                    case FAILED: 
                    case CANCELED: 
                    case SKIPPED: 
                    case CONDITION_RETRY_WAIT: 
                    case BLANK: 
                    case OCCURRED: 
                    case LATE_START: 
                    case OVER_RUN: 
                    case UNDER_RUN: {
                        return true;
                    }
                }
                return false;
            }
            case SCHEDULE: {
                switch (prereqStatusType) {
                    case SUBMITTED: 
                    case RUNNING: 
                    case COMPLETED: 
                    case FAILED: 
                    case SKIPPED: 
                    case BLANK: {
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
    }

    private boolean isValidLicense(long l) {
        if (!this.robotScheduleInterfaceLicensed) {
            this.robotScheduleInterfaceLicensed = this.isRobotScheduleInterfaceLicensed();
        }
        return this.robotScheduleInterfaceLicensed;
    }

    private void process() throws ResourceUnavailableException {
        this.setBypassConnectionFlags();
        List list = this.remoteDependencyDM.getNotificationEvents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !this.shutdown) {
            this.processEntry((RemoteDependencyNotification)iterator.next());
        }
    }

    private void processEntry(RemoteDependencyNotification remoteDependencyNotification) {
        if (remoteDependencyNotification == null) {
            throw new IllegalArgumentException("Trying to process a remote server dependency event notification, but the notification information is missing.");
        }
        long l = remoteDependencyNotification.getServerID();
        try {
            ServerInfo serverInfo = this.getServerInfo(l);
            if (serverInfo.bypassConnectionAttempt) {
                return;
            }
            logger.debug((Object)("Processing notification entry: " + remoteDependencyNotification));
            long l2 = this.remoteServerAM.notifyOfEvent(remoteDependencyNotification);
            if (l2 < 0L) {
                this.cancelTheNotification(remoteDependencyNotification);
                this.removeTheDependency(remoteDependencyNotification.getRemoteDependencyID());
            } else {
                this.remoteDependencyDM.markNotificationAsReceived(remoteDependencyNotification.getNotificationHistoryID(), l2);
                this.remoteDependencyDM.deleteNotificationEvent(remoteDependencyNotification.getId());
            }
        }
        catch (UnknownEnumException unknownEnumException) {
            this.handleBackLevelServer(remoteDependencyNotification, unknownEnumException);
        }
        catch (Exception exception) {
            this.failTheConnection(l);
            try {
                logger.warn((Object)MessageUtil.formatMsg((String)"There was a problem while trying to notify remote server {0} of event {1}. Another attempt will be made in a few minutes.", (Object[])new Object[]{this.getServerName(remoteDependencyNotification.getServerID()), remoteDependencyNotification}), (Throwable)exception);
            }
            catch (Exception exception2) {
                logger.error((Object)"There was a problem while trying to notify a remote server.", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOfNewArrival() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.notifierThread == null || !this.notifierThread.isAlive()) {
                this.startTheNotifierThread();
            }
        }
        object = this.waitLock;
        synchronized (object) {
            this.newArrival = true;
            if (this.sleeping) {
                this.waitLock.notify();
            }
        }
    }

    private void removeTheDependency(long l) throws ResourceUnavailableException {
        this.remoteDependencyDM.deleteRemoteDependency(l);
    }

    private void setBypassConnectionFlags() {
        for (Map.Entry<Long, ServerInfo> entry : this.serverInfoMap.entrySet()) {
            ServerInfo serverInfo = entry.getValue();
            serverInfo.bypassConnectionAttempt = serverInfo.reconnectDelayActive;
        }
    }

    private void startProcessingAnyBackloggedEvents() {
        try {
            if (this.remoteDependencyDM.getNotificationEventCount() > 0) {
                logger.info((Object)"Processing the backlog of notifications to remote servers.");
                this.startTheNotifierThread();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to start the remote server notifier to process the backlogged events.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTheNotifierThread() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.notifierThread != null && this.notifierThread.isAlive()) {
                throw new IllegalStateException("Program error: Attempting to start the Remote Server Notifier thread, but it has already been started.");
            }
            String string = "Remote Server Notifier";
            this.notifierThread = new Thread((Runnable)this, string);
            this.notifierThread.start();
        }
    }

    private void startTheReconnectDelayTask(long l) {
        if (this.reconnectDelayExecutor == null) {
            int n = 20;
            this.reconnectDelayExecutor = new ThreadPoolExecutor(0, n, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory(), new DiscardPolicy());
        }
        this.reconnectDelayExecutor.execute(new ReconnectDelayTask(l));
    }

    private String toString(JobHistory jobHistory) {
        String string = "";
        try {
            if (jobHistory != null) {
                string = MessageUtil.formatMsg((String)"Job {0}", (Object[])new Object[]{jobHistory.getJobName()});
                if (jobHistory.isJobSuiteMember()) {
                    string = MessageUtil.formatMsg((String)"Member {0} in Suite {1}", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getJobSuiteName()});
                } else if (jobHistory.isJobSuite()) {
                    string = MessageUtil.formatMsg((String)"Suite {0}", (Object[])new Object[]{jobHistory.getJobName()});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String toString(SendStatusEvent sendStatusEvent) {
        String string = "";
        try {
            if (sendStatusEvent != null) {
                string = MessageUtil.formatMsg((String)"Object status {0} for event type {1} was sent by {2} for object ID {3}", (Object[])new Object[]{sendStatusEvent.getPrereqStatusType(), sendStatusEvent.getPrereqEventType(), sendStatusEvent.getUser(), sendStatusEvent.getPrereqObjectID()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private class DiscardPolicy
    implements RejectedExecutionHandler {
        private DiscardPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            try {
                if (runnable instanceof ReconnectDelayTask) {
                    long l = ((ReconnectDelayTask)runnable).serverID;
                    logger.warn((Object)MessageUtil.formatMsg((String)"An attempt to start a ReconnectDelayTask for the remote server with ID {0} was rejected.", (Object[])new Object[]{l}));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        private CustomThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "Remote server reconnect delay - thread ";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String string = this.namePrefix + this.threadNumber.getAndIncrement();
            Thread thread = new Thread(this.group, runnable, string, 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private class ReconnectDelayTask
    implements Runnable {
        private long serverID;

        private ReconnectDelayTask(long l) {
            this.serverID = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.setBypassConnectionAttemptFlag();
                this.setReconnectDelayFlag(true);
                Thread.sleep(180000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setReconnectDelayFlag(false);
            Object object = RemoteServerNotifier.this.waitLock;
            synchronized (object) {
                RemoteServerNotifier.this.aReconnectDelayTimerExpired = true;
                RemoteServerNotifier.this.waitLock.notify();
            }
        }

        private void setBypassConnectionAttemptFlag() {
            ServerInfo serverInfo = RemoteServerNotifier.this.getServerInfo(this.serverID);
            serverInfo.bypassConnectionAttempt = true;
        }

        private void setReconnectDelayFlag(boolean bl) {
            ServerInfo serverInfo = RemoteServerNotifier.this.getServerInfo(this.serverID);
            serverInfo.reconnectDelayActive = bl;
        }
    }

    private class ServerInfo {
        private volatile boolean bypassConnectionAttempt;
        private volatile boolean reconnectDelayActive;

        private ServerInfo() {
        }
    }
}

