/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.busobj.OS400Object;
import com.helpsystems.common.as400.busobj.OS400ObjectListFilter;
import com.helpsystems.common.as400.busobj.QUSRJOBI_Job;
import com.helpsystems.common.as400.util.OS400ObjectListInformation;
import com.helpsystems.common.as400.util.OS400ObjectListParameters;
import com.helpsystems.common.as400.util.QUSRJOBI_API;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OS400ObjectListAPI {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400ObjectListAPI.class);
    private static final Logger logger = Logger.getLogger(OS400ObjectListAPI.class);
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private AS400 as400;
    private final int ccsid;
    public static final int SO_SELECT = 0;
    public static final int SO_OMIT = 1;
    public static final int FLD_ATTR = 202;
    public static final int FLD_TEXT = 203;
    public static final int FLD_ASP = 301;
    public static final int FLD_ASPDEV = 605;

    public OS400ObjectListAPI(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
    }

    public OS400Object[] runAPI(OS400ObjectListFilter oS400ObjectListFilter) {
        if (oS400ObjectListFilter == null) {
            throw new NullPointerException(rbh.getText("object_list_filter_is_null"));
        }
        if (oS400ObjectListFilter.getLibrary().equals("*ALL") && oS400ObjectListFilter.getObject().equals("*ALL") && oS400ObjectListFilter.getType().equals("*ALL")) {
            throw new IllegalArgumentException(rbh.getText("library_object_and_type_filter_value_cannot_all_be_all"));
        }
        OS400ObjectListParameters oS400ObjectListParameters = new OS400ObjectListParameters(this.as400);
        ProgramParameter[] programParameterArray = oS400ObjectListParameters.getParms(oS400ObjectListFilter);
        boolean bl = false;
        QUSRJOBI_Job qUSRJOBI_Job = null;
        try {
            Object object;
            try {
                if (oS400ObjectListFilter.getASPFilterType().equals("*ASPGRP") && oS400ObjectListFilter.isIncludeSysbas()) {
                    object = new QUSRJOBI_API(this.as400);
                    qUSRJOBI_Job = ((QUSRJOBI_API)object).runAPI();
                    Object object2 = new CommandCall(this.as400);
                    String string = "SETASPGRP ASPGRP(" + oS400ObjectListFilter.getASPFilterDevice() + ")";
                    AbstractAS400Manager.runCommand(string, object2);
                    bl = true;
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"Error setting ASP Group.", (Throwable)exception);
            }
            object = this.callQGYOLOBJ(programParameterArray);
            return object;
        }
        catch (AS400Exception aS400Exception) {
            String string = rbh.getText("object_list_failed");
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new RuntimeException(string, aS400Exception);
        }
        finally {
            if (bl && qUSRJOBI_Job != null && qUSRJOBI_Job.getAspGroup().length() > 0) {
                String string = "SETASPGRP ASPGRP(" + qUSRJOBI_Job.getAspGroup() + ")";
                try {
                    CommandCall commandCall = new CommandCall(this.as400);
                    AbstractAS400Manager.runCommand(string, commandCall);
                }
                catch (Exception exception) {
                    logger.debug((Object)("Error resetting ASP Group: " + string), (Throwable)exception);
                }
            }
        }
    }

    private OS400Object[] callQGYOLOBJ(ProgramParameter[] programParameterArray) throws AS400Exception {
        ArrayList<OS400Object> arrayList = new ArrayList<OS400Object>();
        OS400Object[] oS400ObjectArray = new OS400Object[]{};
        ProgramCall programCall = new ProgramCall(this.as400, "/QSYS.LIB/QGY.LIB/QGYOLOBJ.PGM", programParameterArray);
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            String string = rbh.getText("error_opening_object_list");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        if (!bl) {
            logger.debug((Object)"QGYOLOBJ call failed.");
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                logger.debug((Object)(" ** " + aS400MessageArray[i].getID() + " ** " + aS400MessageArray[i].getText()));
            }
            throw new AS400Exception(aS400MessageArray);
        }
        OS400ObjectListInformation oS400ObjectListInformation = this.getOpenListInfo(this.as400, programParameterArray[2].getOutputData(), programParameterArray[0].getOutputData());
        if (oS400ObjectListInformation.getTotalRecords() < 1) {
            this.closeIt(this.as400, oS400ObjectListInformation);
            return oS400ObjectArray;
        }
        oS400ObjectListInformation.setFirstRecordNumber(1);
        oS400ObjectListInformation.setRecordsReturned(0);
        do {
            oS400ObjectListInformation = this.getNextListSegment(this.as400, oS400ObjectListInformation);
            this.processList(this.as400, oS400ObjectListInformation, arrayList);
        } while (oS400ObjectListInformation.getTotalRecords() > oS400ObjectListInformation.getFirstRecordNumber() + oS400ObjectListInformation.getRecordsReturned());
        this.closeIt(this.as400, oS400ObjectListInformation);
        oS400ObjectArray = arrayList.toArray(oS400ObjectArray);
        return oS400ObjectArray;
    }

    private void closeIt(AS400 aS400, OS400ObjectListInformation oS400ObjectListInformation) {
        try {
            this.closeOpenList(aS400, oS400ObjectListInformation.getRequestHandle());
        }
        catch (Exception exception) {
            String string = rbh.getText("error_closing_the_object_list");
            logger.debug((Object)string, (Throwable)exception);
        }
    }

    private OS400ObjectListInformation getOpenListInfo(AS400 aS400, byte[] byArray, byte[] byArray2) {
        CharConverter charConverter;
        if (byArray == null) {
            throw new NullPointerException(rbh.getText("the_list_is_null"));
        }
        OS400ObjectListInformation oS400ObjectListInformation = new OS400ObjectListInformation();
        try {
            charConverter = new CharConverter(this.ccsid, aS400);
        }
        catch (Exception exception) {
            String string = rbh.getText("character_converter_error");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        oS400ObjectListInformation.setTotalRecords(BinaryConverter.byteArrayToInt((byte[])byArray, (int)0));
        oS400ObjectListInformation.setRecordsReturned(BinaryConverter.byteArrayToInt((byte[])byArray, (int)4));
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray, 8, byArray3, 0, 4);
        oS400ObjectListInformation.setRequestHandle(byArray3);
        oS400ObjectListInformation.setRecordLength(BinaryConverter.byteArrayToInt((byte[])byArray, (int)12));
        oS400ObjectListInformation.setInfoCompleteIndicator(charConverter.byteArrayToString(byArray, 16, 1));
        oS400ObjectListInformation.setDateReturned(charConverter.byteArrayToString(byArray, 17, 13));
        oS400ObjectListInformation.setListStatus(charConverter.byteArrayToString(byArray, 30, 1));
        oS400ObjectListInformation.setLengthReturned(BinaryConverter.byteArrayToInt((byte[])byArray, (int)32));
        oS400ObjectListInformation.setFirstRecordNumber(BinaryConverter.byteArrayToInt((byte[])byArray, (int)36));
        oS400ObjectListInformation.setListData(byArray2);
        return oS400ObjectListInformation;
    }

    private void processList(AS400 aS400, OS400ObjectListInformation oS400ObjectListInformation, ArrayList<OS400Object> arrayList) {
        if (oS400ObjectListInformation == null) {
            throw new NullPointerException(rbh.getText("open_list_information_is_null"));
        }
        int n = oS400ObjectListInformation.getRecordLength();
        byte[] byArray = oS400ObjectListInformation.getListData();
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < oS400ObjectListInformation.getRecordsReturned(); ++i) {
            System.arraycopy(byArray, i * n, byArray2, 0, n);
            OS400Object oS400Object = this.processRecord(aS400, byArray2);
            arrayList.add(oS400Object);
        }
    }

    private OS400Object processRecord(AS400 aS400, byte[] byArray) {
        CharConverter charConverter;
        try {
            charConverter = new CharConverter(this.ccsid, aS400);
        }
        catch (Exception exception) {
            String string = rbh.getText("character_converted_error2");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        String string = charConverter.byteArrayToString(byArray, 0, 10).trim();
        String string2 = charConverter.byteArrayToString(byArray, 10, 10).trim();
        String string3 = charConverter.byteArrayToString(byArray, 20, 10).trim();
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)32);
        OS400Object oS400Object = new OS400Object();
        oS400Object.setLibrary(string2);
        oS400Object.setObject(string);
        oS400Object.setType(string3);
        int n2 = 36;
        for (int i = 0; i < n; ++i) {
            int n3 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)n2);
            int n4 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)(n2 + 4));
            String string4 = charConverter.byteArrayToString(byArray, n2 + 8, 1).trim();
            int n5 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)(n2 + 12));
            if (string4.equals("B")) {
                int n6 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)(n2 + 16));
                this.setFinderObjectField(n4, n6, oS400Object);
            } else if (string4.equals("C")) {
                String string5 = charConverter.byteArrayToString(byArray, n2 + 16, n5).trim();
                this.setFinderObjectField(n4, string5, oS400Object);
            }
            n2 += n3;
        }
        return oS400Object;
    }

    private void setFinderObjectField(int n, String string, OS400Object oS400Object) {
        switch (n) {
            case 202: {
                oS400Object.setAttribute(string);
                break;
            }
            case 203: {
                oS400Object.setText(string);
                break;
            }
            case 605: {
                oS400Object.setAspDevice(string);
                break;
            }
            default: {
                String string2 = rbh.getText("unknown_string_field") + n + " - " + string;
                logger.debug((Object)string2);
            }
        }
    }

    private void setFinderObjectField(int n, int n2, OS400Object oS400Object) {
        switch (n) {
            case 301: {
                oS400Object.setAsp(n2);
                break;
            }
            default: {
                String string = rbh.getText("unkown_integer_field") + " " + n + " - " + n2;
                logger.debug((Object)string);
            }
        }
    }

    private OS400ObjectListInformation getNextListSegment(AS400 aS400, OS400ObjectListInformation oS400ObjectListInformation) throws AS400Exception {
        int n = 100;
        int n2 = n * oS400ObjectListInformation.getRecordLength();
        int n3 = oS400ObjectListInformation.getFirstRecordNumber() + oS400ObjectListInformation.getRecordsReturned();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(bin4_.toBytes(n2)), new ProgramParameter(oS400ObjectListInformation.getRequestHandle()), new ProgramParameter(80), new ProgramParameter(bin4_.toBytes(n)), new ProgramParameter(bin4_.toBytes(n3)), new ProgramParameter(bin4_.toBytes(0))};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            String string = rbh.getText("error_processing_object_list_segment");
            logger.debug((Object)string);
            throw new RuntimeException(string, exception);
        }
        if (!bl) {
            logger.debug((Object)"QGYGTLE call failed.");
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                logger.debug((Object)(" ** " + aS400MessageArray[i].getID() + " ** " + aS400MessageArray[i].getText()));
            }
            throw new AS400Exception(aS400MessageArray);
        }
        OS400ObjectListInformation oS400ObjectListInformation2 = this.getOpenListInfo(aS400, programParameterArray[3].getOutputData(), programParameterArray[0].getOutputData());
        return oS400ObjectListInformation2;
    }

    private void closeOpenList(AS400 aS400, byte[] byArray) throws AS400Exception {
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray), new ProgramParameter(bin4_.toBytes(0))};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QGY.LIB/QGYCLST.PGM", programParameterArray);
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            String string = rbh.getText("error_closing_object_list");
            logger.debug((Object)string);
            throw new RuntimeException(string, exception);
        }
        if (!bl) {
            logger.debug((Object)"QGYCLST call failed.");
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                logger.debug((Object)(" ** " + aS400MessageArray[i].getID() + " ** " + aS400MessageArray[i].getText()));
            }
            throw new AS400Exception(aS400MessageArray);
        }
    }
}

