/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.reporting;

import com.helpsystems.common.core.reporting.AbstractReportWriter;
import com.helpsystems.common.core.reporting.ReportField;
import com.helpsystems.common.core.reporting.ReportSelectionCriteria;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SCS5256Writer;
import com.ibm.as400.access.SpooledFileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.log4j.Logger;

public class SCSReportWriter
extends AbstractReportWriter {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(SCSReportWriter.class);
    private static final Logger logger = Logger.getLogger(SCSReportWriter.class);
    private String fileName = null;
    private SCS5256Writer scsWriter = null;
    private int cpr = 132;
    private int padding = 2;
    private int maxLines = 68;
    private int overFlowLine = 64;
    private int currentInset = 0;
    private int pageNumber = 1;
    private int linesPrinted = 0;
    private String reportTitle = null;
    private ReportSelectionCriteria[] reportFilters = null;
    private String reportSysName = null;
    private String reportPgmName = null;
    private Date runDate = null;
    private boolean activePVTable = false;
    private String pvHeader = null;
    private int pvHeaderSize = 3;
    private boolean activeTable = false;
    private String tableHeader = null;
    private int tableHeaderSize = 3;
    private String[] tableColumns = null;
    private int[] tableColumnSizes = null;
    private int itInset = 2;
    private boolean activeInnerTable = false;
    private String innerTableHeader = null;
    private int innerTableHeaderSize = 3;
    private String[] innerTableColumns = null;
    private int[] innerTableColumnSizes = null;
    private boolean activeRowText = false;

    public SCSReportWriter(String string, String string2, String string3, int n) {
        this.scsWriter = this.getSCSWriter(null, string, string2, string3);
        this.cpr = n;
        this.fileName = string3;
    }

    public SCSReportWriter(AS400 aS400, String string, String string2, String string3, int n) {
        this.scsWriter = this.getSCSWriter(aS400, string, string2, string3);
        this.cpr = n;
        this.fileName = string3;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void closeReport() {
        if (this.scsWriter != null) {
            try {
                this.scsWriter.flush();
                this.scsWriter.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error closing SCS writer.", exception);
            }
        }
        super.closeReport();
    }

    private SCS5256Writer getSCSWriter(AS400 aS400, String string, String string2, String string3) {
        SCS5256Writer sCS5256Writer;
        float f = 15.0f;
        float f2 = 8.0f;
        float f3 = 132.0f;
        float f4 = 68.0f;
        int n = 64;
        AS400 aS4002 = aS400;
        if (aS4002 == null) {
            aS4002 = new AS400();
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string.trim(), string2.trim(), "OUTQ");
        PrintParameterList printParameterList = new PrintParameterList();
        printParameterList.setParameter(-6, qSYSObjectPathName.getPath());
        printParameterList.setParameter(78, f4);
        printParameterList.setParameter(81, f3);
        printParameterList.setParameter(76, n);
        printParameterList.setParameter(23, f);
        printParameterList.setParameter(64, f2);
        printParameterList.setParameter(104, string3);
        printParameterList.setParameter(116, string3);
        try {
            SpooledFileOutputStream spooledFileOutputStream = new SpooledFileOutputStream(aS4002, printParameterList, null, null);
            int n2 = aS4002.getCcsid();
            if (n2 < 1 || n2 > 65534) {
                logger.debug((Object)("Overriding unexpected ccsid to 37: " + n2));
                n2 = 37;
            } else {
                logger.debug((Object)("Creating spooled file using ccsid: " + n2));
            }
            sCS5256Writer = new SCS5256Writer((OutputStream)spooledFileOutputStream, n2, aS4002);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error opening spooled file writer.", exception);
        }
        return sCS5256Writer;
    }

    public int getCurrentPage() {
        return this.pageNumber;
    }

    public int getNextLine() {
        return this.linesPrinted + 1;
    }

    public void writeHeader(String string, ReportSelectionCriteria[] reportSelectionCriteriaArray, String string2, String string3) throws IOException {
        this.runDate = new Date(System.currentTimeMillis());
        this.reportTitle = string;
        this.reportFilters = reportSelectionCriteriaArray;
        this.reportSysName = string2;
        this.reportPgmName = string3;
        this.writeHeader_internal();
    }

    private void writeHeader_internal() throws IOException {
        String string = rbh.getText("page");
        String string2 = DateTranslator.formatShortDate((Date)this.runDate);
        String string3 = DateTranslator.formatTime((Date)this.runDate);
        StringBuffer stringBuffer = this.getEmptyLine(this.cpr);
        stringBuffer.replace(2, 2 + string2.length(), string2);
        stringBuffer = this.alignCenterInSB(stringBuffer, this.reportTitle);
        stringBuffer.replace(108, 108 + this.reportSysName.length(), this.reportSysName);
        stringBuffer.replace(119, 119 + this.reportPgmName.length(), this.reportPgmName);
        this.write(Convert.trimR((String)stringBuffer.toString()));
        stringBuffer = this.getEmptyLine(this.cpr);
        stringBuffer.replace(2, 2 + string3.length(), string3);
        stringBuffer = this.insertIntoSBLocation(stringBuffer, string, 119, string.length(), 0);
        stringBuffer = this.insertIntoSBLocation(stringBuffer, String.valueOf(this.pageNumber), 124, 5, 2);
        this.write(Convert.trimR((String)stringBuffer.toString()));
        this.write("");
        if (this.reportFilters != null && this.reportFilters.length > 0) {
            this.writeSectionHeading(rbh.getText("selection_criteria"), 0, 3);
            for (int i = 0; i < this.reportFilters.length; ++i) {
                int n = 2;
                int n2 = 34;
                StringBuffer stringBuffer2 = this.getEmptyLine(this.cpr - this.currentInset);
                String string4 = this.addColon(this.reportFilters[i].getLabel());
                stringBuffer2 = this.insertIntoSBLocation(stringBuffer2, string4, n, 30, 0);
                stringBuffer2 = this.insertIntoSBLocation(stringBuffer2, this.reportFilters[i].getValue(), n2, 70, 0);
                this.write(this.getInsetString() + Convert.trimR((String)stringBuffer2.toString()));
            }
            this.write("");
        }
    }

    public void writeFooter() throws IOException {
    }

    public void writePageBreak() throws IOException {
        try {
            this.scsWriter.endPage();
            ++this.pageNumber;
            this.linesPrinted = 0;
            this.writeHeader_internal();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing page break.", exception);
        }
    }

    public void writeBlankLines(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (this.isPageFull()) {
                this.writePageBreak();
                continue;
            }
            this.write("");
        }
    }

    public void writeSectionHeading(String string, int n, int n2) throws IOException {
        if (this.isPageAlmostFull()) {
            this.writePageBreak();
        }
        String string2 = string;
        StringBuffer stringBuffer = this.getEmptyLine(this.cpr - this.currentInset);
        switch (n2) {
            case 1: {
                string2 = string.toUpperCase();
            }
        }
        switch (n) {
            case 1: {
                stringBuffer = this.alignCenterInSB(stringBuffer, string2);
                break;
            }
            case 2: {
                stringBuffer = this.alignRightInSB(stringBuffer, string2);
                break;
            }
            default: {
                stringBuffer = this.alignLeftInSB(stringBuffer, string2);
            }
        }
        this.write(this.getInsetString() + Convert.trimR((String)stringBuffer.toString()));
    }

    public void writeFormattedLine(String string) throws IOException {
        if (this.isPageFull()) {
            this.writePageBreak();
        }
        StringBuffer stringBuffer = this.getEmptyLine(this.cpr - this.currentInset);
        stringBuffer = this.alignLeftInSB(stringBuffer, string);
        this.write(this.getInsetString() + Convert.trimR((String)stringBuffer.toString()));
    }

    public void writePairedValueTable_Start() throws IOException {
        if (this.activePVTable) {
            throw new RuntimeException("A paired value table is already active.");
        }
        if (this.isPageAlmostFull()) {
            this.writePageBreak();
        }
        this.startPairedValueTable();
    }

    public void writePairedValueTable_Start(String string, int n) throws IOException {
        if (this.activePVTable) {
            throw new RuntimeException("A paired value table is already active.");
        }
        if (this.isPageAlmostFull()) {
            this.writePageBreak();
        }
        this.writeSectionHeading(string, 0, n);
        this.startPairedValueTable();
        this.pvHeader = string;
        this.pvHeaderSize = n;
    }

    private void startPairedValueTable() throws IOException {
        this.activePVTable = true;
    }

    public void writePairedValueTable_Entry(String string, String string2, int[] nArray) throws IOException {
        if (!this.activePVTable) {
            throw new RuntimeException("A paired value table must be active.");
        }
        if (nArray == null || nArray.length != 2) {
            throw new RuntimeException("A size array with 2 values must be provided.");
        }
        if (this.isPageFull()) {
            this.writePageBreak();
            if (this.pvHeader != null) {
                this.writeSectionHeading(this.pvHeader, 0, this.pvHeaderSize);
            }
        }
        int n = this.padding;
        int n2 = n + nArray[0] + this.padding;
        StringBuffer stringBuffer = this.getEmptyLine(this.cpr - this.currentInset);
        stringBuffer = this.insertIntoSBLocation(stringBuffer, this.addColon(string), n, nArray[0], 0);
        stringBuffer = this.insertIntoSBLocation(stringBuffer, string2, n2, nArray[1], 0);
        this.write(this.getInsetString() + Convert.trimR((String)stringBuffer.toString()));
    }

    public void writePairedValueTable_End() throws IOException {
        if (!this.activePVTable) {
            logger.debug((Object)"WARNING: A paired value table must be active for ending.");
            return;
        }
        this.write("");
        this.activePVTable = false;
        this.pvHeader = null;
    }

    public void addInset() throws IOException {
        this.addInset(1);
    }

    public void addInset(int n) throws IOException {
        this.currentInset += n;
    }

    public void removeInset() throws IOException {
        this.removeInset(1);
    }

    public void removeInset(int n) throws IOException {
        if (this.currentInset < 1) {
            logger.debug((Object)"WARNING: There is not inset to remove.");
            this.currentInset = 0;
            return;
        }
        if (n > this.currentInset) {
            logger.debug((Object)"WARNING: There is less inset than requested to be remove.");
            this.currentInset = 0;
        } else {
            this.currentInset -= n;
        }
    }

    private String getInsetString() {
        return this.getInsetString(0);
    }

    private String getInsetString(int n) {
        int n2 = this.currentInset + n;
        if (n2 > 0) {
            return this.getEmptyLine(n2).toString();
        }
        return "";
    }

    public void writeTable_Start(String[] stringArray, int[] nArray, String string, int n, boolean bl) throws IOException {
        this.validateTable(bl);
        if (this.isPageAlmostFull()) {
            this.writePageBreak();
        }
        this.writeSectionHeading(string, 0, n);
        if (bl) {
            this.innerTableHeader = string;
            this.innerTableHeaderSize = n;
            this.startTable(stringArray, nArray, bl);
            this.activeInnerTable = true;
        } else {
            this.tableHeader = string;
            this.tableHeaderSize = n;
            this.startTable(stringArray, nArray, bl);
            this.activeTable = true;
        }
    }

    public void writeTable_Start(String[] stringArray, int[] nArray, boolean bl) throws IOException {
        this.validateTable(bl);
        if (this.isPageAlmostFull()) {
            this.writePageBreak();
        }
        if (bl) {
            this.innerTableHeader = null;
            this.innerTableHeaderSize = 3;
            this.startTable(stringArray, nArray, bl);
            this.activeInnerTable = true;
        } else {
            this.tableHeader = null;
            this.tableHeaderSize = 3;
            this.startTable(stringArray, nArray, bl);
            this.activeTable = true;
        }
    }

    private void validateTable(boolean bl) {
        if (bl) {
            if (this.activeInnerTable) {
                throw new RuntimeException("An inner table is already active.");
            }
            if (!this.activeTable) {
                throw new RuntimeException("A table must be active when starting an inner table.");
            }
        } else if (this.activeTable) {
            throw new RuntimeException("A table is already active.");
        }
    }

    private void startTable(String[] stringArray, int[] nArray, boolean bl) throws IOException {
        int n;
        int n2;
        if (stringArray.length < 1) {
            throw new RuntimeException("No columns defined for the table heading.");
        }
        if (nArray.length != stringArray.length) {
            throw new RuntimeException("Number of column sizes (" + nArray.length + ") does not match the number of columns (" + stringArray.length + ").");
        }
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            n4 = this.itInset;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 = n3 + nArray[n2] + this.padding;
        }
        n2 = this.cpr - (this.currentInset + n4);
        if (n3 > n2) {
            throw new RuntimeException("The row width (" + n3 + ") exceeds the maximum available row width (" + n2 + ").");
        }
        StringBuffer stringBuffer = this.getEmptyLine(n2);
        StringBuffer stringBuffer2 = this.getEmptyLine(n2);
        StringBuffer stringBuffer3 = this.getEmptyLine(n2);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() > nArray[n]) {
                String string = stringArray[n].trim();
                int n5 = string.length() / 2;
                int n6 = string.indexOf(" ");
                int n7 = -1;
                while (n6 > -1) {
                    if (n6 == n5) {
                        n7 = n5;
                        break;
                    }
                    if (n6 > n5) {
                        if (n5 - n7 <= n6 - n5) break;
                        n7 = n6;
                        break;
                    }
                    n7 = n6;
                    n6 = string.indexOf(" ", n6 + 1);
                }
                if (n7 > -1) {
                    stringArray2[n] = string.substring(0, n7).trim();
                    stringArray3[n] = string.substring(n7).trim();
                    bl2 = true;
                    continue;
                }
                stringArray2[n] = "";
                stringArray3[n] = string;
                continue;
            }
            stringArray2[n] = "";
            stringArray3[n] = stringArray[n];
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer = this.insertIntoSBLocation(stringBuffer, stringArray2[i], n, nArray[i], 1);
            stringBuffer2 = this.insertIntoSBLocation(stringBuffer2, stringArray3[i], n, nArray[i], 1);
            stringBuffer3 = this.insertIntoSBLocation(stringBuffer3, this.getUnderline(nArray[i]), n, nArray[i], 0);
            n = n + this.padding + nArray[i];
        }
        if (bl2) {
            this.write(this.getInsetString(n4) + Convert.trimR((String)stringBuffer.toString()));
        }
        this.write(this.getInsetString(n4) + Convert.trimR((String)stringBuffer2.toString()));
        this.write(this.getInsetString(n4) + Convert.trimR((String)stringBuffer3.toString()));
        if (bl) {
            this.innerTableColumnSizes = nArray;
            this.innerTableColumns = stringArray;
        } else {
            this.tableColumnSizes = nArray;
            this.tableColumns = stringArray;
        }
    }

    private void rewriteTableHeading() throws IOException {
        if (this.activeInnerTable) {
            if (this.innerTableHeader != null) {
                this.writeSectionHeading(this.innerTableHeader, 0, this.innerTableHeaderSize);
            }
            this.startTable(this.innerTableColumns, this.innerTableColumnSizes, true);
        } else {
            if (this.tableHeader != null) {
                this.writeSectionHeading(this.tableHeader, 0, this.tableHeaderSize);
            }
            this.startTable(this.tableColumns, this.tableColumnSizes, false);
        }
    }

    public void writeTable_Entry(ReportField[] reportFieldArray, boolean bl) throws IOException {
        if (reportFieldArray == null || reportFieldArray.length < 1) {
            throw new RuntimeException("No fields for the table row.");
        }
        if (bl) {
            if (!this.activeInnerTable) {
                throw new RuntimeException("An inner table is not currently started.");
            }
            if (reportFieldArray.length != this.innerTableColumnSizes.length) {
                throw new RuntimeException("The number of fields (" + reportFieldArray.length + ") does not match the number of columns (" + this.tableColumnSizes.length + ") for the active inner table.");
            }
        } else {
            if (!this.activeTable) {
                throw new RuntimeException("A table is not currently started.");
            }
            if (reportFieldArray.length != this.tableColumnSizes.length) {
                throw new RuntimeException("The number of fields (" + reportFieldArray.length + ") does not match the number of columns (" + this.tableColumnSizes.length + ") for the active table.");
            }
        }
        if (this.isPageFull()) {
            this.writePageBreak();
            this.rewriteTableHeading();
        }
        int n = this.cpr - this.currentInset;
        if (bl) {
            n -= this.itInset;
        }
        StringBuffer stringBuffer = this.getEmptyLine(n);
        int n2 = 0;
        for (int i = 0; i < reportFieldArray.length; ++i) {
            int n3 = 0;
            n3 = bl ? this.innerTableColumnSizes[i] : this.tableColumnSizes[i];
            stringBuffer = this.insertIntoSBLocation(stringBuffer, reportFieldArray[i].getValue(), n2, n3, reportFieldArray[i].getAlignment());
            n2 = n2 + this.padding + n3;
        }
        if (bl) {
            this.write(this.getInsetString(this.itInset) + Convert.trimR((String)stringBuffer.toString()));
        } else {
            this.write(this.getInsetString() + Convert.trimR((String)stringBuffer.toString()));
        }
    }

    public void writeTable_End(boolean bl) throws IOException {
        if (bl) {
            if (!this.activeInnerTable) {
                throw new RuntimeException("An inner table is not active to be ended.");
            }
            this.activeInnerTable = false;
            this.innerTableHeader = null;
            this.innerTableColumns = null;
            this.innerTableColumnSizes = null;
        } else {
            if (this.activeInnerTable) {
                throw new RuntimeException("An inner table is active. It must be ended before the normal table is ended.");
            }
            if (!this.activeTable) {
                logger.debug((Object)"WARNING: A table is not active to be ended.");
                return;
            }
            this.write("");
            this.activeTable = false;
            this.tableHeader = null;
            this.tableColumns = null;
            this.tableColumnSizes = null;
        }
    }

    public void writeRowText_Start() throws IOException {
        if (!this.activeTable) {
            throw new RuntimeException("An table must be active to start Row Text.");
        }
        if (this.activeRowText) {
            throw new RuntimeException("Row Text is already active.");
        }
        this.activeRowText = true;
    }

    public void writeRowText_Entry(String string) throws IOException {
        if (!this.activeRowText) {
            throw new RuntimeException("Row Text is not active.");
        }
        if (this.isPageFull()) {
            this.writePageBreak();
            this.rewriteTableHeading();
        }
        StringBuffer stringBuffer = this.getEmptyLine(this.cpr - this.currentInset);
        stringBuffer = this.alignLeftInSB(stringBuffer, string);
        this.write(this.getInsetString() + Convert.trimR((String)stringBuffer.toString()));
    }

    public void writeRowText_End() throws IOException {
        if (!this.activeRowText) {
            logger.debug((Object)"WARNING: Row Text is not active.");
        }
        this.activeRowText = false;
    }

    private void write(String string) throws IOException {
        this.checkReportStatus();
        if (this.linesPrinted == this.maxLines) {
            throw new RuntimeException("Maximum spooled file page length (" + this.maxLines + ") exceeded.");
        }
        this.scsWriter.write(string);
        this.scsWriter.newLine();
        ++this.linesPrinted;
    }

    private StringBuffer getEmptyLine(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer;
    }

    private StringBuffer alignCenterInSB(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length();
        int n2 = string.trim().length();
        if (n2 >= n) {
            stringBuffer.replace(0, n, string.trim().substring(0, n));
        } else {
            int n3 = n / 2 - (n2 + 1) / 2;
            stringBuffer.replace(n3, n3 + n2, string.trim());
        }
        return stringBuffer;
    }

    private StringBuffer alignRightInSB(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length();
        int n2 = string.trim().length();
        if (n2 > n) {
            stringBuffer.replace(0, n, string.trim().substring(0, n));
        } else {
            int n3 = n - n2;
            stringBuffer.replace(n3, n3 + n2, string.trim());
        }
        return stringBuffer;
    }

    private StringBuffer alignLeftInSB(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length();
        String string2 = Convert.trimR((String)string);
        int n2 = string2.length();
        if (n2 > n) {
            stringBuffer.replace(0, n, string2.substring(0, n));
        } else {
            stringBuffer.replace(0, n2, string2);
        }
        return stringBuffer;
    }

    private StringBuffer insertIntoSBLocation(StringBuffer stringBuffer, String string, int n, int n2, int n3) {
        String string2 = Convert.trimR((String)string);
        int n4 = string2.length();
        if (n4 >= n2) {
            stringBuffer.replace(n, n + n2, string2.substring(0, n2));
        } else {
            switch (n3) {
                case 1: {
                    int n5 = n + n2 / 2 - (n4 + 1) / 2;
                    stringBuffer.replace(n5, n5 + n4, string2);
                    break;
                }
                case 2: {
                    int n6 = n + n2 - n4;
                    stringBuffer.replace(n6, n6 + n4, string2);
                    break;
                }
                default: {
                    stringBuffer.replace(n, n + n4, string2);
                }
            }
        }
        return stringBuffer;
    }

    private String getUnderline(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    private boolean isPageFull() {
        return this.linesPrinted > this.overFlowLine;
    }

    private boolean isPageAlmostFull() {
        return this.linesPrinted > this.overFlowLine - 2;
    }

    private String addColon(String string) {
        if (string.trim().endsWith(":")) {
            return string;
        }
        return string.trim() + ":";
    }
}

