/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.parser;

import com.helpsystems.common.as400.prompter.busobj.Dependency;
import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.busobj.PromptedCommand;
import com.helpsystems.common.as400.prompter.parser.DepParser;
import com.helpsystems.common.as400.prompter.parser.EntryParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CommandParser {
    public static PromptedCommand parse(Document document) {
        if (document == null) {
            throw new NullPointerException("The XML passed in is null.");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        String string = element.getNodeName();
        if (!"QcdCLCmd".equalsIgnoreCase(string)) {
            throw new RuntimeException("The first node in the Document was " + string + ". It should be 'QcdCLCmd'");
        }
        NodeList nodeList = element.getChildNodes();
        PromptedCommand promptedCommand = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if ("Cmd".equalsIgnoreCase(element2.getNodeName())) {
                promptedCommand = CommandParser.parse(element2);
                continue;
            }
            if (!"Extra".equalsIgnoreCase(element2.getNodeName()) || promptedCommand == null) continue;
            String string2 = element2.getAttribute("name");
            String string3 = element2.getAttribute("value");
            if ("timeseparator".equalsIgnoreCase(string2)) {
                promptedCommand.setTimeSeparator(string3);
                continue;
            }
            if ("dateseparator".equalsIgnoreCase(string2)) {
                promptedCommand.setDateSeparator(string3);
                continue;
            }
            if (!"dateformat".equalsIgnoreCase(string2)) continue;
            promptedCommand.setDateFormat(string3);
        }
        return promptedCommand;
    }

    public static PromptedCommand parse(Element element) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string = element.getNodeName();
        if (!"cmd".equalsIgnoreCase(string)) {
            throw new RuntimeException("The element passed in is a " + string + ". It should be 'Cmd'");
        }
        PromptedCommand promptedCommand = new PromptedCommand();
        if (element.hasAttribute("CmdName")) {
            promptedCommand.setCommandName(element.getAttribute("CmdName"));
        }
        if (element.hasAttribute("CmdLib")) {
            promptedCommand.setLibraryName(element.getAttribute("CmdLib"));
        }
        if (element.hasAttribute("Prompt")) {
            promptedCommand.setDescription(element.getAttribute("Prompt"));
        }
        if (element.hasAttribute("MaxPos")) {
            promptedCommand.setPositionalLimit(EntryParser.parseNumber(element, "MaxPos", false));
        }
        if (element.hasAttribute("HlpPnlGrp")) {
            promptedCommand.setHelpPanelGroup(element.getAttribute("HlpPnlGrp"));
        }
        if (element.hasAttribute("HlpID")) {
            promptedCommand.setHelpID(element.getAttribute("HlpID"));
        }
        if (element.hasAttribute("PrdLib")) {
            promptedCommand.setProductLibrary(element.getAttribute("PrdLib"));
        }
        if (element.hasAttribute("MsgF")) {
            promptedCommand.setMessageFile(element.getAttribute("MsgF"));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if ("Parm".equalsIgnoreCase(element2.getNodeName())) {
                object = EntryParser.parse(element2);
                if (object == null) continue;
                promptedCommand.addEntry((ParameterEntry)object);
                continue;
            }
            if (!"Dep".equalsIgnoreCase(element2.getNodeName()) || (object = DepParser.parse(element2)) == null) continue;
            promptedCommand.addDependency((Dependency)object);
        }
        return promptedCommand;
    }
}

