/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.busobj;

import com.helpsystems.common.as400.prompter.busobj.ControlCondition;
import com.helpsystems.common.as400.prompter.busobj.GenericParameter;
import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.busobj.PromptControl;
import com.helpsystems.common.as400.prompter.busobj.PromptedCommand;
import com.helpsystems.common.as400.prompter.busobj.SingleValueDefinition;
import com.helpsystems.common.core.util.Equal;

public class PromptControlEvaluator {
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int GE = 3;
    public static final int LT = 4;
    public static final int NE = 5;
    public static final int LE = 6;
    public static final int SPECIFIED = 10;
    public static final int UNSPECIFIED = 11;
    public static final int ALWAYS = 12;
    public static final int ALL = 13;

    private PromptControlEvaluator() {
    }

    public static boolean evaluate(PromptedCommand promptedCommand, PromptControl[] promptControlArray) {
        if (promptControlArray.length == 0) {
            return true;
        }
        PromptControl promptControl = promptControlArray[0];
        boolean bl = PromptControlEvaluator.evaluate(promptedCommand.findParameter(promptControl.getKeyword()), promptControl);
        int n = promptControl.getBooleanControl();
        for (int i = 1; i < promptControlArray.length; ++i) {
            promptControl = promptControlArray[i];
            ParameterEntry parameterEntry = promptedCommand.findParameter(promptControl.getKeyword());
            boolean bl2 = PromptControlEvaluator.evaluate(parameterEntry, promptControl);
            if (n == 1) {
                if (!bl || !bl2) {
                    return false;
                }
                bl = true;
            } else if (n == 2) {
                if (!bl && !bl2) {
                    return false;
                }
                bl = true;
            }
            n = promptControl.getBooleanControl();
        }
        return bl;
    }

    public static boolean evaluate(ParameterEntry parameterEntry, PromptControl promptControl) {
        String string;
        if (parameterEntry == null) {
            throw new NullPointerException("The source parameter passed in is null.");
        }
        if (promptControl == null) {
            throw new NullPointerException("The Prompt Control passed in is null.");
        }
        String string2 = parameterEntry.getKeyword();
        if (!string2.equalsIgnoreCase(string = promptControl.getKeyword())) {
            throw new IllegalArgumentException("The source keyword " + string2 + " does not match the control keyword " + string);
        }
        String[] stringArray = parameterEntry.getAllParameterValues().flatten();
        int n = 0;
        ControlCondition[] controlConditionArray = promptControl.getConditions();
        if (controlConditionArray.length == 0) {
            return true;
        }
        PromptedCommand promptedCommand = parameterEntry.findParentCommand();
        block0: for (int i = 0; i < controlConditionArray.length; ++i) {
            int n2 = controlConditionArray[i].getOperator();
            String string3 = controlConditionArray[i].getValue();
            String string4 = PromptControlEvaluator.remapVariableIfNecessary(parameterEntry, string3);
            if (Equal.isEqual((Object)string4, (Object)string3) && (string4 = promptedCommand.callPromptControl(parameterEntry, string4)) == null) {
                return true;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                boolean bl;
                String string5 = stringArray[j];
                if (string5 == null || !(bl = PromptControlEvaluator.compare(string5, string4, n2, true, promptedCommand))) continue;
                ++n;
                continue block0;
            }
        }
        if (promptControl.getOperator() == 2) {
            return n == promptControl.getNumberTrue();
        }
        if (promptControl.getOperator() == 4) {
            return n < promptControl.getNumberTrue();
        }
        if (promptControl.getOperator() == 1) {
            return n > promptControl.getNumberTrue();
        }
        if (promptControl.getOperator() == 6) {
            return n <= promptControl.getNumberTrue();
        }
        if (promptControl.getOperator() == 3) {
            return n >= promptControl.getNumberTrue();
        }
        if (promptControl.getOperator() == 5) {
            return n != promptControl.getNumberTrue();
        }
        throw new RuntimeException("Unable to evaluate condition for control " + parameterEntry.getKeyword());
    }

    static String remapVariableIfNecessary(GenericParameter genericParameter, String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string2 = PromptControlEvaluator.remapVariable(genericParameter.getSpecialValueDefinitions(), string2);
        string2 = PromptControlEvaluator.remapVariable(genericParameter.getSingleValueDefinitions(), string2);
        return string2;
    }

    private static String remapVariable(SingleValueDefinition[] singleValueDefinitionArray, String string) {
        for (int i = 0; i < singleValueDefinitionArray.length; ++i) {
            if (!string.equalsIgnoreCase(singleValueDefinitionArray[i].getMapTo())) continue;
            return singleValueDefinitionArray[i].getValue();
        }
        return string;
    }

    public static String unmapVariableIfNecessary(GenericParameter genericParameter, String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string2 = PromptControlEvaluator.unmapVariable(genericParameter.getSpecialValueDefinitions(), string2);
        string2 = PromptControlEvaluator.unmapVariable(genericParameter.getSingleValueDefinitions(), string2);
        if (genericParameter.isInElem() && "*N".equals(string2)) {
            string2 = "";
        }
        return string2;
    }

    private static String unmapVariable(SingleValueDefinition[] singleValueDefinitionArray, String string) {
        for (int i = 0; i < singleValueDefinitionArray.length; ++i) {
            if (!string.equalsIgnoreCase(singleValueDefinitionArray[i].getValue())) continue;
            return singleValueDefinitionArray[i].getMapTo();
        }
        return string;
    }

    public static boolean compare(String string, String string2, int n, boolean bl, PromptedCommand promptedCommand) {
        String string3 = string;
        string3 = string3 == null ? "" : string3.trim();
        String string4 = string2;
        string4 = string4 == null ? "" : string4.trim();
        if (n == 10) {
            return bl;
        }
        if (n == 11) {
            return !bl;
        }
        if (promptedCommand != null && (promptedCommand.isValidVariableName(string3) || promptedCommand.isValidVariableName(string4))) {
            return n != 2 && n != 3 && n != 6;
        }
        if (n == 2) {
            return string3.equalsIgnoreCase(string4);
        }
        if (n == 5) {
            return !string3.equalsIgnoreCase(string4);
        }
        double d = 0.0;
        boolean bl2 = false;
        try {
            d = Double.parseDouble(string3);
            bl2 = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!bl2) {
            if (n == 4) {
                return string3.toUpperCase().compareTo(string4.toUpperCase()) < 0;
            }
            if (n == 1) {
                return string3.toUpperCase().compareTo(string4.toUpperCase()) > 0;
            }
            return false;
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return PromptControlEvaluator.compare(d, d2, n);
    }

    public static boolean compare(double d, double d2, int n) {
        if (n == 10) {
            return d != 0.0;
        }
        if (n == 11) {
            return d == 0.0;
        }
        if (n == 2) {
            return d == d2;
        }
        if (n == 4) {
            return d < d2;
        }
        if (n == 1) {
            return d > d2;
        }
        if (n == 6) {
            return d <= d2;
        }
        if (n == 3) {
            return d >= d2;
        }
        if (n == 5) {
            return d != d2;
        }
        throw new IllegalArgumentException("Unable to perform numeric comparison for operator " + n);
    }

    public static int mapOperator(String string) {
        if ("GT".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("EQ".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("GE".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("LT".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("NE".equalsIgnoreCase(string)) {
            return 5;
        }
        if ("LE".equalsIgnoreCase(string)) {
            return 6;
        }
        if ("SPCFD".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("UNSPCFD".equalsIgnoreCase(string)) {
            return 11;
        }
        if ("ALWAYS".equalsIgnoreCase(string)) {
            return 12;
        }
        throw new IllegalArgumentException("The operator " + string + " is not valid.");
    }

    public static String operatorToString(int n) {
        switch (n) {
            case 2: {
                return "EQ";
            }
            case 3: {
                return "GE";
            }
            case 1: {
                return "GT";
            }
            case 6: {
                return "LE";
            }
            case 4: {
                return "LT";
            }
            case 5: {
                return "NE";
            }
            case 10: {
                return "SPECIFIED";
            }
            case 13: {
                return "ALL";
            }
            case 12: {
                return "ALWAYS";
            }
            case 11: {
                return "UNSPECIFIED";
            }
        }
        throw new IllegalArgumentException("The operator " + n + " is not valid.");
    }
}

