/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.network;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.ex.CommandCallException;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.network.StatusMessage;
import com.helpsystems.common.core.network.StatusMessageAM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.data.PcmlException;
import org.apache.log4j.Logger;

public class StatusMessageAMAS400
extends AbstractAS400Manager
implements StatusMessageAM {
    private static Logger logger = Logger.getLogger(StatusMessageAMAS400.class);

    public StatusMessageAMAS400(String string, String string2) throws PcmlException {
        super(string, string2);
        this.setName("NETWORK.StatusMessageAM");
    }

    public void sendStatusMessage(StatusMessage statusMessage) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
        String string = StatusMessage.buildRBNSNDMSGCommand((StatusMessage)statusMessage);
        try {
            logger.trace((Object)("RBNSNDSTS Command: " + string));
            CommandExecutionResponse commandExecutionResponse = AbstractAS400Manager.runCommand(commandCall, string);
            if (!commandExecutionResponse.isSuccessful()) {
                String string2 = "An error occurred sending the Network status message.\n" + commandExecutionResponse.getMessageString(1);
                throw new ResourceUnavailableException(string2);
            }
        }
        catch (CommandCallException commandCallException) {
            logger.debug((Object)("An error occurred sending the Network status message: " + string), (Throwable)commandCallException);
            throw new ResourceUnavailableException("An error occurred sending the Network status message.", (Throwable)commandCallException);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
    }
}

