/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.dataset;

import com.helpsystems.common.as400.access.OS400SpooledFileDMAS400;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400JobDescriptor;
import com.helpsystems.common.as400.busobj.OS400SpooledFileProxy;
import com.helpsystems.common.as400.ex.JobException;
import com.helpsystems.common.as400.ex.JobNotFoundException;
import com.helpsystems.common.as400.util.OS400Utilities;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.list.SpooledFileListItem;
import com.ibm.as400.access.list.SpooledFileOpenList;
import org.apache.log4j.Logger;

public class SpooledFileListDataSet
implements DataSet {
    private static final Logger logger = Logger.getLogger(SpooledFileListDataSet.class);
    public static final int DEFAULT_THRESHOLD = 200;
    private WrappedAS400 as400;
    private SpooledFileOpenList spooledFileList;
    private boolean isClosed = false;
    private OS400SpooledFileDMAS400 mgr;

    private SpooledFileListDataSet(WrappedAS400 wrappedAS400, SpooledFileOpenList spooledFileOpenList, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400) throws DataSetException, JobException {
        if (wrappedAS400 == null) {
            throw new NullPointerException("The AS400 object passed in is null.");
        }
        this.as400 = wrappedAS400;
        if (oS400SpooledFileDMAS400 == null) {
            throw new NullPointerException("The OS400SpooledFileDM passed in is null.");
        }
        this.mgr = oS400SpooledFileDMAS400;
        if (spooledFileOpenList == null) {
            throw new NullPointerException("The spooled file list passed in is null.");
        }
        this.spooledFileList = spooledFileOpenList;
        try {
            spooledFileOpenList.open();
        }
        catch (AS400Exception aS400Exception) {
            String string = aS400Exception.getMessage();
            if (string.indexOf("CPF3342") > -1) {
                OS400JobDescriptor oS400JobDescriptor = null;
                try {
                    String[] stringArray = string.split("/");
                    String[] stringArray2 = stringArray[0].split(" ");
                    String string2 = stringArray2[stringArray2.length - 1];
                    String string3 = stringArray[1];
                    String[] stringArray3 = stringArray[2].split(" ");
                    String string4 = stringArray3[0];
                    oS400JobDescriptor = new OS400JobDescriptor(string4, string3, string2);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw new JobNotFoundException(oS400JobDescriptor, (Exception)((Object)aS400Exception));
            }
            throw new DataSetException("There was a system problem loading the spooled file list.", (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            throw new DataSetException("There was a problem loading the spooled file list.", (Throwable)exception);
        }
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, SpooledFileOpenList spooledFileOpenList, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400) throws DataSetException, JobException {
        return SpooledFileListDataSet.createDataSet(wrappedAS400, spooledFileOpenList, oS400SpooledFileDMAS400, 200);
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, SpooledFileOpenList spooledFileOpenList, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400, int n) throws DataSetException, JobException {
        SpooledFileListDataSet spooledFileListDataSet = new SpooledFileListDataSet(wrappedAS400, spooledFileOpenList, oS400SpooledFileDMAS400);
        return ArrayDataSet.checkThreshold((DataSet)spooledFileListDataSet, (int)n);
    }

    public Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        OS400SpooledFileProxy[] oS400SpooledFileProxyArray = null;
        ErrorTable errorTable = new ErrorTable();
        try {
            SpooledFileListItem[] spooledFileListItemArray = (SpooledFileListItem[])this.spooledFileList.getItems(n, n2);
            oS400SpooledFileProxyArray = new OS400SpooledFileProxy[spooledFileListItemArray.length];
            for (int i = 0; i < spooledFileListItemArray.length; ++i) {
                try {
                    OS400SpooledFileProxy oS400SpooledFileProxy;
                    oS400SpooledFileProxyArray[i] = oS400SpooledFileProxy = this.mgr.copyToProxy(spooledFileListItemArray[i], null);
                    continue;
                }
                catch (BadDataException badDataException) {
                    errorTable.addException(i + n, (Exception)((Object)badDataException));
                    oS400SpooledFileProxyArray[i] = badDataException.getLoadedObject();
                }
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to retrieve the spooled file info.", (Throwable)exception);
        }
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("A data error occurred.", (Object[])oS400SpooledFileProxyArray, errorTable);
        }
        return oS400SpooledFileProxyArray;
    }

    public int size() throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        try {
            return this.spooledFileList.getLength();
        }
        catch (AS400Exception aS400Exception) {
            String string = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new DataSetException("Error accessing DataSet: \n" + string, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error loading spooled file object.";
            logger.debug((Object)string, (Throwable)exception);
            throw new DataSetException(string, (Throwable)exception);
        }
    }

    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.spooledFileList.close();
            this.as400.close();
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to close the AS400 connection.", (Throwable)exception);
        }
    }
}

