/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.dataset;

import com.helpsystems.common.as400.access.OS400SpooledFileDMAS400;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400SpooledFileLine;
import com.helpsystems.common.as400.dataset.SpooledFileBufferedReader;
import com.helpsystems.common.as400.dataset.SpooledFileFilterInputStream;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.NotAuthorizedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SpooledFileLineDataSet
implements DataSet {
    private static final Logger logger = Logger.getLogger(SpooledFileLineDataSet.class);
    public static final int DEFAULT_THRESHOLD = 200;
    private WrappedAS400 as400;
    private boolean isClosed = false;
    private PrintObjectPageInputStream pageInputStream;
    private SpooledFileFilterInputStream filterInputStream;
    private InputStreamReader inputStreamReader;
    private BufferedReader bufferedReader;
    private SpooledFileBufferedReader spooledFileReader;
    private int totalLines;
    private int totalPages;
    private int linesPerPage;

    private SpooledFileLineDataSet(WrappedAS400 wrappedAS400, SpooledFile spooledFile, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400) throws DataSetException, NotAuthorizedException {
        if (wrappedAS400 == null) {
            throw new NullPointerException("The AS400 object passed in is null.");
        }
        this.as400 = wrappedAS400;
        if (oS400SpooledFileDMAS400 == null) {
            throw new NullPointerException("The OS400SpooledFileDM passed in is null.");
        }
        if (spooledFile == null) {
            throw new NullPointerException("The spooled file list passed in is null.");
        }
        try {
            PrintParameterList printParameterList = new PrintParameterList();
            printParameterList.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
            printParameterList.setParameter(65, "*WSCST");
            this.pageInputStream = spooledFile.getPageInputStream(printParameterList);
            this.filterInputStream = new SpooledFileFilterInputStream((InputStream)this.pageInputStream);
            this.inputStreamReader = new InputStreamReader((InputStream)this.filterInputStream, "CP850");
            this.bufferedReader = new BufferedReader(this.inputStreamReader);
            this.spooledFileReader = new SpooledFileBufferedReader(this.bufferedReader);
            this.linesPerPage = (int)new Float(spooledFile.getFloatAttribute(78).floatValue()).longValue();
            this.totalPages = this.pageInputStream.getNumberOfPages();
            while (true) {
                try {
                    boolean bl = this.pageInputStream.selectPage(this.totalPages);
                    if (bl) {
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                --this.totalPages;
            }
            this.totalLines = this.totalPages * this.linesPerPage;
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            if (errorCompletingRequestException.getMessage().startsWith("CPF3492")) {
                throw new NotAuthorizedException(errorCompletingRequestException.getMessage());
            }
        }
        catch (Exception exception) {
            throw new DataSetException("There was a problem loading the spooled file data.", (Throwable)exception);
        }
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, SpooledFile spooledFile, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400) throws DataSetException, NotAuthorizedException {
        return SpooledFileLineDataSet.createDataSet(wrappedAS400, spooledFile, oS400SpooledFileDMAS400, 200);
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, SpooledFile spooledFile, OS400SpooledFileDMAS400 oS400SpooledFileDMAS400, int n) throws DataSetException, NotAuthorizedException {
        SpooledFileLineDataSet spooledFileLineDataSet = new SpooledFileLineDataSet(wrappedAS400, spooledFile, oS400SpooledFileDMAS400);
        return ArrayDataSet.checkThreshold((DataSet)spooledFileLineDataSet, (int)n);
    }

    public synchronized Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        Vector<OS400SpooledFileLine> vector = new Vector<OS400SpooledFileLine>();
        HashMap<Integer, OS400SpooledFileLine> hashMap = null;
        int n3 = n;
        try {
            if (n3 < 1) {
                n3 = 1;
            }
            int n4 = n3 / this.linesPerPage;
            int n5 = n3 % this.linesPerPage;
            if (n5 > 0) {
                ++n4;
            }
            int n6 = (n3 + n2) / this.linesPerPage;
            int n7 = (n3 + n2) % this.linesPerPage;
            if (n7 > 0) {
                ++n6;
            }
            int n8 = n6 - n4 + 1;
            hashMap = this.loadPages(n4, n8);
            for (int i = 0; i < n2; ++i) {
                OS400SpooledFileLine oS400SpooledFileLine = hashMap.get(new Integer(n3 + i));
                if (oS400SpooledFileLine == null) continue;
                vector.addElement(oS400SpooledFileLine);
            }
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to retrieve the spooled file info.", (Throwable)exception);
        }
    }

    private HashMap<Integer, OS400SpooledFileLine> loadPages(int n, int n2) throws ResourceUnavailableException {
        HashMap<Integer, OS400SpooledFileLine> hashMap = new HashMap<Integer, OS400SpooledFileLine>();
        try {
            for (int i = 0; i < n2; ++i) {
                int n3 = n + i;
                int n4 = (n3 - 1) * this.linesPerPage + 1;
                int n5 = 1;
                boolean bl = this.pageInputStream.selectPage(n3);
                if (!bl) continue;
                String[] stringArray = this.spooledFileReader.readLine();
                while (stringArray != null) {
                    OS400SpooledFileLine oS400SpooledFileLine = new OS400SpooledFileLine();
                    oS400SpooledFileLine.setLineData(stringArray);
                    oS400SpooledFileLine.setPageNumber(n3);
                    oS400SpooledFileLine.setPageLineNumber(n5++);
                    oS400SpooledFileLine.setLineNumber(n4++);
                    hashMap.put(new Integer(oS400SpooledFileLine.getLineNumber()), oS400SpooledFileLine);
                    stringArray = this.spooledFileReader.readLine();
                }
                if (n5 - 1 >= this.linesPerPage) continue;
                int n6 = this.linesPerPage - n5 + 1;
                for (int j = 0; j < n6; ++j) {
                    OS400SpooledFileLine oS400SpooledFileLine = new OS400SpooledFileLine();
                    oS400SpooledFileLine.setLineData(new String[]{""});
                    oS400SpooledFileLine.setPageNumber(n3);
                    oS400SpooledFileLine.setPageLineNumber(n5++);
                    oS400SpooledFileLine.setLineNumber(n4++);
                    hashMap.put(new Integer(oS400SpooledFileLine.getLineNumber()), oS400SpooledFileLine);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            String string = "Error retrieving OS400 spooled file data.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    public int size() throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        return this.totalLines;
    }

    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.pageInputStream != null) {
                this.pageInputStream.close();
            }
            if (this.as400 != null) {
                this.as400.close();
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to close the AS400 connection.", (Throwable)exception);
        }
    }
}

