/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.dataset;

import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400Message;
import com.helpsystems.common.as400.dataset.MessageSource;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.busobj.LocalizedDate;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.QueuedMessage;
import java.util.Date;
import org.apache.log4j.Logger;

public class MessageDataSet
implements DataSet {
    private static final Logger logger = Logger.getLogger(MessageDataSet.class);
    public static final int DEFAULT_THRESHOLD = 200;
    protected MessageSource source;
    private boolean isClosed;

    private MessageDataSet(MessageSource messageSource) {
        if (messageSource == null) {
            throw new NullPointerException("The source passed in is null.");
        }
        this.source = messageSource;
    }

    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            AS400 aS400 = this.source.getSystem();
            this.source.close();
            if (aS400 instanceof WrappedAS400) {
                ((WrappedAS400)aS400).close();
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Error when closing the data set.", (Throwable)exception);
        }
    }

    public static DataSet createDataSet(MessageSource messageSource) throws DataSetException {
        return MessageDataSet.createDataSet(messageSource, 200);
    }

    public static DataSet createDataSet(MessageSource messageSource, int n) throws DataSetException {
        try {
            messageSource.load();
        }
        catch (Exception exception) {
            throw new DataSetException("Unable to determine the size of the message source.", (Throwable)exception);
        }
        MessageDataSet messageDataSet = new MessageDataSet(messageSource);
        return ArrayDataSet.checkThreshold((DataSet)messageDataSet, (int)n);
    }

    public Object[] get(int n, int n2) throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        if (n2 == 0) {
            return new Object[0];
        }
        OS400Message[] oS400MessageArray = new OS400Message[n2];
        int n3 = 0;
        try {
            int n4 = n2;
            while (n4 > 0) {
                QueuedMessage[] queuedMessageArray = this.source.getMessages(n + n3, n4);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Offset= " + (n + n3) + "\t  Length= " + n4 + "\t  Returned= " + queuedMessageArray.length));
                }
                for (int i = 0; i < queuedMessageArray.length; ++i) {
                    QueuedMessage queuedMessage = queuedMessageArray[i];
                    OS400Message oS400Message = new OS400Message();
                    oS400Message.setAlertOption(queuedMessage.getAlertOption());
                    oS400Message.setCurrentUser(queuedMessage.getCurrentUser());
                    oS400Message.setDefaultReply(queuedMessage.getDefaultReply());
                    oS400Message.setFirstLevelText(queuedMessage.getText());
                    oS400Message.setMessageData(queuedMessage.getSubstitutionData());
                    LocalizedDate localizedDate = new LocalizedDate(queuedMessage.getDate().getTime());
                    LocalizedDate.correctTime((Date)localizedDate);
                    oS400Message.setMessageDate((Date)localizedDate);
                    oS400Message.setMessageFileName(queuedMessage.getFileName());
                    oS400Message.setMessageFileLibrary(queuedMessage.getLibraryName());
                    oS400Message.setMessageId(queuedMessage.getID());
                    oS400Message.setMessageKey(queuedMessage.getKey());
                    oS400Message.setMessageQueue(queuedMessage.getFileName());
                    oS400Message.setMessageQueueLibrary(queuedMessage.getLibraryName());
                    oS400Message.setReplyStatus(queuedMessage.getReplyStatus());
                    oS400Message.setSecondLevelText("");
                    if (queuedMessage.getHelp().startsWith(queuedMessage.getText())) {
                        oS400Message.setFirstLevelText(queuedMessage.getHelp());
                    } else {
                        oS400Message.setSecondLevelText(MessageFile.substituteFormattingCharacters((String)queuedMessage.getHelp()));
                    }
                    oS400Message.setSendingJobName(queuedMessage.getFromJobName());
                    oS400Message.setSendingJobNumber(queuedMessage.getFromJobNumber());
                    oS400Message.setSendingProgram(queuedMessage.getFromProgram());
                    oS400Message.setSendingUser(queuedMessage.getUser());
                    oS400Message.setSeverity(queuedMessage.getSeverity());
                    oS400Message.setSystem(this.source.getSystem().getSystemName());
                    oS400Message.setType(queuedMessage.getType());
                    oS400MessageArray[n3 + i] = oS400Message;
                }
                n4 -= queuedMessageArray.length;
                n3 += queuedMessageArray.length;
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Error reading data from the Message Queue", (Throwable)exception);
        }
        return oS400MessageArray;
    }

    public int size() throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        return this.source.getLength();
    }
}

