/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.util.OS400HostServers;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import java.net.InetAddress;

public class ValidateAS400Connection {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)ValidateAS400Connection.class.getName());

    private ValidateAS400Connection() {
    }

    public static InetAddress validate(String string, String string2, String string3) throws ResourceUnavailableException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("A system must be specified.");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("A user name must be specified.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("A password must be specified.");
        }
        InetAddress inetAddress = OS400HostServers.checkDCHostServers(string);
        AS400 aS400 = new AS400(inetAddress.getHostAddress(), string2, string3);
        boolean bl = false;
        try {
            bl = aS400.validateSignon();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(rbh.getMsg("unable_signon", (Object)string, (Object)string2), throwable);
        }
        finally {
            aS400.disconnectAllServices();
        }
        if (!bl) {
            throw new RuntimeException(rbh.getMsg("unable_signon", (Object)string, (Object)string2));
        }
        return inetAddress;
    }
}

