/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400FileHandle;
import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.server.file.FileHandleOutputStream;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSRandomAccessFile;
import java.util.Stack;

public class RemoteFileAMAS400
extends AbstractAS400Manager
implements RemoteFileAM {
    private static final RemoteFile ROOT_DIR = new RemoteFile("/", null, 128, true, 0L, false);

    public RemoteFileAMAS400(String string, String string2) {
        super(string);
        this.setName(string2);
    }

    public RemoteFile getDefaultDirectory() {
        return ROOT_DIR;
    }

    public RemoteFile get(UserIdentity userIdentity, String string) throws ActionFailedException {
        return this.get(userIdentity, string, true);
    }

    public RemoteFile get(UserIdentity userIdentity, String string, boolean bl) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        try {
            String string2;
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            boolean bl2 = iFSFile.exists();
            if (!bl2) {
                RemoteFile remoteFile = new RemoteFile(iFSFile.getName(), null, 0, false, 0L, false);
                return remoteFile;
            }
            Stack<IFSFile> stack = new Stack<IFSFile>();
            while (true) {
                stack.push(iFSFile);
                string2 = iFSFile.getParent();
                if (string2 == null) break;
                iFSFile = new IFSFile((AS400)wrappedAS400, string2);
            }
            string2 = null;
            while (!stack.isEmpty()) {
                iFSFile = (IFSFile)stack.pop();
                int n = 0;
                n = iFSFile.isDirectory() ? 128 : 64;
                string2 = new RemoteFile(iFSFile.getName(), (RemoteFile)string2, n, true, iFSFile.lastModified(), iFSFile.length(), iFSFile.isHidden());
            }
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            if (exception instanceof ActionFailedException) {
                throw (ActionFailedException)((Object)exception);
            }
            throw new ActionFailedException("Unable to retrieve file informantion for " + string, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
    }

    public RemoteFile[] getFiles(UserIdentity userIdentity, RemoteFile remoteFile) throws ActionFailedException {
        return this.getFiles(userIdentity, remoteFile, true);
    }

    public RemoteFile[] getFiles(UserIdentity userIdentity, RemoteFile remoteFile, boolean bl) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Dir", (Object)remoteFile);
        String string = remoteFile.getAbsolutePath();
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            if (!iFSFile.exists()) {
                throw new ActionFailedException(string + " does not exist.", null);
            }
            if (!iFSFile.isDirectory()) {
                throw new ActionFailedException(string + " is not a directory.", null);
            }
            IFSFile[] iFSFileArray = iFSFile.listFiles();
            RemoteFile[] remoteFileArray = new RemoteFile[iFSFileArray.length];
            for (int i = 0; i < iFSFileArray.length; ++i) {
                IFSFile iFSFile2 = iFSFileArray[i];
                int n = 0;
                n = iFSFile2.isDirectory() ? 128 : 64;
                remoteFileArray[i] = new RemoteFile(iFSFile2.getName(), remoteFile, n, true, iFSFile2.lastModified(), iFSFile2.isHidden());
            }
            RemoteFile[] remoteFileArray2 = remoteFileArray;
            return remoteFileArray2;
        }
        catch (Exception exception) {
            if (exception instanceof ActionFailedException) {
                throw (ActionFailedException)((Object)exception);
            }
            throw new ActionFailedException("Unable to retrieve a file listing for " + string, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
    }

    public RemoteFile[] getRoots() {
        return this.getRoots(true);
    }

    public RemoteFile[] getRoots(boolean bl) {
        return new RemoteFile[]{ROOT_DIR};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(UserIdentity userIdentity, String string) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        Exception exception = null;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            bl = iFSFile.delete();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        if (!bl) {
            throw new ActionFailedException("Unable to delete the file " + string, (Throwable)exception);
        }
    }

    public boolean exists(UserIdentity userIdentity, String string) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            boolean bl = iFSFile.exists();
            return bl;
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to test the file " + string, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
    }

    public FileHandle getHandle(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        AS400FileHandle aS400FileHandle = null;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSRandomAccessFile iFSRandomAccessFile = new IFSRandomAccessFile((AS400)wrappedAS400, string, string2);
            aS400FileHandle = new AS400FileHandle(iFSRandomAccessFile);
        }
        catch (Exception exception) {
            if (wrappedAS400 != null) {
                try {
                    wrappedAS400.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new ActionFailedException("Unable to get a file handle for " + string, (Throwable)exception);
        }
        return aS400FileHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"File name", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            IFSFile iFSFile2 = new IFSFile((AS400)wrappedAS400, string2);
            bl = iFSFile.renameTo(iFSFile2);
        }
        catch (Exception exception) {
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        if (!bl) {
            throw new ActionFailedException("Unable to rename file " + string + " to file " + string2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"File name", (Object)string);
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            bl = iFSFile.copyTo(string2);
        }
        catch (Exception exception) {
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        if (!bl) {
            throw new ActionFailedException("Unable to copy file " + string + " to file " + string2, null);
        }
    }

    public FileHandleOutputStream execute(UserIdentity userIdentity, String string, String string2) throws ActionFailedException {
        throw new ActionFailedException("Not implemented.", null);
    }

    public String getDefaultEncoding() {
        return null;
    }

    public int getFileSystemType() {
        return 1;
    }

    public String md5sum(UserIdentity userIdentity, String string) throws ActionFailedException {
        throw new ActionFailedException("Not supported");
    }

    public void mkdir(UserIdentity userIdentity, String string) throws ActionFailedException {
        throw new ActionFailedException("Not supported");
    }
}

