/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400SystemPoolProxy;
import com.helpsystems.common.as400.busobj.OS400SystemStatus;
import com.helpsystems.common.as400.busobj.OS400SystemStatusProxy;
import com.helpsystems.common.as400.dm.OS400SystemStatusDM;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import java.util.ArrayList;
import java.util.Enumeration;

public class OS400SystemStatusDMAS400
extends AbstractAS400Manager
implements OS400SystemStatusDM {
    public OS400SystemStatusDMAS400(String string, String string2) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    public OS400SystemStatus getOS400SystemStatus(UserIdentity userIdentity) throws ResourceUnavailableException {
        OS400SystemStatus oS400SystemStatus = new OS400SystemStatus();
        this.loadSystemStatus(userIdentity, oS400SystemStatus);
        return oS400SystemStatus;
    }

    public void reloadSystemStatus(UserIdentity userIdentity, OS400SystemStatus oS400SystemStatus) throws ResourceUnavailableException {
        this.loadSystemStatus(userIdentity, oS400SystemStatus);
    }

    public OS400SystemStatusProxy copyToProxy(SystemStatus systemStatus, OS400SystemStatusProxy oS400SystemStatusProxy) throws BadDataException, ResourceUnavailableException {
        if (systemStatus == null) {
            throw new NullPointerException("The system status passed in is null.");
        }
        OS400SystemStatusProxy oS400SystemStatusProxy2 = oS400SystemStatusProxy == null ? new OS400SystemStatusProxy() : oS400SystemStatusProxy;
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        try {
            try {
                oS400SystemStatusProxy2.setCurrentUnprotectedStorageUsed(systemStatus.getCurrentUnprotectedStorageUsed());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setElapsedTime(systemStatus.getElapsedTime());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setJobsInSystem(systemStatus.getJobsInSystem());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setMaximumUnprotectedStorageUsed(systemStatus.getMaximumUnprotectedStorageUsed());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setPercentPermanentAddresses(systemStatus.getPercentPermanentAddresses());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setPercentProcessingUnitUsed(systemStatus.getPercentProcessingUnitUsed());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setPercentSystemASPUsed(systemStatus.getPercentSystemASPUsed());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setPercentTemporaryAddresses(systemStatus.getPercentTemporaryAddresses());
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
            try {
                oS400SystemStatusProxy2.setOS400SystemPools(this.getSystemPoolProxyList(systemStatus));
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error retrieving system status information.", (Throwable)exception);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            BadDataException badDataException = new BadDataException("Error copying fields into the system status.", (Object)oS400SystemStatusProxy2, (ErrorList)exceptionErrorList);
            badDataException.initCause((Throwable)exceptionErrorList.getExceptions()[0]);
            throw badDataException;
        }
        return oS400SystemStatusProxy2;
    }

    private void loadSystemStatus(UserIdentity userIdentity, OS400SystemStatus oS400SystemStatus) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        SystemStatus systemStatus = new SystemStatus((AS400)wrappedAS400);
        systemStatus.setCaching(true);
        systemStatus.refreshCache();
        try {
            oS400SystemStatus.setName(wrappedAS400.getSystemName());
            oS400SystemStatus.setUsersCurrentSignedOn(systemStatus.getUsersCurrentSignedOn());
            oS400SystemStatus.setUsersTemporarilySignedOff(systemStatus.getUsersTemporarilySignedOff());
            oS400SystemStatus.setSuspendedBySystemRequest(systemStatus.getUsersSuspendedBySystemRequest());
            oS400SystemStatus.setUsersSignedOffWithPrinterOutputWaitingToPrint(systemStatus.getUsersSignedOffWithPrinterOutputWaitingToPrint());
            oS400SystemStatus.setBatchJobsWaitingForMessage(systemStatus.getBatchJobsRunning());
            oS400SystemStatus.setBatchJobsRunning(systemStatus.getBatchJobsRunning());
            oS400SystemStatus.setBatchJobsHeldWhileRunning(systemStatus.getBatchJobsHeldWhileRunning());
            oS400SystemStatus.setBatchJobsEnding(systemStatus.getBatchJobsEnding());
            oS400SystemStatus.setBatchJobsWaitingToRunOrAlreadyScheduled(systemStatus.getBatchJobsWaitingToRunOrAlreadyScheduled());
            oS400SystemStatus.setBatchJobsHeldOnJobQueue(systemStatus.getBatchJobsHeldOnJobQueue());
            oS400SystemStatus.setBatchJobsOnUnassignedJobQueue(systemStatus.getBatchJobsOnUnassignedJobQueue());
            oS400SystemStatus.setBatchJobsEndedWithPrinterOutputWaitingToPrint(systemStatus.getBatchJobsEndedWithPrinterOutputWaitingToPrint());
            oS400SystemStatus.setElapsedTime(systemStatus.getElapsedTime());
            oS400SystemStatus.setRestrictedStateFlag(systemStatus.getRestrictedStateFlag());
            oS400SystemStatus.setPercentProcessingUnitUsed(systemStatus.getPercentProcessingUnitUsed());
            oS400SystemStatus.setJobsInSystem(systemStatus.getJobsInSystem());
            oS400SystemStatus.setPercentPermanentAddresses(systemStatus.getPercentPermanentAddresses());
            oS400SystemStatus.setPercentTemporaryAddresses(systemStatus.getPercentTemporaryAddresses());
            oS400SystemStatus.setSystemASP(systemStatus.getSystemASP());
            oS400SystemStatus.setPercentSystemASPUsed(systemStatus.getPercentSystemASPUsed());
            oS400SystemStatus.setTotalAuxiliaryStorage(systemStatus.getTotalAuxiliaryStorage());
            oS400SystemStatus.setCurrentUnprotectedStorageUsed(systemStatus.getCurrentUnprotectedStorageUsed());
            oS400SystemStatus.setDateAndTimeStatusGathered(systemStatus.getDateAndTimeStatusGathered());
            oS400SystemStatus.setMaximumUnprotectedStorageUsed(systemStatus.getMaximumUnprotectedStorageUsed());
            oS400SystemStatus.setOS400SystemPools(this.getSystemPoolProxyList(systemStatus));
        }
        catch (Exception exception) {
            String string = "Error retrieving system status information";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private OS400SystemPoolProxy[] getSystemPoolProxyList(SystemStatus systemStatus) throws ResourceUnavailableException {
        SystemPool[] systemPoolArray = this.getSystemPools(systemStatus);
        OS400SystemPoolProxy[] oS400SystemPoolProxyArray = new OS400SystemPoolProxy[systemPoolArray.length];
        try {
            OS400SystemPoolProxy oS400SystemPoolProxy = null;
            for (int i = 0; i < systemPoolArray.length; ++i) {
                oS400SystemPoolProxy = new OS400SystemPoolProxy();
                oS400SystemPoolProxy.setPoolIdentifier(systemPoolArray[i].getPoolIdentifier());
                oS400SystemPoolProxy.setPoolName(systemPoolArray[i].getPoolName());
                oS400SystemPoolProxy.setPoolDescription(systemPoolArray[i].getDescription());
                oS400SystemPoolProxy.setPoolSize(systemPoolArray[i].getPoolSize());
                oS400SystemPoolProxy.setReservedSize(systemPoolArray[i].getReservedSize());
                oS400SystemPoolProxy.setMaximumActiveThreads(systemPoolArray[i].getMaximumActiveThreads());
                oS400SystemPoolProxy.setActiveToIneligle(systemPoolArray[i].getActiveToIneligible());
                oS400SystemPoolProxy.setActiveToWait(systemPoolArray[i].getActiveToWait());
                oS400SystemPoolProxy.setWaitToIneligle(systemPoolArray[i].getWaitToIneligible());
                oS400SystemPoolProxy.setDatabaseFaults(systemPoolArray[i].getDatabaseFaults());
                oS400SystemPoolProxy.setDatabasePages(systemPoolArray[i].getDatabasePages());
                oS400SystemPoolProxy.setNonDatabaseFaults(systemPoolArray[i].getNonDatabaseFaults());
                oS400SystemPoolProxy.setNonDatabasePages(systemPoolArray[i].getNonDatabasePages());
                oS400SystemPoolProxy.setPagingOption(systemPoolArray[i].getPagingOption());
                oS400SystemPoolProxy.setSubsystemName(systemPoolArray[i].getSubsystemName());
                oS400SystemPoolProxyArray[i] = oS400SystemPoolProxy;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to get the pool proxy list.", (Throwable)exception);
        }
        return oS400SystemPoolProxyArray;
    }

    private SystemPool[] getSystemPools(SystemStatus systemStatus) throws ResourceUnavailableException {
        SystemPool[] systemPoolArray = null;
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = systemStatus.getSystemPools();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            systemPoolArray = new SystemPool[arrayList.size()];
            arrayList.toArray(systemPoolArray);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to get a list of system pools.", (Throwable)exception);
        }
        return systemPoolArray;
    }

    @Override
    public OS400SystemStatus getSystemStatus(UserIdentity userIdentity) throws ResourceUnavailableException {
        OS400SystemStatus oS400SystemStatus = new OS400SystemStatus();
        this.loadSystemStatus(userIdentity, oS400SystemStatus);
        return oS400SystemStatus;
    }
}

