/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400ActiveJobProxy;
import com.helpsystems.common.as400.busobj.OS400Job;
import com.helpsystems.common.as400.dm.OS400JobAM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.Job;

public class OS400JobAMAS400
extends AbstractAS400Manager
implements OS400JobAM {
    public static final int END_IMMED = 0;
    public static final int END_CONTROLLED = -1;

    public OS400JobAMAS400(String string, String string2) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    @Override
    public void end(UserIdentity userIdentity, OS400Job oS400Job, int n) throws ResourceUnavailableException {
        this.end(userIdentity, oS400Job.getJobName(), oS400Job.getJobUser(), oS400Job.getJobNumber(), n);
    }

    @Override
    public void end(UserIdentity userIdentity, OS400ActiveJobProxy oS400ActiveJobProxy, int n) throws ResourceUnavailableException {
        this.end(userIdentity, oS400ActiveJobProxy.getJobName(), oS400ActiveJobProxy.getJobUser(), oS400ActiveJobProxy.getJobNumber(), n);
    }

    @Override
    public void hold(UserIdentity userIdentity, OS400Job oS400Job, boolean bl) throws ResourceUnavailableException {
        this.hold(userIdentity, oS400Job.getJobName(), oS400Job.getJobUser(), oS400Job.getJobNumber(), bl);
    }

    @Override
    public void hold(UserIdentity userIdentity, OS400ActiveJobProxy oS400ActiveJobProxy, boolean bl) throws ResourceUnavailableException {
        this.hold(userIdentity, oS400ActiveJobProxy.getJobName(), oS400ActiveJobProxy.getJobUser(), oS400ActiveJobProxy.getJobNumber(), bl);
    }

    @Override
    public void release(UserIdentity userIdentity, OS400Job oS400Job) throws ResourceUnavailableException {
        this.release(userIdentity, oS400Job.getJobName(), oS400Job.getJobUser(), oS400Job.getJobNumber());
    }

    @Override
    public void release(UserIdentity userIdentity, OS400ActiveJobProxy oS400ActiveJobProxy) throws ResourceUnavailableException {
        this.release(userIdentity, oS400ActiveJobProxy.getJobName(), oS400ActiveJobProxy.getJobUser(), oS400ActiveJobProxy.getJobNumber());
    }

    @Override
    public void end(UserIdentity userIdentity, String string, String string2, String string3, int n) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.createOneTimeUseConnection(userIdentity);
        Job job = new Job((AS400)wrappedAS400, string, string2, string3);
        try {
            job.end(n);
        }
        catch (AS400Exception aS400Exception) {
            String string4 = this.getAS400MessageText(aS400Exception, "ending");
            throw new ResourceUnavailableException(string4, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string5 = "Error ending job " + string3 + "/" + string2 + "/" + string + ".";
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    @Override
    public void hold(UserIdentity userIdentity, String string, String string2, String string3, boolean bl) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.createOneTimeUseConnection(userIdentity);
        Job job = new Job((AS400)wrappedAS400, string, string2, string3);
        try {
            job.hold(bl);
        }
        catch (AS400Exception aS400Exception) {
            String string4 = this.getAS400MessageText(aS400Exception, "holding");
            throw new ResourceUnavailableException(string4, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string5 = "Error holding job " + string3 + "/" + string2 + "/" + string + ".";
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    @Override
    public void release(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.createOneTimeUseConnection(userIdentity);
        Job job = new Job((AS400)wrappedAS400, string, string2, string3);
        try {
            job.release();
        }
        catch (AS400Exception aS400Exception) {
            String string4 = this.getAS400MessageText(aS400Exception, "releasing");
            throw new ResourceUnavailableException(string4, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string5 = "Error releasing job " + string3 + "/" + string2 + "/" + string + ".";
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private String getAS400MessageText(AS400Exception aS400Exception, String string) {
        AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string3 = aS400MessageArray[i].getID();
            String string4 = aS400MessageArray[i].getText();
            stringBuffer.append(string3 + " - " + string4 + string2);
        }
        String string5 = stringBuffer.toString().trim();
        if (string5.length() > 0) {
            return string5;
        }
        string5 = aS400Exception.getMessage();
        if (string5 != null && string5.trim().length() > 0) {
            return string5.trim();
        }
        return "Error " + string + " job.";
    }
}

