/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.IFSObject;
import com.helpsystems.common.as400.dm.IIFSFileManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class IFSFileManager
extends AbstractAS400Manager
implements IIFSFileManager {
    private static final Logger logger = Logger.getLogger(IFSFileManager.class);
    private static Comparator<IFSObject> ifsComparator = new IFSFileComparator();

    public IFSFileManager(String string) {
        super(string);
        this.setName("COMMON.IFSFileManager." + string);
    }

    @Override
    public boolean isValidDirectory(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, string);
            if (iFSFile.exists() && iFSFile.isDirectory()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Could not get an AS400 object from the pool.", (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return bl;
    }

    @Override
    public IFSObject[] getIFSList(UserIdentity userIdentity, IFSObject iFSObject, int n) throws ResourceUnavailableException {
        IFSObject[] iFSObjectArray;
        if (n != 123 && n != 124) {
            throw new IllegalArgumentException("Invalid list mode: " + n);
        }
        ArrayList<IFSObject> arrayList = new ArrayList<IFSObject>();
        ArrayList<IFSObject> arrayList2 = new ArrayList<IFSObject>();
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.createConnectionForUser(userIdentity);
            iFSObjectArray = iFSObject.getPath();
            IFSFile iFSFile = new IFSFile((AS400)wrappedAS400, (String)iFSObjectArray);
            if (!iFSFile.exists()) {
                throw new ResourceUnavailableException((String)iFSObjectArray + " does not exist.", null);
            }
            if (!iFSFile.isDirectory()) {
                throw new ResourceUnavailableException((String)iFSObjectArray + " is not a directory.", null);
            }
            iFSFile.setPatternMatching(1);
            IFSFile[] iFSFileArray = null;
            iFSFileArray = n == 123 ? iFSFile.listFiles((IFSFileFilter)new IFSDirFilter()) : iFSFile.listFiles();
            for (int i = 0; i < iFSFileArray.length; ++i) {
                IFSFile iFSFile2 = iFSFileArray[i];
                IFSObject iFSObject2 = new IFSObject(iFSFile2.getAbsolutePath(), iFSFile2.isDirectory());
                iFSObject2.setDirectory(iFSFile2.isDirectory());
                if (iFSObject2.isDirectory()) {
                    arrayList.add(iFSObject2);
                    continue;
                }
                arrayList2.add(iFSObject2);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to retrieve a file listing for " + (Object)((Object)iFSObject), (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        Collections.sort(arrayList, ifsComparator);
        Collections.sort(arrayList2, ifsComparator);
        iFSObjectArray = new IFSObject[arrayList.size() + arrayList2.size()];
        arrayList.toArray(iFSObjectArray);
        for (int i = 0; i < arrayList2.size(); ++i) {
            iFSObjectArray[i + arrayList.size()] = (IFSObject)((Object)arrayList2.get(i));
        }
        return iFSObjectArray;
    }

    class IFSDirFilter
    implements IFSFileFilter {
        IFSDirFilter() {
        }

        public boolean accept(IFSFile iFSFile) {
            try {
                if (!iFSFile.isDirectory()) {
                    return false;
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"", (Throwable)exception);
            }
            return true;
        }
    }

    static class IFSFileComparator
    implements Comparator<IFSObject> {
        IFSFileComparator() {
        }

        @Override
        public int compare(IFSObject iFSObject, IFSObject iFSObject2) {
            String string = iFSObject.getName().toUpperCase();
            String string2 = iFSObject2.getName().toUpperCase();
            return string.compareTo(string2);
        }
    }
}

