/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.server.file.FileBlock;
import com.helpsystems.common.server.file.FileHandle;
import com.ibm.as400.access.IFSRandomAccessFile;
import java.io.IOException;

public class AS400FileHandle
implements FileHandle {
    private IFSRandomAccessFile raf;

    AS400FileHandle(IFSRandomAccessFile iFSRandomAccessFile) {
        this.raf = iFSRandomAccessFile;
    }

    public void close() throws IOException {
        this.raf.close();
        try {
            ((WrappedAS400)this.raf.getSystem()).close();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error closing the AS400 connection.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public long getLength() throws IOException {
        return this.raf.length();
    }

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    public FileBlock read(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.raf.read(byArray);
        if (n2 == -1) {
            return FileBlock.EOF;
        }
        return new FileBlock(byArray, n2);
    }

    public void write(FileBlock fileBlock) throws IOException {
        this.raf.write(fileBlock.getBytes());
    }

    public String getAbsolutePath() {
        return this.raf.getPath();
    }
}

