/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.IAS400CommonPCMLManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;

public class AS400CommonPCMLManager
extends AbstractProgramCallManager
implements IAS400CommonPCMLManager {
    private String cachedName;
    private static final String PCML_RESOURCE = "com.helpsystems.common.as400.access.common";

    public AS400CommonPCMLManager(String string, String string2) throws PcmlException {
        super(PCML_RESOURCE, string2);
        this.setName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int retrievePartitionNumber() throws ResourceUnavailableException {
        int n;
        block9: {
            WrappedAS400 wrappedAS400 = null;
            try {
                ProgramCallDocument programCallDocument = this.pcml;
                synchronized (programCallDocument) {
                    wrappedAS400 = this.borrowConnection();
                    this.pcml.setSystem((AS400)wrappedAS400);
                    n = AS400CommonPCMLManager.retrievePartitionNumber(this.pcml);
                    if (wrappedAS400 == null) break block9;
                }
            }
            catch (Throwable throwable) {
                if (wrappedAS400 != null) {
                    this.releaseConnection(wrappedAS400);
                }
                throw throwable;
            }
            {
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw resourceUnavailableException;
                }
                catch (Exception exception) {
                    throw new ResourceUnavailableException("Unable to retrieve the partition number.", (Throwable)exception);
                }
            }
            this.releaseConnection(wrappedAS400);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String retrieveSystemName() throws ResourceUnavailableException {
        String string;
        block7: {
            if (this.cachedName != null) {
                return this.cachedName;
            }
            WrappedAS400 wrappedAS400 = null;
            try {
                ProgramCallDocument programCallDocument = this.pcml;
                synchronized (programCallDocument) {
                    wrappedAS400 = this.borrowConnection();
                    this.pcml.setSystem((AS400)wrappedAS400);
                    string = this.cachedName = AS400CommonPCMLManager.retrieveSystemName(this.pcml);
                    if (wrappedAS400 == null) break block7;
                }
            }
            catch (Throwable throwable) {
                if (wrappedAS400 != null) {
                    this.releaseConnection(wrappedAS400);
                }
                throw throwable;
            }
            this.releaseConnection(wrappedAS400);
        }
        return string;
    }

    public static String retrieveSystemName(AS400 aS400) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"As400", (Object)aS400);
        ProgramCallDocument programCallDocument = null;
        try {
            programCallDocument = new ProgramCallDocument(aS400, PCML_RESOURCE, AS400CommonPCMLManager.class.getClassLoader());
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to load the PCML resource.", (Throwable)exception);
        }
        return AS400CommonPCMLManager.retrieveSystemName(programCallDocument);
    }

    private static String retrieveSystemName(ProgramCallDocument programCallDocument) throws ResourceUnavailableException {
        try {
            Object object = AS400CommonPCMLManager.doCallAndReturn(programCallDocument, "RSL0010", "sysname");
            String string = object.toString();
            return string;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the system name.", (Throwable)exception);
        }
    }

    public static int retrievePartitionNumber(AS400 aS400) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"As400", (Object)aS400);
        if (aS400 == null) {
            throw new IllegalArgumentException("The AS400 passed in is null.");
        }
        ProgramCallDocument programCallDocument = null;
        try {
            programCallDocument = new ProgramCallDocument(aS400, PCML_RESOURCE, AS400CommonPCMLManager.class.getClassLoader());
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to load the PCML resource.", (Throwable)exception);
        }
        return AS400CommonPCMLManager.retrievePartitionNumber(programCallDocument);
    }

    private static int retrievePartitionNumber(ProgramCallDocument programCallDocument) throws ResourceUnavailableException {
        try {
            Object object = AS400CommonPCMLManager.doCallAndReturn(programCallDocument, "QWCRSSTS_SSTS0200", "Everything.PartitionIdentifier");
            int n = ((Number)object).intValue();
            return n;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the partition number.", (Throwable)exception);
        }
    }
}

