/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class GenericObjectPool
extends BaseObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private CursorableLinkedList _pool = null;
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;
    private Evictor _evictor = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this(poolableObjectFactory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, Config config) {
        this(poolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n) {
        this(poolableObjectFactory, n, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l) {
        this(poolableObjectFactory, n, by, l, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, 8, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2) {
        this(poolableObjectFactory, n, by, l, n2, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, n2, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2, long l2, int n3, long l3, boolean bl3) {
        this(poolableObjectFactory, n, by, l, n2, 0, bl, bl2, l2, n3, l3, bl3);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2, int n3, boolean bl, boolean bl2, long l2, int n4, long l3, boolean bl3) {
        this._factory = poolableObjectFactory;
        this._maxActive = n;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this._maxWait = l;
        this._maxIdle = n2;
        this._minIdle = n3;
        this._testOnBorrow = bl;
        this._testOnReturn = bl2;
        this._timeBetweenEvictionRunsMillis = l2;
        this._numTestsPerEvictionRun = n4;
        this._minEvictableIdleTimeMillis = l3;
        this._testWhileIdle = bl3;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int n) {
        this._maxActive = n;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long l) {
        this._maxWait = l;
        this.notifyAll();
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized void setMaxIdle(int n) {
        this._maxIdle = n;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int n) {
        this._minIdle = n;
        this.notifyAll();
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public synchronized boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this._testOnBorrow = bl;
    }

    public synchronized boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this._testOnReturn = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this._timeBetweenEvictionRunsMillis = l;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this._numTestsPerEvictionRun = n;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this._minEvictableIdleTimeMillis = l;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this._testWhileIdle = bl;
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMinIdle(config.minIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object borrowObject() throws Exception {
        long l = System.currentTimeMillis();
        boolean bl = false;
        block24: while (true) {
            GenericObjectPool genericObjectPool;
            ObjectTimestampPair objectTimestampPair = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                this.assertOpen();
                try {
                    objectTimestampPair = (ObjectTimestampPair)this._pool.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (null == objectTimestampPair && this._maxActive > 0 && this._numActive >= this._maxActive) {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this._maxWait > 0L && System.currentTimeMillis() - l >= this._maxWait) {
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            continue block24;
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
                ++this._numActive;
            }
            if (null == objectTimestampPair) {
                try {
                    Object object = this._factory.makeObject();
                    objectTimestampPair = new ObjectTimestampPair(object);
                    bl = true;
                }
                catch (Exception exception) {
                    genericObjectPool = this;
                    synchronized (genericObjectPool) {
                        --this._numActive;
                        this.notifyAll();
                        throw exception;
                    }
                }
            }
            try {
                this._factory.activateObject(objectTimestampPair.value);
                if (!this._testOnBorrow || this._factory.validateObject(objectTimestampPair.value)) return objectTimestampPair.value;
                throw new Exception("validateObject failed");
            }
            catch (Exception exception) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                    this.notifyAll();
                }
                try {
                    this._factory.destroyObject(objectTimestampPair.value);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (bl) throw new NoSuchElementException("Could not create a validated object");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object) throws Exception {
        GenericObjectPool genericObjectPool;
        this.assertOpen();
        try {
            this._factory.destroyObject(object);
            Object var3_2 = null;
            genericObjectPool = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                --this._numActive;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (genericObjectPool) {
            --this._numActive;
            this.notifyAll();
        }
    }

    public synchronized void clear() {
        this.assertOpen();
        Iterator iterator = this._pool.iterator();
        while (iterator.hasNext()) {
            try {
                this._factory.destroyObject(((ObjectTimestampPair)iterator.next()).value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            iterator.remove();
        }
        this._pool.clear();
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    public synchronized int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        this.assertOpen();
        boolean bl = true;
        if (this._testOnReturn && !this._factory.validateObject(object)) {
            bl = false;
        } else {
            try {
                this._factory.passivateObject(object);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        boolean bl2 = !bl;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            --this._numActive;
            if (this._maxIdle >= 0 && this._pool.size() >= this._maxIdle) {
                bl2 = true;
            } else if (bl) {
                this._pool.addFirst((Object)new ObjectTimestampPair(object));
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this._factory.destroyObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
        this.startEvictor(-1L);
        super.close();
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }

    public synchronized void evict() throws Exception {
        this.assertOpen();
        if (!this._pool.isEmpty()) {
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._pool.size());
            } else if (!this._evictionCursor.hasPrevious()) {
                this._evictionCursor.close();
                this._evictionCursor = this._pool.cursor(this._pool.size());
            }
            int n = 0;
            int n2 = this.getNumTests();
            while (n < n2) {
                if (!this._evictionCursor.hasPrevious()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._pool.size());
                } else {
                    boolean bl = false;
                    ObjectTimestampPair objectTimestampPair = (ObjectTimestampPair)this._evictionCursor.previous();
                    if (this._minEvictableIdleTimeMillis > 0L && System.currentTimeMillis() - objectTimestampPair.tstamp > this._minEvictableIdleTimeMillis) {
                        bl = true;
                    } else if (this._testWhileIdle) {
                        boolean bl2 = false;
                        try {
                            this._factory.activateObject(objectTimestampPair.value);
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                        if (bl2) {
                            if (!this._factory.validateObject(objectTimestampPair.value)) {
                                bl = true;
                            } else {
                                try {
                                    this._factory.passivateObject(objectTimestampPair.value);
                                }
                                catch (Exception exception) {
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (bl) {
                        try {
                            this._evictionCursor.remove();
                            this._factory.destroyObject(objectTimestampPair.value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++n;
            }
        }
    }

    private void ensureMinIdle() throws Exception {
        int n = this.calculateDeficit();
        int n2 = 0;
        while (n2 < n && this.calculateDeficit() > 0) {
            this.addObject();
            ++n2;
        }
    }

    private synchronized int calculateDeficit() {
        int n = this.getMinIdle() - this.getNumIdle();
        if (this._maxActive > 0) {
            int n2 = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle());
            n = Math.min(n, n2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        Object object = this._factory.makeObject();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            ++this._numActive;
            this.returnObject(object);
        }
    }

    protected synchronized void startEvictor(long l) {
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
        if (l > 0L) {
            this._evictor = new Evictor(l);
            Thread thread = new Thread(this._evictor);
            thread.setDaemon(true);
            thread.start();
        }
    }

    synchronized String debugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active: ").append(this.getNumActive()).append("\n");
        stringBuffer.append("Idle: ").append(this.getNumIdle()).append("\n");
        stringBuffer.append("Idle Objects:\n");
        Iterator iterator = this._pool.iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            ObjectTimestampPair objectTimestampPair = (ObjectTimestampPair)iterator.next();
            stringBuffer.append("\t").append(objectTimestampPair.value).append("\t").append(l - objectTimestampPair.tstamp).append("\n");
        }
        return stringBuffer.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    public static class Config {
        public int maxIdle = 8;
        public int minIdle = 0;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    class Evictor
    implements Runnable {
        private boolean _cancelled = false;
        private long _delay = 0L;

        public Evictor(long l) {
            this._delay = l;
        }

        void cancel() {
            this._cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._cancelled) {
                try {
                    Thread.sleep(this._delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    GenericObjectPool.this.evict();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    GenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GenericObjectPool genericObjectPool = GenericObjectPool.this;
            synchronized (genericObjectPool) {
                if (null != GenericObjectPool.this._evictionCursor) {
                    GenericObjectPool.this._evictionCursor.close();
                    GenericObjectPool.this._evictionCursor = null;
                }
            }
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object object) {
            this(object, System.currentTimeMillis());
        }

        ObjectTimestampPair(Object object, long l) {
            this.value = object;
            this.tstamp = l;
        }
    }
}

