/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.core.util.HttpClientSession;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ThreadSession;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class WebBundleHandler
extends ResourceBundleHandler {
    private static final String BASE_URL = HSJvmProperties.getRbhUrl();
    private static final int EXPIRE_TIME = 2000;
    private static Map<String, String> cache = new HashMap<String, String>();
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static long lastAccess;
    private static boolean firstInstance;
    private Fetcher fetcher;
    private String fullClassName;

    protected WebBundleHandler(String string) {
        super(string, false);
        WebBundleHandler.checkIfFirstInstace();
        this.fullClassName = string;
        if (BASE_URL != null) {
            String string2 = BASE_URL.toUpperCase();
            if (string2.startsWith("HTTP")) {
                this.fetcher = new HttpFetcher();
            } else {
                throw new RuntimeException("Unknown protocol in BASE_URL: " + BASE_URL);
            }
        }
    }

    private static synchronized void checkIfFirstInstace() {
        if (firstInstance) {
            firstInstance = false;
            Thread thread = new Thread(new WebRBHCacheEvictor());
            thread.setDaemon(true);
            thread.setName("WebRBHCacheEvictor");
            thread.setPriority(1);
            thread.start();
        }
    }

    @Override
    protected String getString(String string) {
        block3: {
            ThreadSession threadSession = ThreadSession.getSession();
            if (threadSession != null) {
                Locale locale = threadSession.getLocale();
                try {
                    return this.getObject(string, locale);
                }
                catch (RuntimeException runtimeException) {
                    if (!DEFAULT_LOCALE.equals(locale)) break block3;
                    throw runtimeException;
                }
            }
        }
        return this.getObject(string, DEFAULT_LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getObject(String string, Locale locale) {
        Locale locale2 = null;
        locale2 = locale == null ? DEFAULT_LOCALE : locale;
        String string2 = locale2.getLanguage();
        String string3 = null;
        String string4 = string2 + string;
        Object object = cache;
        synchronized (object) {
            string3 = cache.get(string4);
            lastAccess = System.currentTimeMillis();
        }
        if (string3 == null) {
            object = this.guessProduct();
            String string5 = this.guessVersion();
            String string6 = ResourceBundleHandler.extractPackageName(this.fullClassName) + "." + string;
            try {
                string3 = this.fetcher.fetch((String)object, string5, string2, string6);
                Map<String, String> map = cache;
                synchronized (map) {
                    cache.put(string4, string3);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to lookup message " + string, exception);
            }
        }
        if (HSJvmProperties.isTestingI18N()) {
            string3 = "(" + string3 + ")";
        }
        return string3;
    }

    private String guessProduct() {
        if (this.fullClassName.startsWith("com.helpsystems.common")) {
            return "COM";
        }
        if (this.fullClassName.startsWith("com.helpsystems.schedule")) {
            return "SCH";
        }
        if (this.fullClassName.startsWith("com.helpsystems.network")) {
            return "NET";
        }
        if (this.fullClassName.startsWith("com.helpsystems.schent")) {
            return "RBE";
        }
        throw new RuntimeException("Unable to guess product for " + this.fullClassName);
    }

    private String guessVersion() {
        if (this.fullClassName.startsWith("com.helpsystems.common")) {
            return "5";
        }
        if (this.fullClassName.startsWith("com.helpsystems.schedule")) {
            return "10";
        }
        if (this.fullClassName.startsWith("com.helpsystems.network")) {
            return "10";
        }
        if (this.fullClassName.startsWith("com.helpsystems.schent")) {
            return "1";
        }
        throw new RuntimeException("unable to guess version for " + this.fullClassName);
    }

    static {
        firstInstance = true;
    }

    static class HttpFetcher
    implements Fetcher {
        private HttpClientSession httpHelper = new HttpClientSession();

        HttpFetcher() {
            this.httpHelper.setCharset("utf-8");
        }

        @Override
        public String fetch(String string, String string2, String string3, String string4) throws Exception {
            URL uRL = new URL(BASE_URL + "?k=" + URLEncoder.encode(string4) + "&p=" + URLEncoder.encode(string) + "&v=" + URLEncoder.encode(string2) + "&l=" + URLEncoder.encode(string3));
            return this.httpHelper.fetch(uRL, "GET");
        }
    }

    static class WebRBHCacheEvictor
    implements Runnable {
        WebRBHCacheEvictor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                Map map = cache;
                synchronized (map) {
                    if (lastAccess + 2000L < l) {
                        cache.clear();
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    static interface Fetcher {
        public String fetch(String var1, String var2, String var3, String var4) throws Exception;
    }
}

