/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.ObjectNameValidator;
import java.util.Set;
import junit.framework.TestCase;

public class ObjectNameValidatorTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNullIsNotAValidName() {
        try {
            ObjectNameValidator.chkValidHSName(null);
            ObjectNameValidatorTest.fail((String)"chkValidHSName() accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBlankIsNotAValidName() {
        try {
            ObjectNameValidator.chkValidHSName("    ");
            ObjectNameValidatorTest.fail((String)"chkValidHSName() accepted blank value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLengthCannotExceedTenCharacters() {
        try {
            ObjectNameValidator.chkValidHSName("ABCDEFGHIJK");
            ObjectNameValidatorTest.fail((String)"chkValidHSName() accepted value too long for name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFirstCharacterOfNameMustBeALetter() {
        try {
            ObjectNameValidator.chkValidHSName("0ABC");
            ObjectNameValidatorTest.fail((String)"chkValidHSName() accepted value that does not start with a letter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAllCharactersMustBeValid() {
        try {
            ObjectNameValidator.chkValidHSName("ABC!DEF");
            ObjectNameValidatorTest.fail((String)"chkValidHSName() accepted value that contains an invalid character");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNamesCanContainAnyLetterNumberOrUnderscore() {
        ObjectNameValidator.chkValidHSName("ABCDE0");
        ObjectNameValidator.chkValidHSName("FGHIJ1");
        ObjectNameValidator.chkValidHSName("KLMNO2");
        ObjectNameValidator.chkValidHSName("PQRST3");
        ObjectNameValidator.chkValidHSName("UVWXY4");
        ObjectNameValidator.chkValidHSName("Z56789_");
    }

    public void testDeprecatedMethod() {
        Set<Character> set = ObjectNameValidator.getAllPossibleValidObjectOrLibraryNameCharacters();
        ObjectNameValidatorTest.assertTrue((set.size() > 30 ? 1 : 0) != 0);
    }
}

